<?php
/**
 * Groups Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;
require_once APPPATH."libraries/BaseController.php";
class Groups extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Groups_model');
	}
	
	public function index() {
		$data['content_title'] = 'Grup';
		$this->twiggy_display('adm/groups/index', $data);
	}

	public function get_data() {
		$data = [];
		$get_data = $this->Groups_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$data[] = array(
					'no'        => $no,
					'id'        => $get_row->group_id,
					'name'      => $get_row->group_name,
					'order'      => $get_row->group_order,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_data_child() {
		$data = [];

		$id		 	= $this->input->post('id');
		$where		= array('a.group_id' => $id);

		$get_data 	= $this->Groups_model->get_data_child($where)->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$data[] = array(
					'no'        => $no,
					'id'        => $get_row->group_child_id,
					'name'      => $get_row->group_child_name,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('group_id' => $id);
			$get_data = $this->Groups_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/groups/edit', $data);
	}

	public function edit_child($id='new', $group='') {
		$title    = "Tambah";
		$get_data = array();

		$where    = array('group_id' => $group);
		$get_data = $this->Groups_model->get_data($where)->row_array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('group_child_id' => $id);
			$get_data = $this->Groups_model->get_data_child($where)->row_array();
		}

		$data['id']            = $id;
		$data['group_id']      = $get_data['group_id'];
		$data['group_name']    = $get_data['group_name'];
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/groups/edit_child', $data);
	}

	public function save() {
		// post
		$id        = $this->input->post('id');
		$name      = $this->input->post('name');
		$order      = $this->input->post('order');
		$action    = $this->input->post('action');

		$data_save = array(
			'group_name'  => $name,
			'group_order' => $order,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Groups_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Groups_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function save_child() {
		// post
		$id        = $this->input->post('id');
		$group_id    = $this->input->post('gid');
		$group_name  = $this->input->post('gnm');
		$name      = $this->input->post('name');
		$action    = $this->input->post('action');

		$data_save = array(
			'group_child_name'  => $name,
			'group_id'   		=> $group_id,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Groups_model->save_child($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Groups_model->update_child($id, $data_save);
		}


		// echo $convert;
		// die();
		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert,				
				'gid'     => $group_id,				
				'gnm'     => $group_name,
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert,				
				'gid'     => $group_id,				
				'gnm'     => $group_name,
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Groups_model->delete($row);
		}

		if($delete_type){
			foreach($id as $row) {
				$delete_type_child = $this->Groups_model->delete_child_group($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function delete_child() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Groups_model->delete_child($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$table = 'master_groups';
		$name  = $this->input->post('id');
		$where = array('group_name' => $name);

		$check = $this->Groups_model->check_id($table, $where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

	public function check_child_id() {
		$table = 'master_group_childs';
		$name  = $this->input->post('id');
		$where = array('group_child_name' => $name);

		$check = $this->Groups_model->check_id($table, $where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
