<?php

/**
 * Pabrik Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Pabrik extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Pabrik_model');
	}

	public function index()
	{
		$data['content_title'] = 'Pabrik';

		$this->twiggy_display('adm/pabrik/index', $data);
	}

	public function get_data()
	{
		$data = [];
		$get_data = $this->Pabrik_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'       => $no,
					'id' => $get_row->id_pabrik,
					'kode_pabrik'       => $get_row->kode_pabrik,
					'nama_pabrik'     => $get_row->nama_pabrik,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('id_pabrik' => $id);
			$get_data = $this->Pabrik_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/pabrik/edit', $data);
	}

	public function save()
	{
		// post
		$id       = $this->input->post('id');
		$kode_pabrik     = $this->input->post('kode_pabrik');
		$nama_pabrik     = $this->input->post('nama_pabrik');
		
		// $priority = $this->input->post('priority');
		$action   = $this->input->post('action');

		$data_save = array(
			'kode_pabrik' => $kode_pabrik,
			'nama_pabrik'     => $nama_pabrik,
			
			// 'supplier_priority' => 0
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Pabrik_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Pabrik_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Pabrik_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$name  = $this->input->post('id');
		$where = array('nama_pabrik' => $name);

		$check = $this->Pabrik_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
