<?php

/**
 * Colors Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Penjualan_pdf extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();
        $this->load->helper('download');
		// load model
		$this->load->model('Penjualan_pdf_model');
	}

	public function index()
	{
		$data['content_title'] = 'Penjualan PDF';

		$this->twiggy_display('adm/penjualan_pdf/index', $data);
	}

	public function get_data()
	{
		$data = [];
		$get_data = $this->Penjualan_pdf_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'       => $no,
					'id'       => $get_row->pdf_id,
					'no_pesanan'     => $get_row->no_pesanan,
					'pdf_file_name'     => $get_row->pdf_file_name,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	 public function print($id) {
	     $get_data = $this->Penjualan_pdf_model->get_data(array('pdf_id' => $id))->row();
        // Set the file path
        $file_path = $get_data->pdf_file_name;

        // Check if the file exists
        if (file_exists($file_path)) {
            // Load the file helper and force download the file
            force_download($file_path, NULL);
        } else {
            show_404(); // File not found, return a 404 error
        }
    }

// 	public function edit($id = 'new')
// 	{
// 		$title    = "Tambah";
// 		$get_data = array();

// 		if ($id != 'new') {
// 			$title    = "Edit";
// 			$where = array('color_id' => $id);
// 			$get_data = $this->Colors_model->get_data($where)->row_array();
// 		}

// 		$data['id']            = $id;
// 		$data['content_title'] = $title;
// 		$data['get_data']      = $get_data;

// 		$this->twiggy_display('adm/colors/edit', $data);
// 	}

// 	public function save()
// 	{
// 		// post
// 		$id       = $this->input->post('id');
// 		$name     = $this->input->post('name');
// 		$action   = $this->input->post('action');

// 		$data_save = array(
// 			'color_name'     => $name,
// 		);

// 		if ($id == 'new') {
// 			$convert = convert_button($action, $id);
// 			$save = $this->Colors_model->save($data_save);
// 		} else {
// 			$convert = convert_button($action, $id);
// 			$save = $this->Colors_model->update($id, $data_save);
// 		}

// 		if ($save) {
// 			$response = array(
// 				'status'  => 'success',
// 				'message' => 'Berhasil menyimpan data',
// 				'id'      => $convert
// 			);
// 		} else {
// 			$response = array(
// 				'status'  => 'error',
// 				'message' => 'Gagal menyimpan data',
// 				'id'      => $convert
// 			);
// 		}

// 		output_json($response);
// 	}

// 	public function delete()
// 	{
// 		$id = $this->input->post('id');

// 		foreach ($id as $row) {
// 			$delete_type = $this->Colors_model->delete($row);
// 		}

// 		$response = array(
// 			'message' => 'Berhasil menghapus data',
// 			'status'  => 'success'
// 		);

// 		output_json($response);
// 	}

// 	public function check_id()
// 	{
// 		$name  = $this->input->post('id');
// 		$where = array('color_name' => $name);

// 		$check = $this->Colors_model->check_id($where);

// 		if ($check) {
// 			$response = array('status' => true);
// 		} else {
// 			$response = array('status' => false);
// 		}

// 		output_json($response);
// 	}
}
