<?php

/**
 * Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Purchase extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Purchase_model');
		$this->load->model('Customers_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Pembelian';

		$this->twiggy_display('adm/purchase/index', $data);
	}

	public function get_data_header()
	{
		$data = [];

		$get_data = $this->Purchase_model->purchase_header()->result();
		if (logged_user('role') != 1) {
			$get_data = $this->Purchase_model->purchase_header(array('division' => logged_user('division')))->result();
		}
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->id,
					'number'      => $get_row->number,
					'date'        => indonesian_date($get_row->date),
					'supplier'    => $get_row->supplier_name,
					'total'       => number_format($get_row->total),
					'description' => $get_row->description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title       = "Tambah Pembelian";
		$header_data = array(null);
		$ppn_amount  = 0;
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		$prefix  = "PO100";
		$datenow = date('Ym');
		$number_generator = $this->Purchase_model->purchase_autonumber();
		$autonumber = $prefix.$datenow.'-'.$number_generator;
// 		$autonumber = '';

		$date_text = date_now();
		$tmstamp   = date("H:i:s");

		if ($id != 'new') {
			$title       = "Edit Pembelian";
			$where       = array('id' => $id);
			$header_data = $this->Purchase_model->purchase_header($where)->row_array();
			$date_text   = $header_data['date'];
			$autonumber   = $header_data['number'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		$data['ppn_amount']    = $ppn_amount;


		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/purchase/edit', $data);
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('header_id' => $id);
		// $order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Purchase_model->purchase_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->id,
					'detail_header_id' => $get_row->header_id,
					'id'               => $get_row->item_id,
					'code'             => $get_row->it_code,
					'name'             => $get_row->it_name,
					'lg_unit'          => $get_row->unit,
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'      => to_decimal($get_row->quantity),
					'lg_unit_prc'      => number_format($get_row->price),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
					'result_large'     => $get_row->price,
					'md_unit'          => '',
					'md_unit_cnt'      => 0,
					'md_unit_qty'      => 0,
					'md_unit_prc'      => 0,
					'md_unit_slg'      => 0,
					'result_medium'    => 0,
					'sm_unit'          => '',
					'sm_unit_cnt'      => 0,
					'sm_unit_qty'      => 0,
					'sm_unit_prc'      => 0,
					'sm_unit_slg'      => 0,
					'result_small'     => 0,
					'discount'         => to_decimal($get_row->discount_percentage),
					'discount_total'   => number_format($get_row->discount_amount),
					'total'            => number_format($get_row->amount),

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/purchase/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		// $get_data  = $this->Items_model->get_data_search($search)->result();

		$get_data  = $this->Items_model->get_data_search($search)->result();

		

		$no = 0;
		foreach ($get_data as $get_row) {
			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'code'             => $get_row->item_code,
				'name'             => $get_row->item_name,
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_prc'      => number_format($get_row->last_selling_price_large_unit),
				'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				'md_unit'          => "",
				'md_unit_cnt'      => to_decimal(0),
				'md_unit_prc'      => number_format(0),
				'md_unit_slg'      => number_format(0),
				'sm_unit'          => "",
				'sm_unit_cnt'      => to_decimal(0),
				'sm_unit_prc'      => number_format(0),
				'sm_unit_slg'      => number_format(0),
				'btncolor'         => '',
				'btnicon'          => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	public function get_data_barcode()
	{
		$data = [];
		$response = [];
		$barcode   = $this->input->post('barcode');

		$get_data  = $this->Items_model->get_data_search($barcode)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			
			
// 			$where = array('item_id' => $get_row->item_id);
// 		    $where_so = array('selling_order_detail_item_id' => $get_row->item_id);
//             $get_po = $this->Report_stock_model->get_purchase_detail_lite($where, '', 'item_id')->row();
// 			$get_so = $this->Report_stock_model->get_sales_detail_lite($where_so, '', 'selling_order_detail_item_id')->row();
// 			$get_st = $this->Report_stock_model->get_stock_detail_lite($where, '', 'item_id')->row();

// 			$stock_po = 0;
// 			$stock_so = 0;
// 			$stock_st = 0;

// 			if ($get_po) {
// 				$stock_po = $get_po->s_quantity;
// 			}

// 			if ($get_so) {
// 				$stock_so = $get_so->s_quantity;
// 			}

// 			if ($get_st) {
// 				$stock_st = $get_st->s_quantity;
// 			}

			if($get_row->item_code == $barcode){
				$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'name'             => $get_row->item_name,
				'code'             => $get_row->item_code,
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_qty_old'=> 0,
				'lg_unit_qty'=> 1,
				'lg_unit_prc'      =>  number_format($get_row->last_selling_price_large_unit),
				// 'stock'            => $stock_po + $stock_st - $stock_so,
				'tipe_barcode' => 'besar',
				'total_small' => 0,
				'total_medium' => 0,
				'total_large' => 0,
				'btncolor'         => '',
				'btnicon'          => '',
				);
			}

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");

		$arr_supplier = explode(':', $supplier);
		// echo json_encode($arr[1]);
		// die();
		$vuedata  = $this->input->post('vuedata');
		
// 		var_dump($vuedata);

		$header_id = $id;

		$header_data = [
			'date'          => change_format_date($date),
			'number'        => $number,
			'supplier_id'   => $arr_supplier[0],
			'supplier_name' => $arr_supplier[1],
			'total'         => trims($grand_total),
			'user_id'       => 1,
			'description'   => $description,
			'division'      => logged_user('division')
		];

		$detail_data = [];

		// if save $id = new else update data
		if ($vuedata) {
			if ($id == "new") {
				// save header
				$save_header  = $this->Purchase_model->save_header($header_data);

				if ($save_header) {
					$header_id = $this->db->insert_id();

					foreach ($vuedata as $row) {
						$detail_data[] = [
							'header_id'           => $header_id,
							'item_id'             => $row['id'],
							'item_code'           => $row['code'],
							'item_name'           => $row['name'],
							'quantity'            => trims($row['lg_unit_qty']),
							'unit'                => $row['lg_unit'],
							'price'               => trims($row['lg_unit_prc']),
							'discount_percentage' => trims($row['discount']),
							'discount_amount'     => trims($row['discount_total']),
							'amount'              => trims($row['total']),
							'division'			  => logged_user('division')
						];
					}

					$save_detail = $this->Purchase_model->save_detail($detail_data, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$delete_detail = $this->Purchase_model->delete_detail($id);

				if ($delete_detail) {

					$save_header  = $this->Purchase_model->update_header($id, $header_data);

					if ($save_header) {

						foreach ($vuedata as $row) {
							$detail_data[] = [
								'header_id'           => $header_id,
								'item_id'             => $row['id'],
								'item_code'           => $row['code'],
								'item_name'           => $row['name'],
								'quantity'            => trims($row['lg_unit_qty']),
								'unit'                => $row['lg_unit'],
								'price'               => trims($row['lg_unit_prc']),
								'discount_percentage' => trims($row['discount']),
								'discount_amount'     => trims($row['discount_total']),
								'amount'              => trims($row['total']),
								'division'		      => logged_user('division')
							];
						}

						$save_detail = $this->Purchase_model->save_detail($detail_data, true);

						if ($save_detail) {
							$msg    = "Berhasil menyimpan data";
							$status = "success";
						} else {
							$msg    = "Gagal menyimpan data #LOG-U01";
							$status = "error";
						}
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'detail_data'  => $detail_data,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {

			$delete_header = $this->Purchase_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Purchase_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header  = array('purchase_order_header_id' => $id);
		$where_detail  = array('purchase_order_detail_header_id' => $id);
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');


		$header = $this->Purchase_model->purchase_header($where_header)->row_array();
		$detail = $this->Purchase_model->purchase_detail2($where_detail, 'group_order asc, item_name')->result();

		$data['content_title'] = 'Print Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;
		// $data['config_receipt2'] = $config_receipt2;

		$this->twiggy_display('adm/purchase/print_out', $data);
	}
}
