<?php

/**
 * report_courrier PPN Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class report_courrier extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title']    = 'Laporan Kurir';

		$this->twiggy_display('adm/report_courrier/index', $data);
	}

	public function get_data()
	{
		$date_1   = $this->input->post("date_1");
		$date_2   = $this->input->post("date_2");
		$status = $this->input->post("status");

		$data  = [];
		$where = [];
		$total_outcome = 0;

		if (isset($date_1) && $date_1 != '') {
			$where['date >='] = change_format_date($date_1);
		}
		if (isset($date_2) && $date_2 != '') {
			$where['date <='] = change_format_date($date_2);
		}
		if (isset($status) && $status != '' && $status != '- Pilih -') {
			$where['status'] = $status;
		}

		$data = [];

		$get_data = $this->Sales_model->sales_header($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$bgcolor = ($get_row->status == "1" ? "bg-success" : "");
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->id,
					'number'       => $get_row->number,
					'number_order' => $get_row->number_order,
					'number_resi'  => $get_row->number_resi,
					'courrier'      => $get_row->courier,
					'date'         => indonesian_date($get_row->date),
					'customer'     => $get_row->cs_name,
					'total'        => number_format($get_row->total),
					'dropshipper'  => $get_row->dropshipper,
					'status'       => $get_row->status,
					'bgcolor'      => $bgcolor
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
}
