<?php

/**
 * Report_purchase PPN Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Report_stock extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Report_stock_model');
		$this->load->model('Items_model');
		
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title']    = 'Laporan Stok';

		$data['group_data'] = $this->Report_stock_model->get_group()->result();
		$data['type_data']  = $this->Report_stock_model->get_type()->result();
		$data['color_data'] = $this->Report_stock_model->get_color()->result();
		$data['size_data']  = $this->Report_stock_model->get_size()->result();

		$this->twiggy_display('adm/report_stock/index', $data);
	}
	public function card()
	{
		$data['content_title']    = 'Laporan Kartu Stok';
            $data['item_data']     = $this->Items_model->get_data()->result();
		$data['group_data'] = $this->Report_stock_model->get_group()->result();
		$data['type_data']  = $this->Report_stock_model->get_type()->result();
		$data['color_data'] = $this->Report_stock_model->get_color()->result();
		$data['size_data']  = $this->Report_stock_model->get_size()->result();

		$this->twiggy_display('adm/report_stock/card', $data);
	}

	public function get_data()
	{
		$date_1 = $this->input->post("date_1");
		$group  = $this->input->post("group");
		$type   = $this->input->post("type");
		$color  = $this->input->post("color");
		$size   = $this->input->post("size");
		$val    = $this->input->post("val");
		$stock    = $this->input->post("stock");

		$data  = [];
		$where = [];
		$total_outcome = 0;

// 		if (isset($date_1) && $date_1 != '') {
// 			$where['selling_order_header_date <='] = change_format_date($date_1);
// 		}
		if (isset($group) && $group != '' && $group != '- Pilih -') {
			$where['item_group_id'] = $group;
		}
		if (isset($type) && $type != '' && $type != '- Pilih -') {
			$where['item_type_id'] = $type;
		}
		if (isset($color) && $color != '' && $color != '- Pilih -') {
			$where['item_color_id'] = $color;
		}
		if (isset($size) && $size != '' && $size != '- Pilih -') {
			$where['item_size_id'] = $size;
		}
		
		
        if ($val == "item") {
			$this->perItem($where,$date_1,$stock);
		}
		if ($val == "group") {
			$this->getGroup($where);
		}

		if ($val == "type") {
			$this->getType($where);
		}

		if ($val == "color") {
			$this->getColor($where);
		}

		if ($val == "size") {
			$this->getSize($where);
		}
	}

	

	public function getType($where)
	{
		$get_data = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'group_id')->result();

		$data = [];
		if ($get_data) {
			$no = 1;

			$a = 0;
			$b = 0;
			foreach ($get_data as $k => $get_row) {

				$where['item_group_id'] = $get_row->group_id;
				$get_sales_header = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'group_id')->row();
				$get_stock_header = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'group_id')->row();
				$sales_qty = 0;
				$stock_qty = 0;
				if ($get_sales_header) {
					$sales_qty = $get_sales_header->s_quantity;
				}
				if ($get_stock_header) {
					$stock_qty = $get_stock_header->s_quantity;
				}
				$stock = ($get_row->s_quantity - $sales_qty + ($stock_qty));
				$harga = ($get_row->s_amount / $get_row->s_quantity);
				$total = $stock * $harga;
				$data[] = array(
					'no'          => $no,
					'grand_stok'  => number_format($a += $stock),
					'grand_total' => number_format($b += $total),
				);


				$det = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'type_id')->result();

				$no_det = 1;
				foreach ($det as $key => $value) {
					$where['item_type_id'] = $value->type_id;
					$get_selling_order_details = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'type_id')->row();
					$get_stock_detail = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'type_id')->row();
					$sales_qty_detail = 0;
					$stock_qty_detail = 0;
					if ($get_selling_order_details) {
						$sales_qty_detail = $get_selling_order_details->s_quantity;
					}
					if ($get_stock_detail) {
						$stock_qty_detail = $get_stock_detail->s_quantity;
					}

					$stock = ($value->s_quantity - $sales_qty_detail + ($stock_qty_detail));
					$harga = ($value->s_amount / $value->s_quantity);
					$total = $stock * $harga;

					$data[$k]['detail'][$key] = array(
						'no_det' => $no_det,
						'date'   => change_format_date($value->date, 'd/m/Y'),
						'group'  => $value->group_name,
						'type'   => $value->type_name,
						'stok'   => number_format($stock),
						'harga'  => number_format($harga),
						'total'  => number_format($total),
					);
					$no_det++;
				}
				unset($where['item_type_id']);
				$no++;
				$a = 0;
				$b = 0;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getColor($where)
	{
		$get_data = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'group_id')->result();

		$data = [];
		if ($get_data) {
			$no = 1;

			$a = 0;
			$b = 0;
			foreach ($get_data as $k => $get_row) {
				$where['item_group_id'] = $get_row->group_id;
				$get_sales_header = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'group_id')->row();
				$get_stock_header = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'group_id')->row();
				$sales_qty = 0;
				$stock_qty = 0;
				if ($get_sales_header) {
					$sales_qty = $get_sales_header->s_quantity;
				}
				if ($get_stock_header) {
					$stock_qty = $get_stock_header->s_quantity;
				}
				$stock = ($get_row->s_quantity - $sales_qty + ($stock_qty));
				$harga = ($get_row->s_amount / $get_row->s_quantity);
				$total = $stock * $harga;
				$data[] = array(
					'no'          => $no,
					'grand_stok'  => number_format($a += $stock),
					'grand_total' => number_format($b += $total),
				);

				// $where['item_color_id'] = $get_row->color_id;
				$det = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'color_id')->result();
				// unset($where['item_color_id']);
				$no_det = 1;
				foreach ($det as $key => $value) {
					$where['item_color_id'] = $value->color_id;
					$get_selling_order_details = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'color_id')->row();
					$get_stock_detail = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'color_id')->row();
					$sales_qty_detail = 0;
					$stock_qty_detail = 0;
					if ($get_selling_order_details) {
						$sales_qty_detail = $get_selling_order_details->s_quantity;
					}
					if ($get_stock_detail) {
						$stock_qty_detail = $get_stock_detail->s_quantity;
					}

					$stock = ($value->s_quantity - $sales_qty_detail + ($stock_qty_detail));
					$harga = ($value->s_amount / $value->s_quantity);
					$total = $stock * $harga;
					$data[$k]['detail'][$key] = array(
						'no_det' => $no_det,
						'date'   => change_format_date($value->date, 'd/m/Y'),
						'group'  => $value->group_name,
						'type'   => $value->type_name,
						'color'  => $value->color_name,
						'stok'   => number_format($stock),
						'harga'  => number_format($harga),
						'total'  => number_format($total),
					);
					$no_det++;
				}
				unset($where['item_color_id']);
				$no++;
				$a = 0;
				$b = 0;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getSize($where)
	{
		$get_data = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'group_id')->result();

		$data = [];
		if ($get_data) {
			$no = 1;

			$a = 0;
			$b = 0;
			foreach ($get_data as $k => $get_row) {

				$where['item_group_id'] = $get_row->group_id;
				$get_sales_header = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'group_id')->row();
				$get_stock_header = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'group_id')->row();
				$sales_qty = 0;
				$stock_qty = 0;
				if ($get_sales_header) {
					$sales_qty = $get_sales_header->s_quantity;
				}
				if ($get_stock_header) {
					$stock_qty = $get_stock_header->s_quantity;
				}
				$stock = ($get_row->s_quantity - $sales_qty + ($stock_qty));
				$harga = ($get_row->s_amount / $get_row->s_quantity);
				$total = $stock * $harga;
				$data[] = array(
					'no'          => $no,
					'grand_stok'  => number_format($a += $stock),
					'grand_total' => number_format($b += $total),
				);

				$where['item_group_id'] = $get_row->group_id;
				$det = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'size_id')->result();

				$no_det = 1;
				foreach ($det as $key => $value) {

					$where['item_size_id'] = $value->size_id;
					$get_selling_order_details = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'size_id')->row();
					$get_stock_detail = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'size_id')->row();
					$sales_qty_detail = 0;
					$stock_qty_detail = 0;
					if ($get_selling_order_details) {
						$sales_qty_detail = $get_selling_order_details->s_quantity;
					}
					if ($get_stock_detail) {
						$stock_qty_detail = $get_stock_detail->s_quantity;
					}

					$stok = $value->s_quantity - $sales_qty_detail + ($stock_qty_detail);
					$harga = $value->s_amount / $value->s_quantity;
					$total = $stok * $harga;
					$data[$k]['detail'][$key] = array(
						'no_det' => $no_det,
						'date'   => change_format_date($value->date, 'd/m/Y'),
						'group'  => $value->group_name,
						'type'   => $value->type_name,
						'color'  => $value->color_name,
						'size'   => $value->size_name,
						'stok'   => number_format($stok),
						'beli'   => number_format($value->s_quantity),
						'jual'   => number_format($sales_qty_detail),
						'harga'  => number_format($harga),
						'total'  => number_format($total),
					);
					$no_det++;
				}
				unset($where['item_size_id']);
				$no++;
				$a = 0;
				$b = 0;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
		];

		output_json($response);
	}
	
	
	public function perItem($where,$date,$stock)
	{
		$get_data = $this->Report_stock_model->get_item($where)->result();

		$data = [];
		if ($get_data) {
			$no = 1;
				foreach ($get_data as $get_row) {
				    if(isset($date_1) && $date_1 != ''){
				       $where = array('a.stock_item_id' => $get_row->item_id,'date' => change_format_date($date));
				       $where2 = array('a.purchase_order_detail_item_id' => $get_row->item_id,'purchase_order_header_date' => change_format_date($date));
        		        $where_so = array('a.selling_order_detail_item_id' => $get_row->item_id,'b.selling_order_header_date' => change_format_date($date));
				    }else{
				        $where = array('a.stock_item_id' => $get_row->item_id);
				        $where2 = array('a.purchase_order_detail_item_id' => $get_row->item_id);
        		        $where_so = array('a.selling_order_detail_item_id' => $get_row->item_id);
				    }
					
                    $get_po = $this->Report_stock_model->get_purchase_detail($where2, '', 'a.purchase_order_detail_item_id')->row();
        			$get_so = $this->Report_stock_model->get_selling_order_details($where_so, '', 'a.selling_order_detail_item_id')->row();
        			$get_st = $this->Report_stock_model->get_stock_detail($where, '', 'a.stock_item_id')->row();
        
        			$stock_po = 0;
        			$stock_so = 0;
        			$stock_st = 0;
        
        			if ($get_po) {
        				$stock_po = $get_po->s_quantity;
        			}
        
        			if ($get_so) {
        				$stock_so = $get_so->s_quantity;
        			}
        
        			if ($get_st) {
        				$stock_st = $get_st->s_quantity;
        			}
        			
        			if($stock == 1){
        			    if($stock_po + $stock_st - $stock_so + $get_row->stok_awal > 0){
        			        $data[] = array(
                				'no'               => $no,
                				'id'               => $get_row->item_id,
                				'code'             => $get_row->item_code,
                				'name'             => $get_row->item_name,
                				// 'group_id'         => $get_row->group_id,
                				// 'group_name'       => $get_row->group_name,
                				// 'group_child_id'   => $get_row->group_child_id,
                				// 'group_child_name' => $get_row->group_child_name,
                				'lg_unit'          => $get_row->large_unit,
                				'stock'            => $stock_po + $stock_st - $stock_so + $get_row->stok_awal,
                				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
                				'lg_unit_prc'      => number_format($get_row->last_purchase_price_large_unit),
                				'lg_unit_slg'      => number_format($get_row->last_purchase_price_large_unit),
                				// 'md_unit'          => $get_row->medium_unit,
                				// 'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
                				// 'md_unit_prc'      => number_format($get_row->last_selling_price_medium_unit),
                				// 'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
                				// 'sm_unit'          => $get_row->small_unit,
                				// 'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
                				// 'sm_unit_prc'      => number_format($get_row->last_selling_price_small_unit),
                				// 'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
                				'total' => number_format(($stock_po + $stock_st - $stock_so) * $get_row->last_purchase_price_large_unit),
                				'btncolor'         => '',
                				'btnicon'          => '',
                			);
                			$no++;
        			    }
        			    
        			}else if($stock == 2){
        			    if($stock_po + $stock_st - $stock_so + $get_row->stok_awal <= 0){
        			        $data[] = array(
                				'no'               => $no,
                				'id'               => $get_row->item_id,
                				'code'             => $get_row->item_code,
                				'name'             => $get_row->item_name,
                				// 'group_id'         => $get_row->group_id,
                				// 'group_name'       => $get_row->group_name,
                				// 'group_child_id'   => $get_row->group_child_id,
                				// 'group_child_name' => $get_row->group_child_name,
                				'lg_unit'          => $get_row->large_unit,
                				'stock'            => $stock_po + $stock_st - $stock_so + $get_row->stok_awal,
                				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
                				'lg_unit_prc'      => number_format($get_row->last_purchase_price_large_unit),
                				'lg_unit_slg'      => number_format($get_row->last_purchase_price_large_unit),
                				// 'md_unit'          => $get_row->medium_unit,
                				// 'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
                				// 'md_unit_prc'      => number_format($get_row->last_selling_price_medium_unit),
                				// 'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
                				// 'sm_unit'          => $get_row->small_unit,
                				// 'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
                				// 'sm_unit_prc'      => number_format($get_row->last_selling_price_small_unit),
                				// 'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
                				'total' => number_format(($stock_po + $stock_st - $stock_so) * $get_row->last_purchase_price_large_unit),
                				'btncolor'         => '',
                				'btnicon'          => '',
                			);
                			$no++;
                        }
        			    
        			}else{
        			    $data[] = array(
            				'no'               => $no,
            				'id'               => $get_row->item_id,
            				'code'             => $get_row->item_code,
            				'name'             => $get_row->item_name,
            				// 'group_id'         => $get_row->group_id,
            				// 'group_name'       => $get_row->group_name,
            				// 'group_child_id'   => $get_row->group_child_id,
            				// 'group_child_name' => $get_row->group_child_name,
            				'lg_unit'          => $get_row->large_unit,
            				'stock'            => $stock_po + $stock_st - $stock_so + $get_row->stok_awal,
            				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
            				'lg_unit_prc'      => number_format($get_row->last_purchase_price_large_unit),
            				'lg_unit_slg'      => number_format($get_row->last_purchase_price_large_unit),
            				// 'md_unit'          => $get_row->medium_unit,
            				// 'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
            				// 'md_unit_prc'      => number_format($get_row->last_selling_price_medium_unit),
            				// 'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
            				// 'sm_unit'          => $get_row->small_unit,
            				// 'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
            				// 'sm_unit_prc'      => number_format($get_row->last_selling_price_small_unit),
            				// 'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
            				'total' => number_format(($stock_po + $stock_st - $stock_so) * $get_row->last_purchase_price_large_unit),
            				'btncolor'         => '',
            				'btnicon'          => '',
            			);
            			$no++;
        			}
        			
        			
				}
				
			}

		$response = [
			'data'         => $data,
			'totalBarang' => count($data)
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
		];

		output_json($response);
	}
	public function getGroup($where)
	{
		$get_data = $this->Report_stock_model->get_purchase_detail($where, 'group_name asc', 'group_id')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$where['item_group_id'] = $get_row->group_id;
				$get_sales_header = $this->Report_stock_model->get_selling_order_details($where, 'group_name asc', 'group_id')->row();
				$get_stock_header = $this->Report_stock_model->get_stock_detail($where, 'group_name asc', 'group_id')->row();
				$sales_qty = 0;
				$stock_qty = 0;
				if ($get_sales_header) {
					$sales_qty = $get_sales_header->s_quantity;
				}
				if ($get_stock_header) {
					$stock_qty = $get_stock_header->s_quantity;
				}
				$stock = ($get_row->s_quantity - $sales_qty + ($stock_qty));
				$harga = ($get_row->s_amount / $get_row->s_quantity);
				$total = $stock * $harga;
				$data[] = array(
					'no'    => $no,
					'date'  => change_format_date($get_row->date, 'd/m/Y'),
					'group' => $get_row->group_name,
					'stok'  => number_format($stock),
					'total' => number_format($total),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
		];

		output_json($response);
	}
	
	public function get_data_detail_card()
	{
		$item     = $this->input->post("item");
// 		$date_log = $this->input->post("date_log");
// 		$warehouse = $this->input->post("warehouse");

		$data  = [];
		$where_po = [];
		$where_so = [];
		$where_pr = [];
		$where_sr = [];
		$where_st = [];
		$order = ("b.timestamp ASC");

		if (isset($item) && $item != '' && $item != '(Semua)') {
			$where_po['a.purchase_order_detail_item_id'] = $item;
			$where_so['a.selling_order_detail_item_id'] = $item;
			$where_st['a.stock_item_id'] = $item;
		}
		
// 		if (isset($status) && $status != '' && $status != '(Semua)') {
// 			$where_po['b.ppn_status'] = $status;
// 		}
		// if (isset($date_log) && $date_log != '') {
		// 	$where['date(a.timestamp) <='] = change_format_date($date_log);
		// }
// 		if (isset($date_log) && $date_log != '') {
// 		    $where_po['b.timestamp <='] = change_format_date($date_log);
// 			$where_so['b.timestamp <='] = change_format_date($date_log);
// 			$where_pr['b.timestamp <='] = change_format_date($date_log);
// 			$where_sr['b.timestamp <='] = change_format_date($date_log);
// 			$where_st['b.timestamp <='] = change_format_date($date_log);
// // 			$where_po['date(a.printed_date) <='] = change_format_date($date_log);
// 		}

        $lg_stock = 0;
		$md_stock = 0;
		$sm_stock = 0;
		
// 		 $get_po = $this->Report_stock_model->get_purchase_detail($where, '', 'a.item_id')->row();
//         			$get_so = $this->Report_stock_model->get_selling_order_details($where_so, '', 'a.selling_order_detail_item_id')->row();
//         			$get_st = $this->Report_stock_model->get_stock_detail($where, '', 'a.item_id')->row();
		$buy = $this->Report_stock_model->get_purchase_detail2($where_po)->result_array();
        // $return_buy = $this->Purchase_returns_model->purchasereturn_detail_advance($where_pr)->result_array();
        $sell = $this->Report_stock_model->get_selling_order_details2($where_so,$order)->result_array();
        // $return_sell = $this->Sales_returns_model->salesreturn_detail_advance($where_sr)->result_array();
        $adjust = $this->Report_stock_model->get_stock_detail($where_st)->result_array();
        
        $mergedArray = array_merge($buy, $sell, $adjust);
        
        function sortByDatetime($a, $b) {
            $dateFields = array(
                'purchase_order_header_date',
                'selling_order_header_date',
                'date'
            );
        
            $earliestDateA = null;
            $earliestDateB = null;
        
            foreach ($dateFields as $dateField) {
                if (isset($a[$dateField]) && (!$earliestDateA || strtotime($a[$dateField]) < strtotime($earliestDateA))) {
                    $earliestDateA = $a[$dateField];
                }
        
                if (isset($b[$dateField]) && (!$earliestDateB || strtotime($b[$dateField]) < strtotime($earliestDateB))) {
                    $earliestDateB = $b[$dateField];
                }
            }
        
            return strtotime($earliestDateA) - strtotime($earliestDateB);
        }
        
        usort($mergedArray, 'sortByDatetime');
        $total_large = 0;
        $total_medium = 0;
        $no = 0;
        foreach($mergedArray as $get_row){
            $item_data2 = $this->Items_model->get_data(array('item_id' => $item))->row_array();
            $transaction_id = '';
            $transaction_status = '';
            $transaction_date	= '';
			$transaction_number	= '';
			$transaction_actor	= '';
			$in_large   = 0;
			$in_medium  = 0;
			$in_small   = 0;
			$out_large  =0;
			$out_medium = 0;
			$out_small  = 0;
			if (isset($get_row['purchase_order_detail_large_unit_quantity']) && $get_row['purchase_order_detail_large_unit_quantity'] != null) {
			    $transaction_id = $get_row['purchase_order_detail_id'];
				$transaction_status = 'Beli';
				$transaction_number = $get_row['purchase_order_header_number'];
				$transaction_date	= $get_row['purchase_order_header_date'];
				$transaction_actor  = $get_row['supplier_name'];
				$in_large  = $get_row['purchase_order_detail_large_unit_quantity'];
				// $in_medium  =  $get_row['purchase_order_detail_large_unit_quantity'];

			} else if (isset($get_row['selling_order_detail_large_unit_quantity']) && $get_row['selling_order_detail_large_unit_quantity'] != null) {
                $transaction_id = $get_row['selling_order_detail_id'];
				$transaction_status = 'Jual';
				$transaction_number = $get_row['selling_order_header_number'];
				$transaction_date	= $get_row['selling_order_header_date'];
				$transaction_actor  = "UMUM";
				$out_large  = $get_row['selling_order_detail_large_unit_quantity'];
				// $out_medium  =  $get_row['sales_order_detail_large_unit_quantity'];
			} else if (isset($get_row['quantity']) && $get_row['quantity'] != null) {
                $transaction_id = $get_row['id'];
				$transaction_status = 'Pengaturan Stok';
				$transaction_number = $get_row['number'];
				$transaction_date	=$get_row['date'];
				$transaction_actor  = '-';
				$in_large  = $get_row['quantity'];
				// $in_medium  =  $get_row['stok_detail_large_unit_quantity'];

			}
			
			$total_large +=  $in_large - $out_large ;
// 			$total_medium +=  $in_medium - $out_medium;
            if($total_large != 0){
                $data[] = array(
        			'no'                 => $no,
        			'log_id'             => $transaction_id,
        			// 'log_date'           => change_format_date($get_row->tms_log, 'd/m/Y'),
        			// 'log_date'           => $get_row->tms_log,
        			'log_date'           => change_format_date($transaction_date, 'd/m/Y'),
        			'transaction_status' => $transaction_status,
        			'transaction_number' => $transaction_number,
        			'transaction_actor'  => $transaction_actor,
        			'in_large'           => $in_large,
        			'in_medium'          => 0,
        			'in_small'           => 0,
        			'out_large'          => $out_large,
        			'out_medium'         => 0,
        			'out_small'          => 0,
        			'large_unit'         => $total_large + $item_data2['stok_awal'],
        			'medium_unit'        => 0,
        			'small_unit'         => 0,
        		);
        		$no++;
            }
            
    
    		$lg_stock = $total_large;
    		$md_stock = 0;
    		$sm_stock = 0;
        }
		
		
		
        // $therest_awal = 	$item_data['saldo_awal'];	
            
// 			$total_large_awal  = ($item_data['large_unit_contain'] == 0 ? '-' : floor($item_data['saldo_awal'] / $item_data['large_unit_contain']));
// 			$therest_awal      = ($item_data['large_unit_contain'] == 0 ? '-' : $therest_awal - ($total_large_awal * $item_data['large_unit_contain']));
// 			$total_medium_awal = ($item_data['medium_unit_contain'] == 0 ? '-' : floor($therest_awal /$item_data['medium_unit_contain']));
// 			$therest_awal      = ($item_data['medium_unit_contain'] == 0 ? '-' : $therest_awal - ($total_medium_awal * $item_data['medium_unit_contain']));
// 			$total_small_awal  = ($item_data['small_unit_contain'] == 0 ? '-' : floor($therest_awal / $item_data['small_unit_contain']));

		$this->session->set_userdata('item', $item);
        $item_data = $this->Items_model->get_data(array('item_id' => $item))->row_array();
// 		$this->session->set_userdata('date_log', $date_log);

		$response = [
			'data' => $data,
			'lg_stock' => $lg_stock + $item_data['stok_awal'],
			'md_stock' => $md_stock,
			'sm_stock' => $sm_stock,
			'lg_stock_awal' => $item_data['stok_awal'],
// 			'md_stock_awal' => $md_stock_awal,
// 			'sm_stock_awal' => $sm_stock_awal,
			'array'     => $mergedArray
		];
		output_json($response);
	}
}
