<?php

/**
 * Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
include APPPATH.'third_party/PHPExcel/PHPExcel.php';
include APPPATH.'third_party/PHPExcel/PHPExcel/IOFactory.php';
use libraries\BaseController;

class Selling_orders extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Selling_orders_model');
// 		$this->load->model('Configuration_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Jenis_bayar_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Report_stock_model');
		
// 		$this->load->model('Wholesale_prices_medium_model');
// 		$this->load->model('Wholesale_prices_small_model');
// 		$this->load->model('Special_prices_model');
// 		$this->load->model('Logs_model');
// 		$this->load->model('Ppn_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
		$this->load->model('Users_model');
// 		$this->load->model('Salesman_model');
// 		$this->load->model('Transfer_model');
// 		$this->load->model('Journals_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Penjualan';

		$this->twiggy_display('adm/selling_orders/index', $data);
	}
	public function kasir()
	{
		$data['content_title'] = 'Penjualan';

		$this->twiggy_display('adm/selling_orders/index_kasir', $data);
	}
	public function delayed()
	{
		$data['content_title'] = 'Penjualan';

		$this->twiggy_display('adm/selling_orders/delayed', $data);
	}

	public function get_data_header()
	{
		$data = [];
		$username = logged_user('fullname');
		// $order = "purchase_order_header_date DESC, purchase_order_header_number DESC";
		$order = "a.timestamp DESC";
	
		$get_data = $this->Selling_orders_model->purchaseorder_header('',$order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
			 //   $get_username = $this->Users_model->get_data_advance("",$get_row->username)->row();
				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->selling_order_header_id,
					'number' => $get_row->selling_order_header_number,
				 	'username' => $get_row->fullname,
				//  	'jenis_bayar' => $get_row->jenis,
					'date'   => indonesian_date($get_row->selling_order_header_date),
					'customer'    => $get_row->customer_name,
					'grand_total' => number_format($get_row->selling_order_header_grand_total),
					'description' => $get_row->selling_order_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	public function get_data_header_delayed()
	{
		$data = [];
		// $order = "purchase_order_header_date DESC, purchase_order_header_number DESC";
		$order = "a.timestamp DESC";
		$username = logged_user('fullname');
		$get_data = $this->Selling_orders_model->purchaseorder_header_delayed(['username' => $username], $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->selling_order_header_id,
					'number' => $get_row->selling_order_header_number,
					'username' => $get_row->username,
					'date'   => indonesian_date($get_row->selling_order_header_date),
					'customer'    => $get_row->customer_name,
					'grand_total' => number_format($get_row->selling_order_header_grand_total),
					'description' => $get_row->selling_order_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function changeStatus($id) {
		// post
	
		$action    = $this->input->post('action');

		$data_save = array(
			
			'is_hold'   => 0,
			
		);

		
		$save = $this->Selling_orders_model->update_header($id, $data_save);
		

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
			);
		}
        
		redirect('adm/selling_orders/delayed');
	}

	public function get_autonumber()
	{
		$datenow = date('ym');
		$number_generator = '';

		if ($customer_data) {
			$number_generator = $this->Selling_orders_model->purchaseorder_autonumber();
		}

		$prefix     = 'J';
		$autonumber = $prefix . $datenow . '-' . $number_generator;

		$response = [
			'autonumber'  => $autonumber,
			'address'  => $customer_data->customer_address,
			
		];

		echo json_encode($response);
	}
	
	public function get_jenis_harga()
	{
		$datenow = date('ym');
		$id = $this->input->post('id'); 
		$jenis_harga = $this->Customers_model->get_data(array('customer_id' => $id))->row();
// 		$number_generator = '';

// 		if ($customer_data) {
// 			$number_generator = $this->Selling_orders_model->purchaseorder_autonumber();
// 		}

// 		$prefix     = 'J';
// 		$autonumber = $prefix . $datenow . '-' . $number_generator;

		$response = [
			'jenis_harga'  =>   ($jenis_harga->group_customer_name != null ? $jenis_harga->group_customer_name : "UMUM"),
			'address'  => $jenis_harga->customer_address,
			'id' => $id
			
		];

		echo json_encode($response);
	}

	// public function get_customeraddress()
	// {
	// 	$id      = $this->input->post('id');
	// 	$where   = array('customer_id' => $id);
	// 	$customer_data  = $this->Customers_model->get_data($where)->row();


	// 	$response = [
	// 		'address'  => $customer_data->customer_address,
			
	// 	];

	// 	echo json_encode($response);
	// }


	public function edit($id = 'new')
	{
		$title       = "Tambah Penjualan";
		$header_data = array(null);
		$ppn_amount  = 0;
// 		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
// 		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		// $prefix  = "SO100";
		// $datenow = date('Ym');
		// $number_generator = $this->Selling_orders_model->purchaseorder_autonumber();
		// $autonumber = $prefix.$datenow.'-'.$number_generator;
		 $autonumber = '';
		$address = '';
		$date_text = date_now();
		$tmstamp   = date("H:i:s");
		$discount  = 0;
		$discount_price  = 0;
		$discount2  = 0;
		$discount_price2  = 0;
		$pembulatan2  = 0;
			$grand_total  = 0;

		if ($id != 'new') {
			$title       = "Edit Penjualan";
			$where       = array('selling_order_header_id' => $id);
			$header_data = $this->Selling_orders_model->purchaseorder_header($where)->row_array();
			$autonumber  = $header_data['selling_order_header_number'];
			$grand_total  = $header_data['selling_order_header_grand_total'];
			$discount  = $header_data['selling_order_header_discount_percent'];
			$discount_price  = $header_data['selling_order_header_discount'];
				$discount2  = $header_data['selling_order_header_discount_percent2'];
			$discount_price2  = $header_data['selling_order_header_discount2'];
			$date_text   = $header_data['selling_order_header_date'];
			$pembulatan2  = $header_data['selling_order_header_pembulatan'];
// 			$ppn_amount   = $header_data['selling_order_header_ppn_percentage'];
			$tmstamp     = time24($header_data['tmstamp_po']);
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['customer_data'] = $this->Customers_model->get_data()->result();
// 		$data['salesman_data'] = $this->Salesman_model->get_data()->result();
		$data['jenis_bayar'] = $this->Jenis_bayar_model->get_data()->result();
// 		$data['ppn_amount']    = $ppn_amount;
		$data['discount']    = $discount;
		
		$data['grand_total']    = $grand_total;
		$data['discount_price']    = $discount_price;
		$data['pembulatan2']    = $pembulatan2;
			$data['discount2']    = $discount2;
$data['discount_price2']    = $discount_price2;
 
		$data['address'] = $address;
		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/selling_orders/edit', $data);
	}

	public function get_data_ppn()
	{
		$id = $this->input->post("id");

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);

		if ($id != 'new') {
			$where       = array('selling_order_header_id' => $id);
			$header_data = $this->Selling_orders_model->purchaseorder_header($where)->row_array();
			$ppn_amount   = $header_data['selling_order_header_ppn_percentage'];
		}

		echo json_encode(to_decimal($ppn_amount));
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('selling_order_detail_header_id' => $id);
		$order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Selling_orders_model->purchaseorder_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->selling_order_detail_id,
					'detail_header_id' => $get_row->selling_order_detail_header_id,
					'id'               => $get_row->selling_order_detail_item_id,
					'name'             => $get_row->selling_order_detail_item_name,
					'lg_unit'          => $get_row->selling_order_detail_large_unit,
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'      => to_decimal($get_row->selling_order_detail_large_unit_quantity),
					'lg_unit_qty_old'      => to_decimal($get_row->selling_order_detail_large_unit_quantity),
					'lg_unit_prc'      => number_format($get_row->selling_order_detail_large_unit_price),
				// 	'lg_unit_prc_cash'      => number_format($get_row->selling_order_detail_large_unit_price),
				// 	'large_harga_eceran'      => number_format($get_row->large_harga_eceran),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				// 	'lg_unit_prc_kredit'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_kredit_large_unit) : 0),
				// 	'lg_unit_prc_spesial1'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_spesial3_large_unit) : 0),
				// 	'lg_unit_prc_spesial2'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_spesial4_large_unit) : 0),
				// 	'lg_unit_prc_spesial3'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_spesial5_large_unit) : 0),
				// 	'lg_unit_prc_spesial4'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_spesial6_large_unit) : 0),
				// 	'lg_unit_prc_spesial5'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_spesial7_large_unit) : 0),
					'lg_unit_prc_hpp'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_purchase_price_large_unit) : 0),
					'result_large'     => $get_row->selling_order_detail_result_large,
				// 	'md_unit'          => $get_row->selling_order_detail_medium_unit,
				// 	'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
				// 	'md_unit_qty'      => to_decimal($get_row->selling_order_detail_medium_unit_quantity),
				// 	'md_unit_qty_old'      => to_decimal($get_row->selling_order_detail_medium_unit_quantity),
				// 	'md_unit_prc'      => number_format($get_row->selling_order_detail_medium_unit_price),
				// 	'medium_harga_eceran'      => number_format($get_row->medium_harga_eceran),
				// 	'md_unit_prc_cash'      => number_format($get_row->selling_order_detail_medium_unit_price),
				// 	'md_unit_prc_kredit'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_kredit_medium_unit - $get_row->medium_unit_discount_kredit) : 0),
				// 'md_unit_prc_spesial1'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_spesial3_medium_unit) : 0),
				// 'md_unit_prc_spesial2'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_spesial4_medium_unit) : 0),
				// 'md_unit_prc_spesial3'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_spesial5_medium_unit) : 0),
				// 'md_unit_prc_spesial4'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_spesial6_medium_unit) : 0),
				// 'md_unit_prc_spesial5'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_spesial7_medium_unit) : 0),
				// 'md_unit_prc_hpp'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_hpp_medium_unit) : 0),
				// 	'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
				// 	'result_medium'    => $get_row->selling_order_detail_result_medium,
				// 	'sm_unit'          => $get_row->selling_order_detail_small_unit,
				// 	'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
				// 	'sm_unit_qty'      => to_decimal($get_row->selling_order_detail_small_unit_quantity),
				// 	'sm_unit_qty_old'      => to_decimal($get_row->selling_order_detail_small_unit_quantity),
				// 	'sm_unit_prc'      => number_format($get_row->selling_order_detail_small_unit_price),
				// 	'small_harga_eceran'      => number_format($get_row->small_harga_eceran),
				// 	'sm_unit_prc_cash'      => number_format($get_row->selling_order_detail_small_unit_price),
				// 	'sm_unit_prc_kredit'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_kredit_small_unit - $get_row->small_unit_discount_kredit) : 0),
				// 'sm_unit_prc_spesial1'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_spesial3_small_unit) : 0),
				// 'sm_unit_prc_spesial2'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_spesial4_small_unit) : 0),
				// 'sm_unit_prc_spesial3'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_spesial5_small_unit) : 0),
				// 'sm_unit_prc_spesial4'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_spesial6_small_unit) : 0),
				// 'sm_unit_prc_spesial5'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_spesial7_small_unit) : 0),
				// 'sm_unit_prc_hpp'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_hpp_small_unit) : 0),
				// 	'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
					'result_small'     => $get_row->selling_order_detail_result_small,
					'discount'         => to_decimal($get_row->selling_order_detail_discount_percentage),
					'discount_total'   => number_format($get_row->selling_order_detail_discount_total),
					'total'            => number_format($get_row->selling_order_detail_total),
					'disc1' => $get_row->selling_order_detail_disc1,
					'disc2' => $get_row->selling_order_detail_disc2,
					'disc3' => $get_row->selling_order_detail_disc3,

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		
		$this->twiggy_display('adm/selling_orders/embed', $data);
	}

	public function get_embed_sell()
	{
		$grand_total = $this->input->post('grand_total');
		$data = [];
		$data['content_title'] = 'Jual Barang';
		$data['grand_total'] = $grand_total;
		$this->twiggy_display('adm/selling_orders/sell_embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
		    $where = array('a.stock_item_id' => $get_row->item_id);
		        $where2 = array('a.purchase_order_detail_item_id' => $get_row->item_id);
		        $where_so = array('a.selling_order_detail_item_id' => $get_row->item_id);
				$get_po = $this->Report_stock_model->get_purchase_detail($where2, '', 'a.purchase_order_detail_item_id')->row();
    			$get_so = $this->Report_stock_model->get_selling_order_details($where_so, '', 'a.selling_order_detail_item_id')->row();
    			$get_st = $this->Report_stock_model->get_stock_detail($where, '', 'a.stock_item_id')->row();
    
    			$stock_po = 0;
    			$stock_so = 0;
    			$stock_st = 0;
    
    			if ($get_po) {
    				$stock_po = $get_po->s_quantity;
    			}
    
    			if ($get_so) {
    				$stock_so = $get_so->s_quantity;
    			}
    
    			if ($get_st) {
    				$stock_st = $get_st->s_quantity;
    			}

// 			if ($get_po) {
// 				$stock_po = $get_po->s_quantity;
// 			}

// 			if ($get_so) {
// 				$stock_so = $get_so->s_quantity;
// 			}

// 			if ($get_st) {
// 				$stock_st = $get_st->s_quantity;
// 			}
			
			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'code'             => $get_row->item_code,
				'name'             => $get_row->item_name,
				// 'group_id'         => $get_row->group_id,
				// 'group_name'       => $get_row->group_name,
				// 'group_child_id'   => $get_row->group_child_id,
				// 'group_child_name' => $get_row->group_child_name,
				'lg_unit'          => $get_row->large_unit,
				'stock'            => $stock_po + $stock_st - $stock_so + $get_row->stok_awal,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_prc'      => number_format($get_row->last_selling_price_large_unit),
				'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				'lg_unit_slg2'      => number_format($get_row->last_selling_price_large_unit2),
				'lg_unit_slg3'      => number_format($get_row->last_selling_price_large_unit3),
				'md_unit'          => "",
				'md_unit_cnt'      => to_decimal(0),
				'md_unit_prc'      => number_format(0),
				'md_unit_slg'      => number_format(0),
				'sm_unit'          => "",
				'sm_unit_cnt'      => to_decimal(0),
				'sm_unit_prc'      => number_format(0),
				'sm_unit_slg'      => number_format(0),
				'changeHarga'      => "Resep",
				'btncolor'         => '',
				'btnicon'          => '',
				'btncolor2'         => '',
				'btnicon2'          => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	public function get_data_barcode()
	{
		$data = [];
		$response = [];
		$barcode   = $this->input->post('barcode');

		$get_data  = $this->Items_model->get_data_search($barcode)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			
			
			$where = array('item_id' => $get_row->item_id);
		    $where_so = array('selling_order_detail_item_id' => $get_row->item_id);
            $get_po = $this->Report_stock_model->get_purchase_detail_lite($where, '', 'item_id')->row();
			$get_so = $this->Report_stock_model->get_sales_detail_lite($where_so, '', 'selling_order_detail_item_id')->row();
			$get_st = $this->Report_stock_model->get_stock_detail_lite($where, '', 'item_id')->row();

			$stock_po = 0;
			$stock_so = 0;
			$stock_st = 0;

			if ($get_po) {
				$stock_po = $get_po->s_quantity;
			}

			if ($get_so) {
				$stock_so = $get_so->s_quantity;
			}

			if ($get_st) {
				$stock_st = $get_st->s_quantity;
			}

			if($get_row->item_code == $barcode){
				$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'name'             => $get_row->item_name,
				
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_qty_old'=> 0,
				'lg_unit_qty'=> 1,
				'lg_unit_prc'      => number_format($get_row->last_selling_price_large_unit),
				'stock'            => $stock_po + $stock_st - $stock_so,
				'tipe_barcode' => 'besar',
				'total_small' => 0,
				'total_medium' => 0,
				'total_large' => 0,
				'btncolor'         => '',
				'btnicon'          => '',
				);
			}

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$autonumber         = $this->input->post("autonumber");
		$date           = $this->input->post("date");
		$username       = $this->input->post("username");
		$role       = $this->input->post("role");
		$customer       = $this->input->post("customer");
		$sub_total      = $this->input->post("sub_total");
		$bayar = $this->input->post("bayar");
		$ppn_id         = $this->input->post("ppn_id");
		$ppn_percentage = $this->input->post("ppn_percentage");
		$ppn_total      = $this->input->post("ppn_total");
		$discount    = $this->input->post("discount_price");
		$discount_percentage    = $this->input->post("discount");
// 		$discount2    = $this->input->post("discount_price2");
// 		$discount_percentage2    = $this->input->post("discount2");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");
		$syarat_bayar    = $this->input->post("syarat_bayar");
		$jenis_bayar    = $this->input->post("jenis_bayar");
		$is_hold    = $this->input->post("status");
		$customer_address       = $this->input->post("customer_address");
        $pembulatan      = $this->input->post("pembulatan");
		$tmstamp         = $this->input->post("tmstamp");

		$vuedata = json_decode($this->input->post('vuedata'),true);
		$ppn_type = ($ppn_id == NULL ? 0 : 1);

		$payment_due   = $this->input->post("payment_due");
		// $where         = array('supplier_id' => $supplier);
		// $supplier_data = $this->Suppliers_model->get_data($where)->row();
		// if($supplier_data){
		// 	$payment_due = date('Y-m-d', strtotime($date. ' + '. $supplier_data->supplier_payment_term .' days'));
		// }

		$header_id         = $id;
		$trheader_id       = 0;
		// $default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row_array();

// 		$prefix            = 'TF';
// 		$datenow           = date('ym');
// 		$transfer_number   = $this->Transfer_model->transfer_autonumber();
// 		$autonumber        = $prefix . $datenow . '-' . $transfer_number;
		
		

// 		$trheader_data = [
// 			'header_number' => $autonumber,
// 			'header_date'   => change_format_date($date),
// 			'header_from'   => 0,
// 			'header_to'     => $customer
// 		];

		$detail_data = [];
		$log_data = [];
		$newprice_data = [];

		// if save $id = new else update data
		if ($vuedata) {
			if ($id == "new") {
				$datenow = date('ym');
				$number_generator = '';

			
					$number_generator = $this->Selling_orders_model->purchaseorder_autonumber();


				$prefix     = '';
				$number = $prefix . $datenow . $number_generator;

				$header_data = [
					'selling_order_header_number'         => $number,
					'selling_order_header_date'           => change_format_date($date),
					'selling_order_header_customer_id'    => $customer,
					'selling_order_header_jenis_bayar_id'    => $jenis_bayar,
				// 	'selling_order_header_syarat_bayar'    => $syarat_bayar,
					'selling_order_header_sub_total'      => trims($sub_total),
				// 	'selling_order_header_ppn_id'         => $ppn_type,
				// 	'selling_order_header_ppn_percentage' => $ppn_percentage,
				// 	'selling_order_header_ppn_total'      => trims($ppn_total),
					'selling_order_header_grand_total'    => trims($grand_total),
					'selling_order_header_paid_total'    => trims($bayar),
					'selling_order_header_description'    => $description,
				// 	'selling_order_header_customer_address'   => $customer_address,
					'selling_order_header_discount'   => trims($discount),
					'selling_order_header_discount_percent'   => $discount_percentage,
				// 		'selling_order_header_discount2'   => trims($discount2),
				// 	'selling_order_header_discount_percent2'   => $discount_percentage2,
					'selling_order_header_pembulatan'   => trims($pembulatan),
					'username' => $username,
					'role' => $role,
					'is_hold' => $is_hold
				];
				// save header
				$save_header  = $this->Selling_orders_model->save_header($header_data);

				if ($save_header) {
					$header_id = $this->db->insert_id();
				// 	$save_trheader = $this->Transfer_model->save_header($trheader_data);
				// 	$trheader_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
					    $where_purchase_price               = array('item_id' => $row['id']);
						$item_purchase_price             = $this->Items_model->get_data($where_purchase_price)->row();
						$detail_data[] = [
							'selling_order_detail_header_id'            => $header_id,
							'selling_order_detail_item_id'              => $row['id'],
							'selling_order_detail_item_name'            => $row['name'],
							'selling_order_detail_large_unit'           => $row['lg_unit'],
							'selling_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
							'selling_order_detail_large_unit_price'     => trims($row['lg_unit_prc']),
							'selling_order_detail_large_unit_purchase_price'     => trims($item_purchase_price->last_purchase_price_large_unit),
// 	$item_purchase_price['dsadas']
							'selling_order_detail_result_large'         => trims($row['result_large']),
							'selling_order_detail_medium_unit'          => $row['md_unit'],
							'selling_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
							'selling_order_detail_medium_unit_price'    => trims($row['md_unit_prc']),
					
							'selling_order_detail_result_medium'        => trims($row['result_medium']),
							'selling_order_detail_small_unit'           => $row['sm_unit'],
							'selling_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
							'selling_order_detail_small_unit_price'     => trims($row['sm_unit_prc']),
							
							'selling_order_detail_result_small'         => trims($row['result_small']),
							'selling_order_detail_discount_percentage'  => trims($row['discount']),
							'selling_order_detail_discount_total'       => trims($row['discount_total']),
        				    // 'selling_order_detail_disc1' => trims($row['disc1']),
        				// 	'selling_order_detail_disc2' => trims($row['disc2']),
        				// 	'selling_order_detail_disc3' => trims($row['disc3']),
							'selling_order_detail_total'                => trims($row['total'])
						];

	
						$whereI               = array('item_id' => $row['id']);
						$item_data_check             = $this->Items_model->get_data($whereI)->row_array();
						$where_item = $row['id'];
						
						$data_item = array(
							'item_sell'  =>  $item_data_check['item_sell'] + ((int)trims($row['lg_unit_qty'] *  1)),		
							// 'stock_total' => $item_data_check['item_in_total'] - $item_data_check['item_out_total'],
							// 'stock_besar' => $item_data_check['stock_total'] / $item_data_check['large_unit_contain'],
							//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
							//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
						);


						$update_item =  $this->Items_model->update($where_item, $data_item);
						if($update_item){
							$whereI2               = array('item_id' => $row['id']);
							$item_data_check2             = $this->Items_model->get_data($whereI2)->row_array();
							$where_item = $row['id'];
							
							$data_item2 = array(
								'item_stock' =>  $item_data_check2['item_buy'] - $item_data_check2['item_sell'],
								//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
								//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
							);
							$this->Items_model->update($where_item, $data_item2);
						}
					
					}

					$save_detail = $this->Selling_orders_model->save_detail($detail_data, true);
				// 	$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);



					if ($save_detail) {
						$save_log = true;

						if ($save_log) {
							$update_log = true;
							// $update_log = true;
							if ($update_log) {
								// $s_trx = 'update';
								// $update_master_item = $this->Selling_orders_model->update_master_item_batch($newprice_data);
								// // if($update_master_item)
								// // {
								// $prefix_jr           = "JR";
								// $datenow_jr          = date('Ym');
								// $number_generator_jr = $this->Journals_model->journal_autonumber();
								// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

								// $header_data_jr = [
								// 	'journal_header_number'       => $autonumber_jr,
								// 	'journal_header_trx_id'       => $header_id,
								// 	'journal_header_trx_type'     => "BUY",
								// 	'journal_header_date'         => change_format_date($date),
								// 	'journal_header_total_debit'  => trims($grand_total),
								// 	'journal_header_total_credit' => trims($grand_total),
								// 	'journal_header_description'  => $number,
								// ];

								// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
								// $header_id_jr = $this->db->insert_id();

								// $detail_data_jr = [
								// 	[
								// 		'journal_detail_header_id'      => $header_id_jr,
								// 		'journal_detail_account_id'     => '20',
								// 		'journal_detail_account_number' => '11000035',
								// 		'journal_detail_account_name'   => 'Persediaan Material',
								// 		'journal_detail_debit'          => trims($grand_total),
								// 		'journal_detail_credit'         => 0,
								// 		'journal_detail_description'    => ''
								// 	],
								// 	[
								// 		'journal_detail_header_id'      => $header_id_jr,
								// 		'journal_detail_account_id'     => '24',
								// 		'journal_detail_account_number' => '210000019',
								// 		'journal_detail_account_name'   => 'Utang Usaha',
								// 		'journal_detail_debit'          => 0,
								// 		'journal_detail_credit'         => trims($grand_total),
								// 		'journal_detail_description'    => ''
								// 	]
								// ];

								// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

								$msg    = "Berhasil menyimpan data";
								$status = "success";
								// }else{
								// 	$msg    = "Gagal menyimpan data #CKP-U01";
								// 	$status = "error";	
								// }
							} else {
								$msg    = "Gagal menyimpan data #CKP-U01";
								$status = "error";
							}
						} else {
							$msg    = "Gagal menyimpan data";
							$status = "error";
						}
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$header_data = [
						'selling_order_header_number'         => $autonumber,
					'selling_order_header_date'           => change_format_date($date),
					'selling_order_header_customer_id'    => $customer,
					'selling_order_header_jenis_bayar_id'    => $jenis_bayar,
				// 	'selling_order_header_syarat_bayar'    => $syarat_bayar,
					'selling_order_header_sub_total'      => trims($sub_total),
				// 	'selling_order_header_ppn_id'         => $ppn_type,
				// 	'selling_order_header_ppn_percentage' => $ppn_percentage,
				// 	'selling_order_header_ppn_total'      => trims($ppn_total),
					'selling_order_header_grand_total'    => trims($grand_total),
					'selling_order_header_paid_total'    => trims($bayar),
					'selling_order_header_description'    => $description,
				// 	'selling_order_header_customer_address'   => $customer_address,
					'selling_order_header_discount'   => trims($discount),
					'selling_order_header_discount_percent'   => $discount_percentage,
				// 	'selling_order_header_discount2'   => trims($discount2),
				// 	'selling_order_header_discount_percent2'   => $discount_percentage2,
				// 	'selling_order_header_pembulatan'   => trims($pembulatan),
					'username' => $username,
					'role' => $role,
					'is_hold' => $is_hold
				];
				// $id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $id, 'status' => 'SELL'))->row()->header_id;

				$delete_detail = $this->Selling_orders_model->delete_detail($id);

				// $tf_delheader = $this->Transfer_model->delete_header($id_transfer);
				// $tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

				// $jr_delheader = $this->Journals_model->delete_headerbytrxid($header_id, "SELL");
				// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($header_id, "SELL");

				if ($delete_detail) {

					$delete_log = true;
					if ($delete_log) {

						$save_header  = $this->Selling_orders_model->update_header($id, $header_data);

						if ($save_header) {
				// 			$save_trheader = $this->Transfer_model->save_header($trheader_data);
				// 			$trheader_id = $this->db->insert_id();

							foreach ($vuedata as $row) {
							    $where_purchase_price               = array('item_id' => $row['id']);
						$item_purchase_price             = $this->Items_model->get_data($where_purchase_price)->row();
								$detail_data[] = [
									'selling_order_detail_header_id'            => $header_id,
									'selling_order_detail_item_id'              => $row['id'],
									'selling_order_detail_item_name'            => $row['name'],
									'selling_order_detail_large_unit'           => $row['lg_unit'],
									'selling_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
									'selling_order_detail_large_unit_price'     => trims($row['lg_unit_prc']),
									'selling_order_detail_large_unit_purchase_price'     => trims($item_purchase_price->last_purchase_price_large_unit),
									'selling_order_detail_result_large'         => trims($row['result_large']),
								// 	'selling_order_detail_medium_unit'          => $row['md_unit'],
								// 	'selling_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
								// 	'selling_order_detail_medium_unit_price'    => trims($row['md_unit_prc']),
								// 	'selling_order_detail_result_medium'        => trims($row['result_medium']),
								// 	'selling_order_detail_small_unit'           => $row['sm_unit'],
								// 	'selling_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
								// 	'selling_order_detail_small_unit_price'     => trims($row['sm_unit_prc']),
								// 	'selling_order_detail_result_small'         => trims($row['result_small']),
									'selling_order_detail_discount_percentage'  => trims($row['discount']),
									'selling_order_detail_discount_total'       => trims($row['discount_total']),
								// 	'selling_order_detail_disc1' => trims($row['disc1']),
        				// 	'selling_order_detail_disc2' => trims($row['disc2']),
        				// 	'selling_order_detail_disc3' => trims($row['disc3']),
									'selling_order_detail_total'                => trims($row['total']),
								];

								// $dtstamp                    = change_format_date($date) . " " . $tmstamp;
								// $where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
								// $log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
								// $last_total_stock           = 0;
								// $last_log_total_stock_value = 0;
								// $last_log_avg_large         = 0;
								// $last_log_avg_medium        = 0;
								// $last_log_avg_small         = 0;

								// if (!empty($log_data_check)) {
								// 	$last_total_stock           = $log_data_check['log_total_stock'];
								// 	$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
								// 	$last_log_avg_large         = $log_data_check['log_average_large_unit'];
								// 	$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
								// 	$last_log_avg_small         = $log_data_check['log_average_small_unit'];
								// }

								// $log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (int)trims($row['lg_unit_qty'])) + ($row['md_unit_cnt'] * (int)trims($row['md_unit_qty'])) + ($row['sm_unit_cnt'] * (int)trims($row['sm_unit_qty']));
								// $log_total_transaction_value = ((int)(int)trims($row['lg_unit_qty']) * trims($row['lg_unit_prc'])) + ((int)trims($row['md_unit_qty']) * trims($row['md_unit_prc'])) + ((int)trims($row['sm_unit_qty']) * trims($row['sm_unit_prc']));
								// $log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
								// $log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
								// if(trims($row['sm_unit_qty']) != 0 || trims($row['md_unit_qty']) != 0 || trims($row['lg_unit_qty'] != 0)){
								// 	$log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
								// 	$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
								// 	$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
									
								// 	$log_data[] = [
								// 		'log_type'                            => 'SELL',
								// 		'log_transaction_id'                  => $header_id,
								// 		'log_item_id'                         => $row['id'],
								// 		'log_large_unit'                      => $row['lg_unit'],
								// 		'log_large_unit_contain'              => $row['lg_unit_cnt'],
								// 		'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
								// 		'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
								// 		'log_medium_unit'                     => $row['md_unit'],
								// 		'log_medium_unit_contain'             => $row['md_unit_cnt'],
								// 		'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
								// 		'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
								// 		'log_small_unit'                      => $row['sm_unit'],
								// 		'log_small_unit_contain'              => $row['sm_unit_cnt'],
								// 		'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
								// 		'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
								// 		'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
								// 		'log_total_transaction_value'         => $log_total_transaction_value,
								// 		'log_total_stock'                     => $log_total_stock,
								// 		'log_total_stock_value'               => $log_total_stock_value,
								// 		'log_average_large_unit'              => $log_average_large_unit,
								// 		'log_average_medium_unit'             => $log_average_medium_unit,
								// 		'log_average_small_unit'              => $log_average_small_unit,
								// 		'timestamp'                           => $dtstamp
								// 	];
								// }
								
								
							

								// $newprice_data[] = [
								// 	'item_id'                         => $row['id'],
								// 	'last_purchase_price_large_unit'  => trims($row['lg_unit_prc']),
								// 	'last_purchase_price_medium_unit' => trims($row['md_unit_prc']),
								// 	'last_purchase_price_small_unit'  => trims($row['sm_unit_prc'])
								// ];

								// $trdetail_data[] = [
								// 	'header_id'      => $trheader_id,
								// 	'transaction_id' => $header_id,
								// 	'item_id'        => $row['id'],
								// 	'lg_qty'         => trims($row['lg_unit_qty']),
								// 	'md_qty'         => trims($row['md_unit_qty']),
								// 	'sm_qty'         => trims($row['sm_unit_qty']),
								// 	'status'         => "SELL",
								// ];
								$whereI               = array('item_id' => $row['id']);
								$item_data_check             = $this->Items_model->get_data($whereI)->row_array();
								$where_item = $row['id'];
								if($row['lg_unit_qty_old'] != null){
								    $data_item = array(
									'item_sell'  =>  ($item_data_check['item_sell'] - ( (trims($row['lg_unit_qty_old'] *  1)))),		
									// 'stock_total' => $item_data_check['item_in_total'] - $item_data_check['item_out_total'],
									// 'stock_besar' => $item_data_check['stock_total'] / $item_data_check['large_unit_contain'],
									//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
									//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
    								);
    
    
    								$update_item =  $this->Items_model->update($where_item, $data_item);
								}else{
								    $update_item = true;
								}
								
								if($update_item){
									$whereI2               = array('item_id' => $row['id']);
									$item_data_check2             = $this->Items_model->get_data($whereI2)->row_array();
									$where_item = $row['id'];
									
									
									$data_item2 = array(
										'item_sell'  =>  ($item_data_check2['item_sell'] + ((int)trims($row['lg_unit_qty']) *  1)),		
										//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
										//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
									);

									$update_item2 = $this->Items_model->update($where_item, $data_item2);

									if($update_item2){
										$whereI3               = array('item_id' => $row['id']);
										$item_data_check3             = $this->Items_model->get_data($whereI3)->row_array();
										$where_item = $row['id'];
										
										$data_item3 = array(
											
											'item_stock' => $item_data_check3['item_buy'] - $item_data_check3['item_sell'],
											//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
											//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
										);
										$this->Items_model->update($where_item, $data_item3);
									}
									
								
									
								}
							}

							$save_detail = $this->Selling_orders_model->save_detail($detail_data, true);
				// 			$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

							if( trims($row['lg_unit_qty'] != 0)){
								if ($save_detail) {
				
									$save_log = true;
	
									if ($save_log) {
										$update_log = true;
										// $update_log = true;
										if ($update_log) {
											// $s_trx = 'update';
								// 			$update_master_item = $this->Selling_orders_model->update_master_item_batch($newprice_data);
	
								// 			$prefix_jr           = "JR";
								// 			$datenow_jr          = date('Ym');
								// 			$number_generator_jr = $this->Journals_model->journal_autonumber();
								// 			$autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;
	
								// 			$header_data_jr = [
								// 				'journal_header_number'       => $autonumber_jr,
								// 				'journal_header_trx_id'       => $header_id,
								// 				'journal_header_trx_type'     => "BUY",
								// 				'journal_header_date'         => change_format_date($date),
								// 				'journal_header_total_debit'  => trims($grand_total),
								// 				'journal_header_total_credit' => trims($grand_total),
								// 				'journal_header_description'  => "Deskripsi",
								// 			];
	
								// 			$save_header_jr = $this->Journals_model->save_header($header_data_jr);
								// 			$header_id_jr = $this->db->insert_id();
	
								// 			$detail_data_jr = [
								// 				[
								// 					'journal_detail_header_id'      => $header_id_jr,
								// 					'journal_detail_account_id'     => '20',
								// 					'journal_detail_trx_id'         => $header_id,
								// 					'journal_detail_trx_type'       => "BUY",
								// 					'journal_detail_account_number' => '11000035',
								// 					'journal_detail_account_name'   => 'Persediaan Material',
								// 					'journal_detail_debit'          => trims($grand_total),
								// 					'journal_detail_credit'         => 0,
								// 					'journal_detail_description'    => ''
								// 				],
								// 				[
								// 					'journal_detail_header_id'      => $header_id_jr,
								// 					'journal_detail_account_id'     => '24',
								// 					'journal_detail_trx_id'         => $header_id,
								// 					'journal_detail_trx_type'       => "BUY",
								// 					'journal_detail_account_number' => '210000019',
								// 					'journal_detail_account_name'   => 'Utang Usaha',
								// 					'journal_detail_debit'          => 0,
								// 					'journal_detail_credit'         => trims($grand_total),
								// 					'journal_detail_description'    => ''
								// 				]
								// 			];
	
								// 			$save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);
											// if($update_master_item)
											// {
											$msg    = "Berhasil menyimpan data";
											$status = "success";
											// }else{
											// 	$msg    = "Gagal menyimpan data #CKP-U01";
											// 	$status = "error";	
											// }
										} else {
											$msg    = "Gagal menyimpan data #CKP-U01";
											$status = "error";
										}
									} else {
										$msg    = "Gagal menyimpan data #LOG-S01";
										$status = "error";
									}
								} else {
									$msg    = "Gagal menyimpan data #LOG-U01";
									$status = "error";
								}
							}else {
								$msg    = "ERROR: MASUKAN QTY!!!";
								$status = "error";
							}
							
						}
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
		
	}

	public function get_wholesale_price()
	{
		$customer       = $this->input->post('customer');
		$item           = $this->input->post('item');
		$syarat_bayar   = $this->input->post('syarat_bayar');
		$quantity_large = $this->input->post('quantity_large');

		$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $item);
		$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->result();


		// echo json_encode($get_data_group_price);
		// die();
		$price = 0;
	
			$get_wholesale_price = $this->Wholesale_prices_model->get_data_range($item, $quantity_large)->row_array();
			if (!empty($get_wholesale_price)) {
				$price = $get_wholesale_price['price'];
				
			} else {
				$where_last_price    = array('item_id' => $item);
				$get_data_last_price = $this->Items_model->get_data($where_last_price)->row_array();
				$price               = $get_data_last_price['last_selling_price_large_unit'];
			
				
					
			}
			echo json_encode(number_format($price));
		
		
	}

// 	public function get_wholesale_price_medium()
// 	{
// 		$customer       = $this->input->post('customer');
// 		$item           = $this->input->post('item');
// 		$syarat_bayar   = $this->input->post('syarat_bayar');
// 		$quantity_medium = $this->input->post('quantity_medium');

// 		$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $item);
// 		$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->result();


// 		// echo json_encode($get_data_group_price);
// 		// die();
// 		$price = 0;
	
// 			$get_wholesale_price = $this->Wholesale_prices_medium_model->get_data_range($item, $quantity_medium)->row_array();
// 			if (!empty($get_wholesale_price)) {
// 				$price = $get_wholesale_price['price'];
// 			} else {
// 				$where_last_price    = array('item_id' => $item);
// 				$get_data_last_price = $this->Items_model->get_data($where_last_price)->row_array();
// 					if($syarat_bayar == "SPESIAL"){
// 				     $price               = $get_data_last_price['last_selling_spesial3_medium_unit'];
// 				}else if($syarat_bayar == "KREDIT"){
// 				    $price               = $get_data_last_price['last_selling_kredit_medium_unit'];
// 				}else if($syarat_bayar == "UMUM"){
// 				    $price               = $get_data_last_price['medium_harga_eceran'];
// 				}
// 			}
// 			echo json_encode(number_format($price));
		
// 	}
// 	public function get_wholesale_price_small()
// 	{
// 		$customer       = $this->input->post('customer');
// 		$item           = $this->input->post('item');
// 		$syarat_bayar   = $this->input->post('syarat_bayar');
// 		$quantity_small = $this->input->post('quantity_small');

// 		$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $item);
// 		$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->result();


// 		// echo json_encode($get_data_group_price);
// 		// die();
// 		$price = 0;
	
// 			$get_wholesale_price = $this->Wholesale_prices_small_model->get_data_range($item, $quantity_small)->row_array();
// 			if (!empty($get_wholesale_price)) {
// 				$price = $get_wholesale_price['price'];
// 			} else {
// 				$where_last_price    = array('item_id' => $item);
// 				$get_data_last_price = $this->Items_model->get_data($where_last_price)->row_array();
// 				if($syarat_bayar == "SPESIAL"){
// 				     $price               = $get_data_last_price['last_selling_spesial3_small_unit'];
// 				}else if($syarat_bayar == "KREDIT"){
// 				    $price               = $get_data_last_price['last_selling_kredit_small_unit'];
// 				}else if($syarat_bayar == "UMUM"){
// 				    $price               = $get_data_last_price['small_harga_eceran'];
// 				}
// 			}
// 			echo json_encode(number_format($price));
		
// 	}

// 	public function update_log($vuedata, $header_id = '', $date = '')
// 	{
// 		$data_log = [];
// 		$data_where = [];

// 		$updateData = array();

// 		$total_stok = 0;
// 		$total_stok_rupiah = 0;
// 		$avg_lg = 0;
// 		$avg_md = 0;
// 		$avg_sm = 0;

// 		foreach ($vuedata as $rowes) {

// 			$where_1         = array('log_item_id' => $rowes['id']);
// 			$get_first       = $this->Logs_model->cek_data($where_1)->result();

// 			if (count($get_first) > 1) {
// 				$get_first       = $this->Logs_model->get_data_first($where_1)->row();

// 				$logs_id         = $get_first->tmslog;

// 				$total_stok      = $get_first->log_total_stock;
// 				$total_stok_rupiah = $get_first->log_total_stock_value;

// 				$avg_lg  = ($get_first->log_average_large_unit);
// 				$avg_md  = ($get_first->log_average_medium_unit);
// 				$avg_sm  = ($get_first->log_average_small_unit);

// 				$log_total_transaction_value = 0;

// 				$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
// 				$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2)->result();

// 				foreach ($get_data_all_logs_by_item as $row) {


// 					$total_stok      += $row->log_total_transaction_in_small_unit;

// 					if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
// 						$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
// 					} else {
// 						$log_total_transaction_value = (((int)$row->log_large_unit_quantity * ($avg_lg)) + ((int)$row->log_medium_unit_quantity * ($avg_md)) + ((int)$row->log_small_unit_quantity * ($avg_sm)));
// 					}
// 					$total_stok_rupiah += $log_total_transaction_value;


// 					$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
// 					$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
// 					$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

// 					// $log_total_transaction_value = a;

// 					if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
// 						$avg_lg  = ($log_average_large_unit);
// 						$avg_md  = ($log_average_medium_unit);
// 						$avg_sm  = ($log_average_small_unit);
// 						$data_log[] = array(
// 							'log_id'                        => $row->log_id,
// 							// 'log_medium_unit_purchase_price' => $medium_purchase_price,
// 							// 'log_small_unit_purchase_price'  => $small_purchase_price,
// 							// 'log_total_transaction_value' => $log_total_transaction_value,
// 							'log_total_stock'             => $total_stok,
// 							'log_total_stock_value'       => $total_stok_rupiah,
// 							'log_average_large_unit'      => $log_average_large_unit,
// 							'log_average_medium_unit'     => $log_average_medium_unit,
// 							'log_average_small_unit'      => $log_average_small_unit,
// 							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
// 						);
// 					} else {

// 						$data_log[] = array(
// 							'log_id'                         => $row->log_id,
// 							'log_large_unit_purchase_price'  => $avg_lg,
// 							'log_medium_unit_purchase_price' => $avg_md,
// 							'log_small_unit_purchase_price'  => $avg_sm,
// 							'log_total_transaction_value'    => $log_total_transaction_value,
// 							'log_total_stock'                => $total_stok,
// 							'log_total_stock_value'          => $total_stok_rupiah,
// 							'log_average_large_unit'         => $log_average_large_unit,
// 							'log_average_medium_unit'        => $log_average_medium_unit,
// 							'log_average_small_unit'         => $log_average_small_unit,
// 							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
// 						);
// 					}
// 				}

// 				$after_row_log_update = $this->Logs_model->update_item_batch($data_log);
// 			} else {
// 				return true;
// 			}
// 		}

// 		// if(!empty($data_log)){

// 		// }

// 		return true;
// 	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {


			$delete_header = $this->Selling_orders_model->delete_header($row);

			if ($delete_header) {
				$query = $this->Selling_orders_model->purchaseorder_detail(['selling_order_detail_header_id' => $row])->result();
				foreach($query as $rowDetail){
					$whereI = array('item_id' => $rowDetail->selling_order_detail_item_id);
					$item_data_check   = $this->Items_model->get_data($whereI)->row_array();
					$where_item = $rowDetail->selling_order_detail_item_id;
					
					$data_item = array(
						'item_out_total'  =>  $item_data_check['item_out_total'] - ((int)trims($rowDetail->selling_order_detail_small_unit_quantity) *  $item_data_check['small_unit_contain']) - ((int)trims($rowDetail->selling_order_detail_medium_unit_quantity) *  $item_data_check['medium_unit_contain']) - ((int)trims($rowDetail->selling_order_detail_large_unit_quantity) *  $item_data_check['large_unit_contain']),		
						// 'stock_total' => $item_data_check['item_in_total'] - $item_data_check['item_out_total'],
						// 'stock_besar' => $item_data_check['stock_total'] / $item_data_check['large_unit_contain'],
						//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
						//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
					);

					$update_item =  $this->Items_model->update($where_item, $data_item);
					if($update_item){
						$whereI2               = array('item_id' => $rowDetail->selling_order_detail_item_id);
						$item_data_check2             = $this->Items_model->get_data($whereI2)->row_array();
						$where_item = $rowDetail->selling_order_detail_item_id;
						
						$data_item2 = array(
							'stock_total' => $item_data_check2['item_in_total'] - $item_data_check2['item_out_total'],
							//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
							//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
						);
						$this->Items_model->update($where_item, $data_item2);
						
						
					}
					$delete_type = $this->Selling_orders_model->delete_detail($row);
					$response = array(
						'message' => 'Berhasil menghapus data',
						'status'  => 'success'
					);
			
					output_json($response);
					
					
				}
			}

			// $jr_delheader = $this->Journals_model->delete_headerbytrxid($row, "BUY");
			// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($row, "BUY");

			// $id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $row, 'status' => 'BUY'))->row()->header_id;

			// $tf_delheader = $this->Transfer_model->delete_header($id_transfer);
			// $tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);
		}

		
	}

	public function delete2()
	{
		$id = $this->input->post('id');



			$delete_header = $this->Selling_orders_model->delete_header($id);

			if ($delete_header) {
				$query = $this->Selling_orders_model->purchaseorder_detail(['selling_order_detail_header_id' => $id])->result();
				foreach($query as $rowDetail){
					$whereI = array('item_id' => $rowDetail->selling_order_detail_item_id);
					$item_data_check   = $this->Items_model->get_data($whereI)->row_array();
					$where_item = $rowDetail->selling_order_detail_item_id;
					
					$data_item = array(
						'item_out_total'  =>  $item_data_check['item_out_total'] - ((int)trims($rowDetail->selling_order_detail_small_unit_quantity) *  $item_data_check['small_unit_contain']) - ((int)trims($rowDetail->selling_order_detail_medium_unit_quantity) *  $item_data_check['medium_unit_contain']) - ((int)trims($rowDetail->selling_order_detail_large_unit_quantity) *  $item_data_check['large_unit_contain']),		
						// 'stock_total' => $item_data_check['item_in_total'] - $item_data_check['item_out_total'],
						// 'stock_besar' => $item_data_check['stock_total'] / $item_data_check['large_unit_contain'],
						//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
						//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
					);

					$update_item =  $this->Items_model->update($where_item, $data_item);
					if($update_item){
						$whereI2               = array('item_id' => $rowDetail->selling_order_detail_item_id);
						$item_data_check2             = $this->Items_model->get_data($whereI2)->row_array();
						$where_item = $rowDetail->selling_order_detail_item_id;
						
						$data_item2 = array(
							'stock_total' => $item_data_check2['item_in_total'] - $item_data_check2['item_out_total'],
							//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
							//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
						);
						$this->Items_model->update($where_item, $data_item2);
						
						
					}
					$delete_type = $this->Selling_orders_model->delete_detail($id);
					$response = array(
						'message' => 'Berhasil menghapus data',
						'status'  => 'success'
					);
			
					output_json($response);
					
					
				}
			}

			// $jr_delheader = $this->Journals_model->delete_headerbytrxid($row, "BUY");
			// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($row, "BUY");

			// $id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $row, 'status' => 'BUY'))->row()->header_id;

			// $tf_delheader = $this->Transfer_model->delete_header($id_transfer);
			// $tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

		
	}

	public function delete_item()
	{
		$id        = $this->input->post('id');
		$item      = $this->input->post('item');
		$total      = $this->input->post('total');
		$data_item = [];

		$delete_type = $this->Selling_orders_model->delete_detail_advance(array('selling_order_detail_header_id' => $id, 'selling_order_detail_item_id' => $item['id']));
		if ($delete_type) {
			$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'BUY', 'log_item_id' => $item['id']));
		}

		if ($delete_log) {
			$whereH = array('selling_order_header_id' => $id);
			$header_data_check   = $this->Selling_orders_model->purchaseorder_header($whereH)->row_array();
			$header_data = [
				
				'selling_order_header_grand_total'    => $header_data_check['selling_order_header_grand_total'] - (int)trims($total),
			];
			$save_header  = $this->Selling_orders_model->update_header($id, $header_data);
			$whereI = array('item_id' => $item['id']);
			$item_data_check   = $this->Items_model->get_data($whereI)->row_array();
			$where_item = $item['id'];
			
			$data_item = array(
				'item_out_total'  =>  $item_data_check['item_out_total'] - ((int)trims($item['sm_unit_qty_old']) *  $item_data_check['small_unit_contain']) - ((int)trims($item['md_unit_qty_old']) *  $item_data_check['medium_unit_contain']) - ((int)trims($item['lg_unit_qty_old'] *  $item_data_check['large_unit_contain'])),		
				// 'stock_total' => $item_data_check['item_in_total'] - $item_data_check['item_out_total'],
				// 'stock_besar' => $item_data_check['stock_total'] / $item_data_check['large_unit_contain'],
				//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
				//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
			);


			$update_item =  $this->Items_model->update($where_item, $data_item);
			if($update_item){
				$whereI2               = array('item_id' => $item['id']);
				$item_data_check2             = $this->Items_model->get_data($whereI2)->row_array();
				$where_item = $item['id'];
				
				$data_item2 = array(
					'stock_total' => $item_data_check2['item_in_total'] - $item_data_check2['item_out_total'],
					//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
					//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
				);
				$this->Items_model->update($where_item, $data_item2);

			$response = array(
				'message' => 'Berhasil menghapus data',
				'status'  => 'success'
			);
		}
		}



		output_json($response);
	}

	public function print_out($id)
	{
		$where_header  = array('selling_order_header_id' => $id);
		$where_detail  = array('selling_order_detail_header_id' => $id);
// 		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');

// 		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();

		$header = $this->Selling_orders_model->purchaseorder_header($where_header)->row_array();
		$detail = $this->Selling_orders_model->purchaseorder_detail2($where_detail, 'item_name')->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;
		$data['time'] = date('H:i:s');
// 		$data['config_receipt2'] = $config_receipt2;

		$this->twiggy_display('adm/selling_orders/printout_invoice', $data);
	}
		public function print_out2($id)
	{
		$where_header  = array('selling_order_header_id' => $id);
		$where_detail  = array('selling_order_detail_header_id' => $id);
// 		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');

// 		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();

		$header = $this->Selling_orders_model->purchaseorder_header($where_header)->row_array();
		$detail = $this->Selling_orders_model->purchaseorder_detail2($where_detail, 'item_name')->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;
		$data['time'] = date('H:i:s');
// 		$data['config_receipt2'] = $config_receipt2;

		$this->twiggy_display('adm/selling_orders/printout_invoice2', $data);
	}

	public function export_excel($id) {

		
		// 		$id = $this->session->userdata('so_id');
		
				$where    = [];
				$where['selling_order_header_id'] = $id;
		
				$get_data = $this->Selling_orders_model->purchaseorder_detail_advance($where)->result();
		
				
				// Class PHPExcel
				$excel = new PHPExcel();
				// Settingan awal file excel
				$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
									   ->setLastModifiedBy('TOKO TEST INDONESIA')
									   ->setTitle("PENJUALAN")
									   ->setSubject("PENJUALAN")
									   ->setDescription("PENJUALAN")
									   ->setKeywords("PENJUALAN");
		
		
				$excel->setActiveSheetIndex(0)->setCellValue('A1', "nomor");
				$excel->setActiveSheetIndex(0)->setCellValue('B1', "tanggal");
				$excel->setActiveSheetIndex(0)->setCellValue('C1', "customer");
				$excel->setActiveSheetIndex(0)->setCellValue('D1', "nama");
				$excel->setActiveSheetIndex(0)->setCellValue('E1', "besar");
				$excel->setActiveSheetIndex(0)->setCellValue('F1', "qtybesar");
				$excel->setActiveSheetIndex(0)->setCellValue('G1', "hjbesar");
				$excel->setActiveSheetIndex(0)->setCellValue('H1', "totalharga");
				$excel->setActiveSheetIndex(0)->setCellValue('I1', "grandtotal");
				$excel->setActiveSheetIndex(0)->setCellValue('J1', "keterangan");
				$excel->setActiveSheetIndex(0)->setCellValue('K1', "bayar");
				$excel->setActiveSheetIndex(0)->setCellValue('L1', "kembali");
				$excel->setActiveSheetIndex(0)->setCellValue('M1', "Dicount");
				$excel->setActiveSheetIndex(0)->setCellValue('N1', "user");
				$excel->setActiveSheetIndex(0)->setCellValue('O1', "RESEP");
		
			
		
				$no = 1; // Untuk penomoran tabel, di awal set dengan 1
				
				 //while($get_data){
					$numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 9
					foreach($get_data as $get_row){ // Lakukan looping pada variabel row
						$where2    = [];
						$where2['item_id'] = $get_row->selling_order_detail_item_id;
						$item = $this->Items_model->get_data($where2)->row();
		
						// $unit_large  = $this->Units_model->get_data(array('unit_name' => $get_row->selling_order_detail_large_unit))->row_array();
						// $unit_medium = $this->Units_model->get_data(array('unit_name' => $get_row->selling_order_detail_medium_unit))->row_array();
						// $unit_small  = $this->Units_model->get_data(array('unit_name' => $get_row->selling_order_detail_small_unit))->row_array();
			
						$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->selling_order_header_number);
						$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->selling_order_header_date, 'd/m/Y'));
						$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_name);
						$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->selling_order_detail_item_name);
						$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($get_row->selling_order_detail_large_unit_quantity  > 0 ? $get_row->selling_order_detail_large_unit : ''));
						$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, ($get_row->selling_order_detail_large_unit_quantity  > 0 ? to_decimal($get_row->selling_order_detail_large_unit_quantity) : ''));
						$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->selling_order_detail_large_unit_quantity  > 0 ? ($get_row->selling_order_detail_large_unit_price) : ''));
						$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->selling_order_detail_result_large + $get_row->selling_order_detail_result_medium + $get_row->selling_order_detail_result_small));
						$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->selling_order_header_grand_total);
						$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, rtrim($get_row->selling_order_header_description));
						$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, rtrim($get_row->selling_order_header_paid_total));
						$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, rtrim($get_row->selling_order_header_paid_total - $get_row->selling_order_header_grand_total));
						$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, rtrim($get_row->selling_order_header_discount));
			            $excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, rtrim($get_row->username));
			            $excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, 0);
			
						  $no++; // Tambah 1 setiap kali looping
						  $numrow++; // Tambah 1 setiap kali looping
					}
					 
				//}
				
				// Set width
				$excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);
		
				// Set height
				$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
				
				// Set orientasi kertas jadi LANDSCAPE
				$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
				
				// Set judul file excel
				$excel->getActiveSheet(0)->setTitle("PENJUALAN");
				$excel->setActiveSheetIndex(0);
				
				// Proses file excel
				// $date_now = change_format_date(date_now(), 'Ymd');
				$filename = $get_data[0]->selling_order_header_number.'.csv';
		
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
				header('Cache-Control: max-age=0');
				// $write = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
				$write = new PHPExcel_Writer_CSV($excel);
				$write->save('php://output');
			
		}
		
			public function export_excel_resep($id) {

		
		// 		$id = $this->session->userdata('so_id');
		
				$where    = [];
				$where['selling_order_header_id'] = $id;
		
				$get_data = $this->Selling_orders_model->purchaseorder_detail_advance($where)->result();
		
				
				// Class PHPExcel
				$excel = new PHPExcel();
				// Settingan awal file excel
				$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
									   ->setLastModifiedBy('TOKO TEST INDONESIA')
									   ->setTitle("PENJUALAN")
									   ->setSubject("PENJUALAN")
									   ->setDescription("PENJUALAN")
									   ->setKeywords("PENJUALAN");
		
		
				$excel->setActiveSheetIndex(0)->setCellValue('A1', "nomor");
				$excel->setActiveSheetIndex(0)->setCellValue('B1', "tanggal");
				$excel->setActiveSheetIndex(0)->setCellValue('C1', "customer");
				$excel->setActiveSheetIndex(0)->setCellValue('D1', "nama");
				$excel->setActiveSheetIndex(0)->setCellValue('E1', "besar");
				$excel->setActiveSheetIndex(0)->setCellValue('F1', "qtybesar");
				$excel->setActiveSheetIndex(0)->setCellValue('G1', "hjbesar");
				$excel->setActiveSheetIndex(0)->setCellValue('H1', "totalharga");
				$excel->setActiveSheetIndex(0)->setCellValue('I1', "grandtotal");
				$excel->setActiveSheetIndex(0)->setCellValue('J1', "keterangan");
				$excel->setActiveSheetIndex(0)->setCellValue('K1', "bayar");
				$excel->setActiveSheetIndex(0)->setCellValue('L1', "kembali");
				$excel->setActiveSheetIndex(0)->setCellValue('M1', "Dicount");
				$excel->setActiveSheetIndex(0)->setCellValue('N1', "user");
				$excel->setActiveSheetIndex(0)->setCellValue('O1', "RESEP");
		
			
		
				$no = 1; // Untuk penomoran tabel, di awal set dengan 1
				
				 //while($get_data){
					$numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 9
					foreach($get_data as $get_row){ // Lakukan looping pada variabel row
						$where2    = [];
						$where2['item_id'] = $get_row->selling_order_detail_item_id;
						$item = $this->Items_model->get_data($where2)->row();
		
						// $unit_large  = $this->Units_model->get_data(array('unit_name' => $get_row->selling_order_detail_large_unit))->row_array();
						// $unit_medium = $this->Units_model->get_data(array('unit_name' => $get_row->selling_order_detail_medium_unit))->row_array();
						// $unit_small  = $this->Units_model->get_data(array('unit_name' => $get_row->selling_order_detail_small_unit))->row_array();
			
						$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->selling_order_header_number);
						$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->selling_order_header_date, 'd/m/Y'));
						$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_name);
						$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->selling_order_detail_item_name);
						$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($get_row->selling_order_detail_large_unit_quantity  > 0 ? $get_row->selling_order_detail_large_unit : ''));
						$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, ($get_row->selling_order_detail_large_unit_quantity  > 0 ? to_decimal($get_row->selling_order_detail_large_unit_quantity) : ''));
						$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->selling_order_detail_large_unit_quantity  > 0 ? ($get_row->selling_order_detail_large_unit_price) : ''));
						$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->selling_order_detail_result_large + $get_row->selling_order_detail_result_medium + $get_row->selling_order_detail_result_small));
						$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->selling_order_header_grand_total);
						$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, rtrim($get_row->selling_order_header_description));
						$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, rtrim($get_row->selling_order_header_paid_total));
						$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, rtrim($get_row->selling_order_header_paid_total - $get_row->selling_order_header_grand_total));
						$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, rtrim($get_row->selling_order_header_discount));
			            $excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, rtrim($get_row->username));
			            $excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, 1);
			
			
						  $no++; // Tambah 1 setiap kali looping
						  $numrow++; // Tambah 1 setiap kali looping
					}
					 
				//}
				
				// Set width
				$excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);
		
				// Set height
				$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
				
				// Set orientasi kertas jadi LANDSCAPE
				$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
				
				// Set judul file excel
				$excel->getActiveSheet(0)->setTitle("PENJUALAN");
				$excel->setActiveSheetIndex(0);
				
				// Proses file excel
				// $date_now = change_format_date(date_now(), 'Ymd');
				$filename = $get_data[0]->selling_order_header_number.'.csv';
		
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
				header('Cache-Control: max-age=0');
				// $write = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
				$write = new PHPExcel_Writer_CSV($excel);
				$write->save('php://output');
			
		}
		
		
	
	

	public function ex_average($id = '')
	{
		// $where_header = array('purchase_order_header_id' => $id);
		// $where_detail = array('purchase_order_detail_header_id' => $id);

		$order = ("b.item_name, a.log_id ASC");
		$detail = $this->Logs_model->get_data('', $order)->result();

		$data['content_title'] = 'Hasil Perhitungan Average';
		// $data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/purchase_orders/print_avg', $data);
	}
	
	public function printout_invoice($id)
	{
		$where_header  = array('selling_order_header_id' => $id);
		$where_detail  = array('selling_order_detail_header_id' => $id);
        $printed_date = change_format_date(date_now());
		$header = $this->Selling_orders_model->purchaseorder_header($where_header)->row_array();
		$detail = $this->Selling_orders_model->purchaseorder_detail2($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['printed_date'] = $printed_date;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/selling_orders/printout_invoice', $data);
	}

	public function ed_average($id = '')
	{
		$detail = $this->Logs_model->get_data()->result();
		foreach ($detail as $key => $get_row) {
			$data[] = array(
				'log_total_transaction_in_small_unit' => $get_row[$key]->log_total_transaction_in_small_unit,
				'log_total_transaction_value'         => $get_row->log_total_transaction_value,
				'log_total_stock'                     => $get_row->log_total_stock,
				'log_total_stock_value'               => $get_row->log_total_stock_value,
				'log_average_large_unit'              => $get_row->log_average_large_unit,
				'log_average_medium_unit'             => $get_row->log_average_medium_unit,
				'log_average_small_unit'              => $get_row->log_average_small_unit
			);
		}

		echo json_encode($data);
	}
	
	
}
