<?php
/**
 * API Group Group Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Barang extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
        parent::__construct();

		// load model
		$this->load->model('Items_model');
	}
    
    public function index()
	{	
		$group_parent   = $this->input->post('group_parent'); 
		$group_sub 		= $this->input->post('group_sub');

		$where = [];
		if(isset($group_parent) && $group_parent != '')
		{
			$where['item_group_id'] = $group_parent;
		}

		if(isset($group_sub) && $group_sub != '')
		{
			$where['item_group_child_id'] = $group_sub;
		}

		$where['mobile_active'] = '1';
		
        $data = [];
		$get_data = $this->Items_model->get_data($where)->result();

		if($get_data)
		{
			foreach($get_data as $row)
			{	
				$lg_unit = ($row->large_unit_contain == "0.00" ? "" : number_format($row->large_unit_contain));
				$md_unit = ($row->medium_unit_contain == "0.00" ? "" : number_format($row->medium_unit_contain));
				$sm_unit = ($row->small_unit_contain == "0.00" ? "" : number_format($row->small_unit_contain));

				$data[] = array(
					'id'              => $row->item_id,
					'group_parent_id' => $row->item_group_id,
					'group_sub_id'    => $row->item_group_child_id,
					'nama_barang'     => $row->item_name,
					'grup_parent'     => $row->group_name,
					'grup_child'      => $row->group_child_name,
					'satuan_besar'    => $row->large_unit,
					'quantity_besar'  => $lg_unit,
					'satuan_sedang'   => $row->medium_unit,
					'quantity_sedang' => $md_unit,
					'satuan_kecil'    => $row->small_unit,
					'quantity_kecil'  => $sm_unit,
					'image_url'       => base_url('assets/images/upload_file/items/'). $row->img_filename
				);
			}
            $code    = 200;
			$status  = true;
			$message = 'Berhasil';
		}
		else 
		{
			$code    = 200;
			$status  = false;
			$message = 'Gagal';
		}

		$response = [
            'code'    => $code,
			'success' => $status,
            'data'    => $data,
			'message' => $message,
        ];
        
		header('Content-Type: application/json');
		echo json_encode($response);
	}

	public function pencarian()
	{	
		$nama_barang   = $this->input->post('nama_barang');

		// echo $nama_barang;
		// die();
        $data = [];
		$get_data = $this->Items_model->get_data_search_mobile($nama_barang)->result();

		if($get_data)
		{
			foreach($get_data as $row)
			{	
				$lg_unit = ($row->large_unit_contain == "0.00" ? "" : number_format($row->large_unit_contain));
				$md_unit = ($row->medium_unit_contain == "0.00" ? "" : number_format($row->medium_unit_contain));
				$sm_unit = ($row->small_unit_contain == "0.00" ? "" : number_format($row->small_unit_contain));

				$data[] = array(
					'id'              => $row->item_id,
					'group_parent_id' => $row->item_group_id,
					'group_sub_id'    => $row->item_group_child_id,
					'nama_barang'     => $row->item_name,
					'grup_parent'     => $row->group_name,
					'grup_child'      => $row->group_child_name,
					'satuan_besar'    => $row->large_unit,
					'quantity_besar'  => $lg_unit,
					'satuan_sedang'   => $row->medium_unit,
					'quantity_sedang' => $md_unit,
					'satuan_kecil'    => $row->small_unit,
					'quantity_kecil'  => $sm_unit,
					'image_url'       => base_url('assets/images/upload_file/items/'). $row->img_filename
				);
			}
            $code    = 200;
			$status  = true;
			$message = 'Berhasil';
		}
		else 
		{
			$code    = 200;
			$status  = false;
			$message = 'Gagal';
		}

		$response = [
            'code'    => $code,
			'success' => $status,
            'data'    => $data,
			'message' => $message,
        ];
        
		header('Content-Type: application/json');
		echo json_encode($response);
	}

}

?>
