<?php

/**
 * Divisions Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Divisions_model extends Model
{

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('divisions');
		$sql->order_by('division_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data)
	{
		return $this->db->insert('divisions', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('division_id', $id);
		return $this->db->update('divisions', $data);
	}

	public function delete($id)
	{
		$this->db->where('division_id', $id);
		return $this->db->delete('divisions');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('divisions');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
