<?php
/**
 * Dropshippers Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Dropshippers_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_dropshippers');
		$sql->order_by('dropshipper_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_dropshippers', $data);
	}

	public function update($id, $data) {
		$this->db->where('dropshipper_id', $id);
		return $this->db->update('master_dropshippers', $data);
	}

	public function delete($id) {
		$this->db->where('dropshipper_id', $id);
		return $this->db->delete('master_dropshippers');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_dropshippers');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}
