<?php

/**
 * pembelian Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Pembelian_model extends Model
{

	public function pembelian_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('pembelian_header a');
		// $sql->join('master_customers b', 'b.customer_id = a.customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function pembelian_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, a.item_code as it_code, a.item_name as it_name');
		$sql->from('pembelian_detail a');
		$sql->join('master_items b', 'b.item_id = a.pembelian_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('pembelian_header', $data);
		}

		return $this->db->insert('pembelian_header', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('pembelian_detail', $data);
		}

		return $this->db->insert('pembelian_detail', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('pembelian_header_id', $id);
		return $this->db->update('pembelian_header', $data);
	}

	public function update_master_item_batch($data)
	{
		return $this->db->update_batch('master_items', $data, 'item_id');
	}

	public function delete_header($id)
	{
		$this->db->where("pembelian_header_id", $id);
		return $this->db->delete("pembelian_header");
	}

	public function delete_detail($id)
	{
		$this->db->where("pembelian_detail_header_id", $id);
		return $this->db->delete("pembelian_detail");
	}

	public function delete_detail_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("pembelian_detail");
	}
}
