<?php
/**
 * Ppn Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Ppn_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_ppn');
		$sql->order_by('is_active desc');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_ppn', $data);
	}

	public function update($where, $data) {
		$this->db->where($where);
		return $this->db->update('master_ppn', $data);
	}

	public function get_data_ppn_status($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_ppn_status');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function update_ppn_status($id) {
		$this->db->set('number', 'number+1', FALSE);
		$this->db->where('ppn_status_id', $id);
		return $this->db->update('master_ppn_status');
	}

	public function update_ppn_abbrev($id, $data) {
		$this->db->where('ppn_status_id', $id);
		return $this->db->update('master_ppn_status', $data);
	}

	public function reset_ppn_status($period) {
		$this->db->set('number', '0');
		$this->db->set('period', $period);
		return $this->db->update('master_ppn_status');
	}

	public function delete($id) {
		$this->db->where('id', $id);
		return $this->db->delete('master_ppn');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_ppn');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
