<?php

/**
 * Dashboards Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Report_model extends Model
{

	public function get_dropshipper()
	{
		$sql = "
		SELECT dropshipper
				FROM
				sales_header
				GROUP BY dropshipper
				ORDER BY dropshipper asc
		";

		return $this->db->query($sql);
	}

	public function get_courier()
	{
		$sql = "
		SELECT courier
				FROM
				sales_header
				GROUP BY courier
				ORDER BY courier asc
		";

		return $this->db->query($sql);
	}

	public function get_item()
	{
		$sql = "
		SELECT selling_order_detail_item_name as item
				FROM
				selling_order_details
				GROUP BY selling_order_detail_item_name
				ORDER BY selling_order_detail_item_name asc
		";

		return $this->db->query($sql);
	}

	public function get_sales_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('selling_order_details a');
		$sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'inner');
		 $sql->join('master_customers c', 'c.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function get_sales_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('selling_order_headers a');
// 		$sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'inner');
		 $sql->join('master_customers b', 'b.customer_id = a.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_rekap_tipe($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(quantity) as qty, SUM(price) as harga, SUM(quantity * price) as jumlah');
		$sql->from('sales_detail a');

		$sql->join('sales_header b', 'b.id = a.header_id', 'inner');

		$sql->join('master_items c', 'c.item_id = a.item_id', 'inner');
		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('item_type_id');

		$get = $sql->get();

		return $get;
	}

	public function get_item_recap($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(selling_order_detail_large_unit_quantity) as total');
		$sql->from('selling_order_details a');
		$sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('selling_order_detail_item_name');

		$get = $sql->get();

		return $get;
	}
		public function get_group_recap($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(selling_order_detail_large_unit_quantity) as total');
		$sql->from('selling_order_details a');
		$sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'inner');
		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('group_name');

		$get = $sql->get();

		return $get;
	}

	public function get_surat_jalan($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, count(*) as total');
		$sql->from('sales_header a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('courier');

		$get = $sql->get();

		return $get;
	}

	public function get_rekap_dropshipper($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(quantity) as qty, sum(amount) total');
		$sql->from('sales_detail a');
		$sql->join('sales_header b', 'b.id = a.header_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('dropshipper');

		$get = $sql->get();

		return $get;
	}

	public function get_sum_ttl_by_header_id($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(quantity * price) as total');
		$sql->from('sales_detail a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('header_id');

		$get = $sql->get();

		return $get;
	}

	public function get_total_trainee()
	{
		$sql = "
			SELECT  Months.m AS month, COUNT(graduates.created_at) AS count FROM 
			(
				SELECT 1 as m 
				UNION SELECT 2 as m 
				UNION SELECT 3 as m 
				UNION SELECT 4 as m 
				UNION SELECT 5 as m 
				UNION SELECT 6 as m 
				UNION SELECT 7 as m 
				UNION SELECT 8 as m 
				UNION SELECT 9 as m 
				UNION SELECT 10 as m 
				UNION SELECT 11 as m 
				UNION SELECT 12 as m
			) as Months
			LEFT JOIN graduates on Months.m = MONTH(graduates.created_at)
			AND YEAR(graduates.created_at) = YEAR(CURDATE())
			GROUP BY Months.m
		";

		return $this->db->query($sql);
	}

	public function get_total_program_public()
	{
		$sql = "		
			SELECT  Months.m AS month, COUNT(program_headers.timestamp) AS count FROM 
			(
				SELECT 1 as m 
				UNION SELECT 2 as m 
				UNION SELECT 3 as m 
				UNION SELECT 4 as m 
				UNION SELECT 5 as m 
				UNION SELECT 6 as m 
				UNION SELECT 7 as m 
				UNION SELECT 8 as m 
				UNION SELECT 9 as m 
				UNION SELECT 10 as m 
				UNION SELECT 11 as m 
				UNION SELECT 12 as m
			) as Months
			LEFT JOIN program_headers on Months.m = MONTH(program_headers.timestamp)
			AND program_headers.program_header_type_id = 1
			AND YEAR(program_headers.timestamp) = YEAR(CURDATE())
			GROUP BY Months.m
		";

		return $this->db->query($sql);
	}

	public function get_total_program_inhouse()
	{
		$sql = "		
			SELECT  Months.m AS month, COUNT(program_headers.timestamp) AS count FROM 
			(
				SELECT 1 as m 
				UNION SELECT 2 as m 
				UNION SELECT 3 as m 
				UNION SELECT 4 as m 
				UNION SELECT 5 as m 
				UNION SELECT 6 as m 
				UNION SELECT 7 as m 
				UNION SELECT 8 as m 
				UNION SELECT 9 as m 
				UNION SELECT 10 as m 
				UNION SELECT 11 as m 
				UNION SELECT 12 as m
			) as Months
			LEFT JOIN program_headers on Months.m = MONTH(program_headers.timestamp)
			AND program_headers.program_header_type_id = 2
			AND YEAR(program_headers.timestamp) = YEAR(CURDATE())
			GROUP BY Months.m
		";

		return $this->db->query($sql);
	}

	public function get_new_entry($table_name = '', $condition = '')
	{
		$sql = $this->db;

		$sql->select("COUNT(*) count");
		$sql->from($table_name);
		$sql->where("MONTH(timestamp) = MONTH(CURRENT_DATE())");

		if ($condition != "") {
			$sql->where($condition);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_program($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('batch_headers a');
		$sql->join('program_headers b', 'b.program_header_id = a.batch_header_program_id', 'inner');
		$sql->join('master_program_types c', 'c.program_type_id = b.program_header_type_id', 'inner');

		if (!empty($where)) {
			$sql->where($where);
		}

		$sql->order_by('batch_header_start', 'asc');
		$sql->limit(3);

		$get = $sql->get();

		return $get;
	}

	public function check_status($status = '')
	{
		$sql = "
		SELECT *
				FROM
				graduates
				WHERE
				status = '" . $status . "'
		";

		return $this->db->query($sql);
	}
}
