<?php

/**
 * Dashboards Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Report_stock_model extends Model
{

	public function get_group()
	{
		$sql = "
		SELECT *
				FROM
				master_groups
		";

		return $this->db->query($sql);
	}

	public function get_type()
	{
		$sql = "
		SELECT *
				FROM
				master_types
		";

		return $this->db->query($sql);
	}

	public function get_color()
	{
		$sql = "
		SELECT *
				FROM
				master_colors
		";

		return $this->db->query($sql);
	}

	public function get_size()
	{
		$sql = "
		SELECT *
				FROM
				master_sizes
		";

		return $this->db->query($sql);
	}

	public function get_item($where)
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
// 		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'inner');
// 		$sql->join('master_types c', 'c.type_id = a.item_type_id', 'inner');
// 		$sql->join('master_colors d', 'd.color_id = a.item_color_id', 'inner');
// 		$sql->join('master_sizes e', 'e.size_id = a.item_size_id', 'inner');
		if ($where != '') {
			$sql->where($where);
		}

		$sql->order_by('item_name');

		$get = $sql->get();

		return $get;
	}

	public function get_purchase_detail($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(purchase_order_detail_large_unit_quantity) as s_quantity, sum(purchase_order_detail_total) as s_amount');
		$sql->from('purchase_order_details a');
		$sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.purchase_order_detail_header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.purchase_order_detail_item_id', 'inner');
		$sql->join('master_suppliers d', 'd.supplier_id = b.purchase_order_header_customer_id', 'inner');
// 		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
// 		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');
// 		$sql->join('master_colors f', 'f.color_id = c.item_color_id', 'inner');
// 		$sql->join('master_sizes g', 'g.size_id = c.item_size_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function get_purchase_detail2($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_order_details a');
		$sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.purchase_order_detail_header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.purchase_order_detail_item_id', 'inner');
		$sql->join('master_suppliers d', 'd.supplier_id = b.purchase_order_header_customer_id', 'inner');
// 		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
// 		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');
// 		$sql->join('master_colors f', 'f.color_id = c.item_color_id', 'inner');
// 		$sql->join('master_sizes g', 'g.size_id = c.item_size_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_selling_order_details($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(selling_order_detail_large_unit_quantity) as s_quantity');
		$sql->from('selling_order_details a');
		$sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'inner');
// 		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
// 		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');
// 		$sql->join('master_colors f', 'f.color_id = c.item_color_id', 'inner');
// 		$sql->join('master_sizes g', 'g.size_id = c.item_size_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function get_selling_order_details2($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('selling_order_details a');
		$sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'inner');
// 		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
// 		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');
// 		$sql->join('master_colors f', 'f.color_id = c.item_color_id', 'inner');
// 		$sql->join('master_sizes g', 'g.size_id = c.item_size_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function get_sales_detail_lite($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(selling_order_detail_large_unit_quantity) as s_quantity');
		$sql->from('selling_order_details a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_stock_detail($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(quantity) as s_quantity');
		$sql->from('stock_detail a');
		$sql->join('stock_header b', 'b.id = a.header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.stock_item_id', 'inner');
// 		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
// 		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');
// 		$sql->join('master_colors f', 'f.color_id = c.item_color_id', 'inner');
// 		$sql->join('master_sizes g', 'g.size_id = c.item_size_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_purchase_detail_lite($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(quantity) as s_quantity, sum(amount) as s_amount');
		$sql->from('purchase_detail a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_selling_order_details_lite($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(quantity) as s_quantity');
		$sql->from('selling_order_details a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_stock_detail_lite($where = '', $order = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(quantity) as s_quantity');
		$sql->from('stock_detail a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
}
