<?php

/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Sales_model extends Model
{
	public function sales_number()
	{
		$sql = $this->db;

		$sql->select('sales_header.number as serial_number', FALSE);
		$sql->where('timestamp = CURRENT_DATE()');
		$sql->order_by('cast(number as unsigned)', 'DESC');
		$sql->limit(1);
		$query = $sql->get('sales_header');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 1;
		}

		// $serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number;
		return $result;
	}

	public function sales_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, a.customer_name as cs_name');
		$sql->from('sales_header a');
		$sql->join('master_customers b', 'b.customer_id = a.customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function sales_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, a.item_code as it_code, a.item_name as it_name');
		$sql->from('sales_detail a');
		$sql->join('master_items b', 'b.item_id = a.item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('sales_header', $data);
		}

		return $this->db->insert('sales_header', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('sales_detail', $data);
		}

		return $this->db->insert('sales_detail', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('id', $id);
		return $this->db->update('sales_header', $data);
	}

	public function update_master_item_batch($data)
	{
		return $this->db->update_batch('master_items', $data, 'item_id');
	}

	public function delete_header($id)
	{
		$this->db->where("id", $id);
		return $this->db->delete("sales_header");
	}

	public function delete_detail($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("sales_detail");
	}

	public function delete_detail_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("sales_detail");
	}
}
