<?php
/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Selling_orders_model extends Model {

	public function purchaseorder_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(selling_order_headers.selling_order_header_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(selling_order_header_date) = MONTH(CURRENT_DATE())');
		// $sql->where('SUBSTR(purchase_order_headers.purchase_order_header_number, 1, 2) = "'.$supp_code.'"');
		$sql->order_by('selling_order_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('selling_order_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function purchaseorder_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*, , a.timestamp as tmstamp_po');
		$sql->from('selling_order_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.selling_order_header_customer_id', 'inner');
	     $sql->join('users c', 'c.username = a.username', 'left');
	      $sql->join('master_jenis_bayar d', 'd.id = a.selling_order_header_jenis_bayar_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function purchaseorder_header_delayed($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*, , a.timestamp as tmstamp_po');
		$sql->from('selling_order_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.selling_order_header_customer_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}
		$sql->where('is_hold', 1);
		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('selling_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.selling_order_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail2($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('selling_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.selling_order_detail_item_id', 'left');
	    $sql->join('master_groups c', 'c.group_id = b.item_group_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function purchaseorder_detail_advance_group($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('selling_by_customer_and_item');
	    // $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    // $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    // $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function purchaseorder_detail_sum_qty($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(qtybesar) as totalqtybesar,sum(qtysedang) as totalqtysedang,sum(qtykecil) as totalqtykecil');
	    $sql->from('selling_by_customer_and_item');
	    // $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    // $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    // $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_advance($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('selling_order_details a');
	    $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');
	   // $sql->join('master_jenis_bayar e', 'e.id = b.selling_order_header_jenis_bayar_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_sum($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(selling_order_header_grand_total) as result');
// 			$sql->select('*, sum(selling_order_detail_result_large + selling_order_detail_result_medium + selling_order_detail_result_small) as result');
	    $sql->from('selling_order_details a');
	    $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function purchaseorder_detail_sum_qty2($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(selling_order_detail_large_unit_quantity) as result');
// 			$sql->select('*, sum(selling_order_detail_result_large + selling_order_detail_result_medium + selling_order_detail_result_small) as result');
	    $sql->from('selling_order_details a');
	    $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function purchaseorder_detail_sum_modal($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;


		$sql->select('*, sum(selling_order_detail_large_unit_quantity * selling_order_detail_large_unit_purchase_price) as result');
// 			$sql->select('*, sum(selling_order_detail_result_large + selling_order_detail_result_medium + selling_order_detail_result_small) as result');
	    $sql->from('selling_order_details a');
	    $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function purchaseorder_detail_sum_laba($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;
    


		$sql->select('*, sum(selling_order_detail_total - (selling_order_detail_large_unit_quantity * selling_order_detail_large_unit_purchase_price)) as result');
// 			$sql->select('*, sum(selling_order_detail_result_large + selling_order_detail_result_medium + selling_order_detail_result_small) as result');
	    $sql->from('selling_order_details a');
	    $sql->join('selling_order_headers b', 'b.selling_order_header_id = a.selling_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.selling_order_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.selling_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_headersearch($type='', $supplier='', $search='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($search != '')
		{
			$sql->like('purchase_order_header_number', $search);
			$sql->or_like('purchase_order_header_date', $search);
		}

		$sql->where('purchase_order_header_supplier_id', $supplier);
		$sql->where('status_paid', 0);
		$sql->order_by('purchase_order_header_date asc');

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('selling_order_headers', $data);
		}

		return $this->db->insert('selling_order_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('selling_order_details', $data);
		}

		return $this->db->insert('selling_order_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('selling_order_header_id', $id);
		return $this->db->update('selling_order_headers', $data);
	}

	public function update_item_batch($data) {
		// $this->db->where('log_id', $where);
		return $this->db->update_batch('logs', $data, 'log_id');
	}

	public function update_master_item_batch($data) {
		return $this->db->update_batch('master_items', $data, 'item_id');
	}

	public function delete_header($id)
	{
		$this->db->where("selling_order_header_id", $id);
		return $this->db->delete("selling_order_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("selling_order_detail_header_id", $id);
		return $this->db->delete("selling_order_details");
	}

	public function delete_detail_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("selling_order_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("selling_order_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("selling_order_details");
	}

}
