<?php

/**
 * Suppliers Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Suppliers_model extends Model
{

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_suppliers');
		$sql->order_by('supplier_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data)
	{
		return $this->db->insert('master_suppliers', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('supplier_id', $id);
		return $this->db->update('master_suppliers', $data);
	}

	public function delete($id)
	{
		$this->db->where('supplier_id', $id);
		return $this->db->delete('master_suppliers');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('master_suppliers');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
