<?php
/**
 * Utang Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Utang_model extends Model
{
    public function get_data($where = '')
    {
        $sql = $this->db;

        $sql->select('*');
        $sql->from('master_utang a');
        $sql->join('master_suppliers b', 'b.supplier_id = a.id_supplier', 'inner');
        $sql->order_by('total_utang');

        if ($where != '') {
            $sql->where($where);
        }

        $get = $sql->get();

        return $get;
    }

    public function save($data)
    {
        return $this->db->insert('master_utang', $data);
    }

    public function update($id, $data)
    {
        $this->db->where('id_utang', $id);
        return $this->db->update('master_utang', $data);
    }

    public function delete($id)
    {
        $this->db->where('id_utang', $id);
        return $this->db->delete('master_utang');
    }

    public function check_id($where)
    {
        $this->db->select('*');
        $this->db->from('master_utang');
        $this->db->where($where);
        $query = $this->db->get();
        return $query->result();
    }
}

?>
