<?php
/**
 * Wholesale Prices Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Wholesale_prices_model extends Model {

	public function get_data($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_wholesale_prices a');
	    $sql->join('master_items b', 'b.item_id = a.item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_limit($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_wholesale_prices a');
	    $sql->join('master_items b', 'b.item_id = a.item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		$sql->limit(1);

		$get = $sql->get();

		return $get;
	}

	public function get_data_range($item_id='', $quantity_large='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_wholesale_prices a');
	    // $sql->join('master_items b', 'b.item_id = a.item_id', 'inner');

		$sql->where("item_id", $item_id);
		$sql->where("'$quantity_large' BETWEEN minimum_order and maximum_order");

		$get = $sql->get();

		return $get;
	}

	public function save($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('master_wholesale_prices', $data);
		}

		return $this->db->insert('master_wholesale_prices', $data);
	}

	public function delete($id)
	{
		$this->db->where("item_id", $id);
		return $this->db->delete("master_wholesale_prices");
	}
		public function delete_all()
	{
		
		return $this->db->truncate('master_wholesale_prices');
	}


}

?>
