/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT_STOCK = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elDate_1: '.date_1',
		group_select: '#group-select',
		type_select: '#type-select',
		color_select: '#color-select',
		size_select: '#size-select',

		urlRequestData: window.APP.siteUrl + 'adm/report_stock_minimum/get_data',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					elDate_1    : '',
					date_1      : '',
					item       : false,
					group       : false,
					type        : false,
					color       : false,
					size        : false,
					totalBarang : 0,
					totalIncome : 0,
					detailData  : []
				},
				methods: {
					getData: function (val) {
						var vue = this;

				// 		var val_date_1 = $(that.elDate_1).val();

						var val_group = $(that.group_select).val();
						var val_type  = $(that.type_select).val();
						var val_color = $(that.color_select).val();
						var val_size  = $(that.size_select).val();
						var stock  = $('.select-stock').val();

                        if(val == "item"){
							vue.group = false;
							vue.type  = false;
							vue.item  = true;
							vue.color = false;
							vue.size  = false;
						}
						if(val == "group"){
							vue.group = true;
							vue.type  = false;
							vue.item  = false;
							vue.color = false;
							vue.size  = false;
						}
						if(val == "type"){
							vue.group = false;
							vue.type  = true;
							vue.item  = false;
							vue.color = false;
							vue.size  = false;
						}
						if(val == "color"){
							vue.group = false;
							vue.type  = false;
							vue.item  = false;
							vue.color = true;
							vue.size  = false;
						}
						if(val == "size"){
							vue.group = false;
							vue.type  = false;
							vue.item  = false;
							vue.color = false;
							vue.size  = true;
						}

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'date_1': "",
								'group' : val_group,
								'type'  : val_type,
								'color' : val_color,
								'size'  : val_size,
								'val'   : val,
								'stock' : stock
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {

								vue.$set(vue, 'detailData', response['data']);
                                vue.$set(vue, 'totalBarang', response['totalBarang']);
								vue.$set(vue, 'date_1', response['date_1']);
								// vue.$set(vue, 'date_2', response['date_2']);
								// vue.$set(vue, 'totalIncome', response['total_income']);

								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_purchase_ppn/export_excel_income';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);