/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
 window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
		urlIndex: window.APP.siteUrl + 'adm/selling_orders/',
		urlAdd: window.APP.siteUrl + 'adm/selling_orders/edit/new',
        urlPrintOut: window.APP.siteUrl + 'adm/selling_orders/print_out/',
        urlPrintOut2: window.APP.siteUrl + 'adm/selling_orders/print_out2/',
        urlList: window.APP.siteUrl + 'adm/selling_orders/get_embed',
		urlSell: window.APP.siteUrl + 'adm/selling_orders/get_embed_sell',
		urlBarcode: window.APP.siteUrl + 'adm/selling_orders/get_data_barcode',
        urlRequestData: window.APP.siteUrl + 'adm/selling_orders/get_data_detail',
		urlDeleteData: window.APP.siteUrl + 'adm/selling_orders/delete_item',
		urlDeleteTransaction: window.APP.siteUrl + 'adm/selling_orders/delete2',

		// initial
		init: function () {
			var that = this;
			
			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					autonumber:'',
					ppn_id: '',
					prefix: '',
					number: '',
					pay:'',
					ppn_amount: 0,
					overprice: false,
					a:''
				},
				
				methods: {
					
				// 	changeSyaratBayar:function(){
				// 		var vue = this;
				// 		var arr = vue.detailData;
				// 		var syarat_bayar = $("#syarat_bayar").val();
				// 		console.log(syarat_bayar)
				// 		var i;
				// 		for (i = 0; i < arr.length; i++) {
				// 			console.log(arr[i]);
				// // 			if(syarat_bayar == "Kredit"){
				// // 				arr[i].lg_unit_prc = arr[i].lg_unit_prc_kredit;
				// // 				arr[i].md_unit_prc = arr[i].md_unit_prc_kredit;
				// // 				arr[i].sm_unit_prc = arr[i].sm_unit_prc_kredit;
				// // 				console.log(arr[i].lg_unit_prc_kredit);
				// // 				console.log(arr[i].lg_unit_prc);
				// // 				console.log(arr[i])
				// // 			}else if(syarat_bayar == "Eceran"){
				// // 				arr[i].lg_unit_prc = arr[i].large_harga_eceran;
				// // 				arr[i].md_unit_prc = arr[i].medium_harga_eceran;
				// // 				arr[i].sm_unit_prc = arr[i].small_harga_eceran;
				// // 			}else if(syarat_bayar == "Tunai"){
				// // 				arr[i].lg_unit_prc = arr[i].lg_unit_prc_cash;
				// // 				arr[i].md_unit_prc = arr[i].md_unit_prc_cash;
				// // 				arr[i].sm_unit_prc = arr[i].sm_unit_prc_cash;
				// // 			}
				
			 //                           if(syarat_bayar == "KREDIT"){
				// 							arr[i].lg_unit_prc = arr[i].large_harga_kredit;
				// 							arr[i].md_unit_prc = arr[i].medium_harga_kredit;
				// 							arr[i].sm_unit_prc = arr[i].small_harga_kredit;
				// 							arr[i].lg_unit_discount = arr[i].lg_unit_discount_kredit;
				// 							arr[i].md_unit_discount = arr[i].md_unit_discount_kredit;
				// 							arr[i].sm_unit_discount = arr[i].sm_unit_discount_kredit;
				// 						}
				// 						else if(syarat_bayar == "UMUM"){
				// 							arr[i].lg_unit_prc = arr[i].large_harga_eceran;
				// 							arr[i].md_unit_prc = arr[i].medium_harga_eceran;
				// 							arr[i].sm_unit_prc = arr[i].small_harga_eceran;
				// 						}else if(syarat_bayar == "SPESIAL"){
				// 						    arr[i].lg_unit_prc = arr[i].lg_unit_prc_spesial3;
											
				// 							arr[i].md_unit_prc = arr[i].lg_unit_prc_spesial3;
				// 							arr[i].sm_unit_prc = arr[i].lg_unit_prc_spesial3;
				// 						}else{
				// 							arr[i].lg_unit_prc = arr[i].large_harga_cash;
											
				// 							arr[i].md_unit_prc = arr[i].medium_harga_cash;
				// 							arr[i].sm_unit_prc = arr[i].small_harga_cash;
				// 						}
				            
				// 			console.log(arr)
							
				// 			// this.detailsSatuan.splice(i, 1);
				// 			vue.$set(arr[i],'lg_unit_prc',arr[i].lg_unit_prc);
				// 			vue.$set(arr[i],'md_unit_prc',arr[i].md_unit_prc);
				// 			vue.$set(arr[i],'sm_unit_prc',arr[i].sm_unit_prc);
				// 			console.log(arr[i].lg_unit_prc);
				// 			var total = (arr[i].lg_unit_prc != "" ? parseFloat(arr[i].lg_unit_prc.replace(/,/g, '')) * arr[i].lg_unit_qty : "" ) + (arr[i].md_unit_prc != "" ? parseFloat(arr[i].md_unit_prc.replace(/,/g, '')) * arr[i].md_unit_qty : "" ) + (arr[i].sm_unit_prc != "" ? parseFloat(arr[i].sm_unit_prc.replace(/,/g, '')) * arr[i].sm_unit_qty : "" );
				// 		    console.log(total)
				// 		    arr[i].total = total.toLocaleString('en-US');
						    
				// 		}
						
				// 		vue.$set(vue, 'detailData', arr);
						
				// 		//vue.$set(vue, 'detail_syarat_bayar', syarat_bayar);
				// 	},

					detailAdd: function () {
						// show modal
						$(that.elModal).modal("show");
						$("#savebutton").attr('disabled','disabled');
						$.ajax({
							url: that.urlList,
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});

						$('input[type="checkbox"]').prop('checked', false);
					},
					detailJual: function () {
						// show modal
						$(that.elModal).modal("show");
						var grand_total = $("#grand_total").val()
						$.ajax({
							url: that.urlSell,
							type:'post',
							data:{
								'grand_total': grand_total
							},
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});

						$('input[type="checkbox"]').prop('checked', false);
					},
					detailAddBarcode: function () {
						var vue = this;
						var arr = vue.detailData;
						var barcode = $("#barcode").val();
						if(barcode != ""){
						    $.ajax({
                            url: that.urlBarcode,
                            type: 'post',
                            data: {
                                'barcode': barcode
                            },
							dataType: "json",
							success: function (response) {
								var items = response.data;
								
									for (i = 0; i < items.length; i++) {
										var item = items[i];
	
										var lg_unit     = item.lg_unit;
										var md_unit     = item.md_unit;
										var sm_unit     = item.sm_unit;
										var lg_unit_cnt = item.lg_unit_cnt;
										var md_unit_cnt = item.md_unit_cnt;
										var sm_unit_cnt = item.sm_unit_cnt;
										
										var lg_unit_qty = 0;
										var md_unit_qty = 0;
										var sm_unit_qty = 0;
										
										var lg_unit_prc = item.lg_unit_prc;
									
										
										var discount = 0;
										var discount_total = 0;
										var result_large = 0;
										var result_medium = 0;
										var result_small = 0;
										var total = (lg_unit_prc != "" ? parseFloat(lg_unit_prc.replace(/,/g, '')) * item.lg_unit_qty : "");

										var overprice_lg = 0;
										var overprice_md = 0;
										var overprice_sm = 0;
	
	
										var btncolor = 'btn-default';
										var btnicon = '';
										
    										if (vue.checkValue_isExists(item.id, vue.detailData) == 'Exist') {
    								// 			alert('Duplicate Detected')
    											index = vue.detailData.map(function (item) {
    												return item.id
    											}).indexOf(item.id);
    											
    										   vue.detailData[index].lg_unit_qty = parseInt(vue.detailData[index].lg_unit_qty) + parseInt(item.lg_unit_qty);
    										   vue.handleWholesalePrice(vue.detailData[index], 'lg_unit_qty', vue.detailData[index].lg_unit_qty);
    											
    											vue.$set(vue.detailData[index],'lg_unit_prc',vue.detailData[index].lg_unit_prc);
                    							vue.$set(vue.detailData[index],'md_unit_prc',vue.detailData[index].md_unit_prc);
                    							vue.$set(vue.detailData[index],'sm_unit_prc',vue.detailData[index].sm_unit_prc);
                    							var total = (vue.detailData[index].lg_unit_prc != "" ? parseFloat(vue.detailData[index].lg_unit_prc.replace(/,/g, '')) * vue.detailData[index].lg_unit_qty : "");
                    						    console.log(total)
                    						    vue.detailData[index].total = total.toLocaleString('en-US');
    										}else{
												arr.push({
											    no: item.no,
												id            : item.id,
                								name          : item.name,
                								lg_unit       : item.lg_unit,
                								lg_unit_qty:1,
                								lg_unit_qty_old:0,
                								lg_unit_cnt   : item.lg_unit_cnt,
                								lg_unit_prc   : lg_unit_prc,
                								md_unit       : "",
                								md_unit_cnt   : 0,
                								md_unit_qty   : 0,
                								md_unit_prc   : 0,
                								md_unit_slg   : 0,
                								sm_unit       : "",
                								sm_unit_cnt   : 0,
                								sm_unit_qty   : 0,
                								sm_unit_prc   : 0,
                								sm_unit_slg   : 0,
                								discount      : item.discount,
                								discount_total: item.discount_total,
                								result_large  : result_large,
                								result_medium : 0,
								                result_small  : 0,
								                disc1  : 0,
                								disc2 : 0,
                								disc3  : 0,
                								total         : total.toLocaleString("en-US"),
                                                stock         : item.stock,
                								overprice_lg         : 0,
                								overprice_md         : 0,
                								overprice_sm         : 0,
                
                								remark        : ''
											});
						                }
										
										console.log(item.id)
										console.log(vue.checkValue_isExists(item.id, vue.a))
										


									}
									vue.checkData_isExists();
									console.log(arr)
								vue.$set(vue, 'detailData', arr);
								$("#barcode").val("").focus()
								
							}
						});

						}else{
						    alert("Please Enter a valid Barcode")
						}
						
						
					},
					changePrice: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						console.log(row.changeHarga);
						if (row.changeHarga == "Resep") {
                                vue.$set(row, 'lg_unit_prc', row.lg_unit_slg);
                                vue.$set(row, 'changeHarga', row.changeHarga);
    							vue.handleCount(row,'lg_unit_qty',row.lg_unit_qty);
						        
						}else if(row.changeHarga == "Harga2"){
						 
							vue.$set(row, 'lg_unit_prc', row.lg_unit_slg2);
						
							vue.$set(row, 'changeHarga', row.changeHarga);
							vue.handleCount(row,'lg_unit_qty',row.lg_unit_qty);
						}else if(row.changeHarga == "Harga3"){
						  
							vue.$set(row, 'lg_unit_prc', row.lg_unit_slg3);
							vue.$set(row, 'changeHarga', row.changeHarga);
							vue.handleCount(row,'lg_unit_qty',row.lg_unit_qty);
						}
						
				// 		vue.checkData_isExists();
				// 		$("#search").focus();
				// 		$("#search").val("");
					},
					
					barcodeName: function () {
						var vue = this;
						var arr = vue.detailData;
						var barcode = $("#barcode").val();
						$.ajax({
                            url: that.urlBarcode,
                            type: 'post',
                            data: {
                                'barcode': barcode
                            },
							dataType: "json",
							success: function (response) {
								// vue.$set(vue, 'listData', response.data);
								
								var items = response.data;
								
								for (i = 0; i < items.length; i++) {
									var item = items[i];
									if(item.tipe_barcode == "besar"){
										$("#nama_item").val(item.name);
										$("#satuan_item").val(item.lg_unit);
										
									}else if(item.tipe_barcode == "sedang"){
										$("#nama_item").val(item.name);
										$("#satuan_item").val(item.md_unit);
										
									}else if(item.tipe_barcode == "kecil"){
										$("#nama_item").val(item.name);
										$("#satuan_item").val(item.sm_unit);
									}
									
								}
								
							}
						});

						
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								// var ii = $('.check-sub');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete2: function (row, idx) {
						var vue = this;
							

							Swal.fire({
								title: 'Anda yakin?',
								text: "Ingin menghapus data ini?",
								type: 'warning',
								showCancelButton: true,
								confirmButtonColor: '#3085d6',
								cancelButtonColor: '#d33',
								confirmButtonText: 'Ya, Hapus!',
								cancelButtonText: 'Batal'
							}).then((result) => {
								if (result.value) {
									$.ajax({
										type: "POST",
										dataType: 'json',
										url: that.urlDeleteData,
										data: {
											id: $("#id").val(),
											item: vue.detailData[idx],
											total:row.total
										},
										success: function (response) {
											window.FORM.showNotification(response.message, response.status);
											// parentThis.elDatatable.ajax.reload();
											// console.log("deleted");
											vue.detailData.splice(idx, 1);
										}
									});
								}
							})	
							
						vue.countSubTotal();
					},
					detailDelete3: function (row, idx) {
						var vue = this;
							

							Swal.fire({
								title: 'Anda yakin?',
								text: "Ingin menghapus data ini? ",
								type: 'warning',
								showCancelButton: true,
								confirmButtonColor: '#3085d6',
								cancelButtonColor: '#d33',
								confirmButtonText: 'Ya, Hapus!',
								cancelButtonText: 'Batal'
							}).then((result) => {
								if (result.value) {
									$.ajax({
										type: "POST",
										dataType: 'json',
										url: that.urlDeleteTransaction,
										data: {
											id: $("#id").val(),
										},
										success: function (response) {
											window.FORM.showNotification(response.message, response.status);
											// parentThis.elDatatable.ajax.reload();
											// console.log("deleted");
											setTimeout(function () {
												window.location.href = that.urlAdd
											}, 1500);
											
										}
									});
								}
							})	
							
						vue.countSubTotal();
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								
								vue.$set(vue, 'detailData', response);
								console.log(response)
								$(that.elVue).unblock();
                    		}
                    	});
                    },

					handleNumber: function () {
						var vue = this;
						
						$("#supplier-select").change(function (e) {
							var id = $(e.target).val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/selling_orders/get_autonumber',
								dataType: "JSON",
								data: {
									id: id
								},
								success: function (data) {
									$("#autonumber").val(data['autonumber']);
									$("#customer_address").val(data['address']);
									$("#payment-due-text").val(data['payment_due']);
									vue.$set(vue, 'autonumber', data['autonumber']);
								},
							});			
						});
					},
					handleJenisHarga: function () {
						var vue = this;
						
						$("#supplier-select").change(function (e) {
							var id = $(e.target).val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/selling_orders/get_jenis_harga',
								dataType: "JSON",
								data: {
									id: id
								},
								success: function (data) {
									$("#syarat_bayar").val(data['jenis_harga']);
									$("#customer_address").val(data['address']);
									vue.changeSyaratBayar();
								// 	$("#payment-due-text").val(data['payment_due']);
								// 	vue.$set(vue, 'autonumber', data['autonumber']);
								},
							});			
						});
					},

					handlePrice: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
				// 		var syarat_bayar = $("#syarat_bayar").val();
						vue.$set(row, field_name, value);
						
						
							if(field_name == 'lg_unit_prc'){
								if(parseFloat(row.lg_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.lg_unit_prc_spesial3.replace(/[^\w\s]/gi, ''))){
									toastr.warning('Harga beli melebihi harga jual!')
									vue.$set(row, 'overprice_lg', 1);
								}else{
									vue.$set(row, 'overprice_lg', 0);
								}
							}
	
							if(field_name == 'md_unit_prc'){
								if(parseFloat(row.md_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.lg_unit_prc_spesial3.replace(/[^\w\s]/gi, ''))){
									toastr.warning('Harga beli melebihi harga jual!')
									vue.$set(row, 'overprice_md', 1);
								}else{
									vue.$set(row, 'overprice_md', 0);
								}
	
								var isi_besar   = row.lg_unit_cnt;
								var isi_sedang  = row.md_unit_cnt;
								var isi_kecil   = row.sm_unit_cnt;
								var harga_sedang = row.medium_harga_cash.replace(/[^\w\s]/gi, '');
	
								
								var harga_kecil  = harga_sedang/isi_sedang;
								var harga_besar = harga_kecil * isi_besar;
	
								vue.$set(row, 'sm_unit_prc', Math.round(harga_kecil).toLocaleString("en-US"));
								vue.$set(row, 'lg_unit_prc', Math.round(harga_besar).toLocaleString("en-US"));
							}
	
							if(field_name == 'sm_unit_prc'){
								if(parseFloat(row.sm_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.lg_unit_prc_spesial3.replace(/[^\w\s]/gi, ''))){
									toastr.warning('Harga beli melebihi harga jual!')
									vue.$set(row, 'overprice_sm', 1);
								}else{
									vue.$set(row, 'overprice_sm', 0);
								}
	
								var isi_besar   = row.lg_unit_cnt;
								var isi_sedang  = row.md_unit_cnt;
								var isi_kecil   = row.sm_unit_cnt;
								var harga_kecil = row.small_harga_cash.replace(/[^\w\s]/gi, '');
	
								
								var harga_sedang  = harga_kecil * isi_sedang;
								var harga_besar = harga_kecil * isi_besar;
	
								vue.$set(row, 'md_unit_prc', Math.round(harga_sedang).toLocaleString("en-US"));
								vue.$set(row, 'lg_unit_prc', Math.round(harga_besar).toLocaleString("en-US"));
							}
						
						var harga_beli = $("#bayar").val().replace(/,/g, "");
						var grand_total = $("#grand_total").val().replace(/,/g, "");

						
						if(parseInt(grand_total) <= parseInt(harga_beli)){
							$("#savebutton").removeAttr('disabled');
							console.log(harga_beli)
							console.log(grand_total)
							$("#kembalian").val(Math.abs(parseInt(grand_total) - parseInt(harga_beli)).toLocaleString("en-US"));
							
						}else{
							$("#kembalian").val("Tidak Cukup");
							$("#savebutton").attr('disabled','disabled');
						}
						vue.handleCount(row, field_name, value);
					},
					
					handleDisc: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
				// 		var syarat_bayar = $("#syarat_bayar").val();
						vue.$set(row, field_name, value);
						vue.handleCount(row, field_name, value);
					},
					
					
					
					handleCount: function (row, field_name, value,wholesale_done) {
						var vue = this;
						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						var discount = 0;
						var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
						    console.log(parseInt(row.lg_unit_qty))
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							console.log(result_large)
							vue.$set(row, 'result_large', result_large);
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
						    if(parseInt(row.md_limit_qty) > 0){
						         if (parseInt(row.md_unit_qty) >= parseInt(row.md_limit_qty)) {
                                var syarat_bayar =  $("#syarat_bayar").val();
							 //   console.log("lg_unit_qty lebih dr limit qty");
								 if(syarat_bayar == "UMUM"){
							      
							        vue.$set(row, 'md_unit_prc', row.md_unit_prc_cash);
							    }
								// vue.handleCount(row, field_name, value);
							}
						    }
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							if (field_name == 'md_unit_qty' && wholesale_done != 1) {
								vue.handleWholesalePriceMedium(row, field_name, value);
							}
                           
							if(row.sm_unit_cnt > 0){
								result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_small', result_small);
				 			}
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
						    if(parseInt(row.sm_limit_qty) > 0){
						       if (parseInt(row.sm_unit_qty) >= parseInt(row.sm_limit_qty)) {
							    var syarat_bayar =  $("#syarat_bayar").val();
							 //   console.log("lg_unit_qty lebih dr limit qty");
								 if(syarat_bayar == "UMUM"){
							       
							        vue.$set(row, 'sm_unit_prc', row.sm_unit_prc_cash);
							    }
								// vue.handleCount(row, field_name, value);
							} 
						    }
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
							if (field_name == 'sm_unit_qty' && wholesale_done != 1) {
								vue.handleWholesalePriceSmall(row, field_name, value);
							}
							
						}
						

						// result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						// result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						// result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						console.log(row.result_large)
						total = (Number(row.result_large));
						console.log(total)
				
						sub_total = total;
				
						console.log(sub_total)
				// 		console.log(Math.round(23680 / 100) * 100)
				        
				        console.log(row.result_large)
				// 		total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));
						console.log(total)
						if (field_name == 'discount') {
						    discount = total * row.discount / 100;
                        }else if(field_name == "discount_total"){
                            discount = row.discount_total.replace(/[^\w\s]/gi, '');
                            // 20000:100000*100 =
                            discount_percent = (row.discount_total.replace(/[^\w\s]/gi, '')) / total * 100;
                            console.log(discount_percent);
                        }else{
                            discount = total * row.discount / 100;
                        }
				    
				        sub_total = total - discount;
						vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
				// 		vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
					if (field_name == 'discount') {
        				    vue.$set(row, 'discount_total', Math.floor(discount).toLocaleString("en-US"));
                        }else if(field_name == "discount_total"){
                            vue.$set(row, 'discount', discount_percent.toLocaleString("en-US"));
                        }else{
                            vue.$set(row, 'discount_total', Math.floor(discount).toLocaleString("en-US"));
                        }
						
						var harga_beli = $("#bayar").val().replace(/,/g, "");
						var grand_total = $("#grand_total").val().replace(/,/g, "");

						
						if(parseInt(grand_total) <= parseInt(harga_beli)){
							console.log(harga_beli)
							console.log(grand_total)
							$("#kembalian").val(Math.abs(parseInt(grand_total) - parseInt(harga_beli)).toLocaleString("en-US"));
						}else{
							$("#kembalian").val("Tidak Cukup");
						}
						// vue.$set(row, 'total', total.toLocaleString("en-US"));
						vue.$set(row, field_name, value);
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}

						

						return (totalAmmount).toLocaleString("en-US");
					},
					handleWholesalePrice: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/selling_orders/get_wholesale_price',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								syarat_bayar: $("#syarat_bayar").val(),
								quantity_large: value
							},
							success: function (data) {
								vue.$set(row, 'lg_unit_prc', data);
									var syarat_bayar = $("#syarat_bayar").val();
								console.log(syarat_bayar);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},
					handleWholesalePriceMedium: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/selling_orders/get_wholesale_price_medium',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								syarat_bayar: $("#syarat_bayar").val(),
								quantity_medium: value
							},
							success: function (data) {
								vue.$set(row, 'md_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},
					handleWholesalePriceSmall: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/selling_orders/get_wholesale_price_small',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								syarat_bayar: $("#syarat_bayar").val(),
								quantity_small: value
							},
							success: function (data) {
								vue.$set(row, 'sm_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},

					// handleStock: function(row, field_name, value) {
					// 	var vue = this;

					// 	lg_calc = 0;
					// 	md_calc = 0;
					// 	sm_calc = 0;

					// 	calc = row.total_stock_stored;
					// 	calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

					// 	if(calc < 0){
					// 		toastr.warning('Stok tidak mencukupi!');
					// 		if(field_name == 'lg_unit_qty'){
					// 			vue.$set(row, 'lg_unit_qty', 0);
					// 			calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
					// 			vue.handleCount(row, field_name, value);
					// 		}
					// 		if(field_name == 'md_unit_qty'){
					// 			vue.$set(row, 'md_unit_qty', 0);
					// 			calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
					// 			vue.handleCount(row, field_name, value);
					// 		}
					// 		if(field_name == 'sm_unit_qty'){
					// 			vue.$set(row, 'sm_unit_qty', 0);
					// 			calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
					// 			vue.handleCount(row, field_name, value);
					// 		}
					// 	}
						
					// 	var left_stock_large = 0;
					// 	left_stock_large = (calc/row.lg_unit_cnt);

					// 	if(left_stock_large <= row.minimum_stock){
					// 		toastr.error('Barang telah mencapai stok minimum!')
					// 		vue.$set(row, 'bg_min_stock', 'bg-danger');
					// 	}else{
					// 		vue.$set(row, 'bg_min_stock', '');
					// 	}
						
					// 	vue.$set(row, 'total_stock', calc);
					// },
					handleCheckboxPPN: function () {
						var vue = this;
						// var a = $("#ppn_id").val();
						
						vue.countGrandTotal();
						var harga_beli = $("#bayar").val().replace(/,/g, "");
						var grand_total = $("#grand_total").val().replace(/,/g, "");

						
						if(parseInt(grand_total) <= parseInt(harga_beli)){
							$("#savebutton").removeAttr('disabled');
							console.log(harga_beli)
							console.log(grand_total)
							$("#kembalian").val(Math.abs(parseInt(grand_total) - parseInt(harga_beli)).toLocaleString("en-US"));
						}else{
							$("#kembalian").val("Tidak Cukup");
							$("#savebutton").attr('disabled','disabled');
						}

						
					},
					countQtyAndItem: function () {

				    	var vue = this;
						// var a = $("#ppn_id").val();
						var arr = vue.detailData; 
						    var totalQty = 0;
					    for (i = 0; i < arr.length; i++) {
				// 			console.log(arr[i]);
			
				            totalQty += parseInt(arr[i].lg_unit_qty) + parseInt(arr[i].md_unit_qty) + parseInt(arr[i].sm_unit_qty);
                            
						    
						}
						var totalItem = arr.length;
						$("#totalItem").html(totalItem);
						$("#totalQty").html(totalQty);
				// 		console.log(totalQty);
						setTimeout(function () {
                            vue.countQtyAndItem();
					    }, 500);
			
					},
					countDiscount: function () {
						var vue = this;
				// 		var items = vue.detailData;
				// 		var discount = parseInt($("#discount").val());
				// 		var totalAmmount = 0;
				// 		for (var i in items) {
				// 			totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
				// 		}
						
				// 		var discountTotal = totalAmmount * (discount/100);
					    
						
				// 		var discount = parseInt($("#discount").val());
						
				// 		var discountTotal = totalAmmount * (discount/100);
				// 		var ppnTotal = totalAmmount * (vue.ppn_amount/100)
				// 		var grandTotal = Math.ceil((totalAmmount  - discountTotal) / 100) * 100;
				// 		var pembulatan = (Math.ceil((totalAmmount  - discountTotal + ppnTotal) / 100) * 100) - (totalAmmount  - discountTotal + ppnTotal)
				// 		$("#discount_price").val(discountTotal.toLocaleString("en-US"));
				// 			$("#pembulatan").val(pembulatan.toLocaleString("en-US"));
				// 		$("#grand_total").val(grandTotal.toLocaleString("en-US"));
                        vue.countGrandTotal();
                        var harga_beli = $("#bayar").val().replace(/,/g, "");
						var grand_total = $("#grand_total").val().replace(/,/g, "");

						
						if(parseInt(grand_total) <= parseInt(harga_beli)){
							$("#savebutton").removeAttr('disabled');
							console.log(harga_beli)
							console.log(grand_total)
							$("#kembalian").val(Math.abs(parseInt(grand_total) - parseInt(harga_beli)).toLocaleString("en-US"));
						}else{
							$("#kembalian").val("Tidak Cukup");
							$("#savebutton").attr('disabled','disabled');
						}
						
					},
					
					countGrandTotal: function () {
						var vue = this;
                        console.log("grandTotal")
						// var ppn_amount = $('#ppn_amount').val();
						var totalAmmount = 0;
						var ppnTotal = 0;
						var grandTotal = 0;
						var items = vue.detailData;

						var id = $("#id").val();

						$.ajax({
                    		url: window.APP.siteUrl + 'adm/selling_orders/get_data_ppn',
							type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
                    		success: function (response) {
								vue.$set(vue, 'ppn_amount', response);
                    		}
                    	});

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}
						
						if(vue.ppn_id == true){
						    
							ppnTotal = totalAmmount * (vue.ppn_amount/100);
							var discount = parseInt($("#discount").val());
						    console.log(discount);
						    var discountTotal = totalAmmount * (discount/100);
						    console.log(discountTotal);
						    var pembulatan2 = parseInt($("#pembulatan").val().replace(/,/g, ''));
				// 			var discount = parseInt($("#discount").val());
				// 			var discountTotal = totalAmmount * (discount/100);
							grandTotal = (Math.ceil((totalAmmount - discountTotal ) / 100) * 100) + pembulatan2;
							pembulatan = (Math.ceil((totalAmmount - discountTotal ) / 100) * 100) - (totalAmmount - discountTotal)
							$("#discount_price").val(discountTotal.toLocaleString("en-US"));
						
							$("#pembulatan").val(pembulatan.toLocaleString("en-US"));
							$("#grand_total").val(grandTotal.toLocaleString("en-US"));
						}else{
							ppnTotal = 0;
				 				var discount = parseInt($("#discount").val());
						    console.log(discount);
						    var discountTotal = totalAmmount * (discount/100);
						    console.log(discountTotal);
						    var pembulatan2 = parseInt($("#pembulatan").val().replace(/,/g, ''));
				// 			var discount = parseInt($("#discount").val());
				// 			var discountTotal = totalAmmount * (discount/100);
							grandTotal = (((totalAmmount - discountTotal ) / 100) * 100) + pembulatan2;
				// 			pembulatan = (Math.ceil((totalAmmount - discountTotal ) / 100) * 100) - (totalAmmount - discountTotal)
							$("#discount_price").val(discountTotal.toLocaleString("en-US"));
						
				// 			$("#pembulatan").val(pembulatan.toLocaleString("en-US"));
							$("#grand_total").val(grandTotal.toLocaleString("en-US"));
						}
						if ($("#ppn_id").val() == "1") {
							$("#ppn_id").val("1");
						}else{
							$("#ppn_id").val("0");
						}
						$("#ppn").val(ppnTotal.toLocaleString("en-US"));
						$("#ppn_total").val(ppnTotal.toLocaleString("en-US"));
						$("#ppnvalue").val(ppnTotal.toLocaleString("en-US"));
						var harga_beli = $("#bayar").val().replace(/,/g, "");

						
						if(parseInt(grandTotal) <= parseInt(harga_beli)){
							console.log(harga_beli)
							console.log(grandTotal)
							$("#kembalian").val(Math.abs(parseInt(grandTotal) - parseInt(harga_beli)).toLocaleString("en-US"));
						}else{
							$("#kembalian").val("Tidak Cukup");
						}
						var jenis_bayar = $("#jenis_bayar").val()
						console.log(jenis_bayar)
						if(jenis_bayar != 1 && jenis_bayar != 2){
							$("#kembalian").val(0);
							
							$("#bayar").val(grandTotal.toLocaleString("en-US"));
							$("#bayar").focus().select();
						}else if(jenis_bayar == 2){
							$("#kembalian").val(0);
							
							$("#bayar").val(0);
							$("#bayar").focus().select();
						}else{
							$("#bayar").val("");
							$("#kembalian").val("Tidak Cukup");
						}
						console.log(grandTotal);
				// 		$("#grand_total").val(grandTotal.toLocaleString("en-US"));
						return grandTotal.toLocaleString("en-US");
						
					},

					countOverprice: function () {
						var vue = this;

						var grandTotal = 0;
						var totalAmmountLg = 0;
						var totalAmmountMd = 0;
						var totalAmmountSm = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmountLg += (Number(items[i].overprice_lg));
							totalAmmountMd += (Number(items[i].overprice_md));
							totalAmmountSm += (Number(items[i].overprice_sm));
						}
						
						grandTotal = (totalAmmountLg + totalAmmountMd + totalAmmountSm);

						if(Number(grandTotal) > 0){
							vue.$set(vue, 'overprice', true);
						}else{
							vue.$set(vue, 'overprice', false);
						}

						return Number(grandTotal);
					},
					

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 2);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},
					
					handleForm2: function () {
						var vue = this;
						
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
						
						
						$(that.elForm).ajaxForm({
							beforeSend: function () {
								
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
								
								$("#savebutton").attr('disabled','disabled');
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$("#savebutton").removeAttr('disabled');
									$(that.elVue).unblock();
									return false;
								}
							},
							data: {
								vuedata: JSON.stringify(vue.detailData),
								status:0
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();

								window.FORM.showNotification(response.message, response.status);
								
								if (response.status == "success") {
								    Swal.fire({
                						title: 'APAKAH ANDA MAU CETAK RESI?',
                						text: "Yes = Iya, No = Cetak Resep",
                						type: 'warning',
                						showCancelButton: true,
                						confirmButtonColor: '#3085d6',
                						cancelButtonColor: '#d33',
                						confirmButtonText: 'Yes',
                						cancelButtonText: 'No'
                					}).then((result) => {
                						if (result.value) {
            								setTimeout(function () {
        											window.location.href = that.urlPrintOut +response.id
        									}, 1500);
                						}else{
                						    setTimeout(function () {
        											window.location.href = that.urlPrintOut2 +response.id
        									}, 1500);
                						}
                					})
									console.log(vue.autonumber)
								
								}

								
			
							}
						});
			
					},
					handleForm3: function () {
						var vue = this;
						
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
						
						
						$(that.elForm).ajaxForm({
							beforeSend: function () {
								
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
								
								$("#savebutton").attr('disabled','disabled');
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$("#savebutton").removeAttr('disabled');
									$(that.elVue).unblock();
									return false;
								}
							},
							data: {
								vuedata: JSON.stringify(vue.detailData),
								status: 1
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();

								// window.FORM.showNotification(response.message, response.status);
								
								if (response.status == "success") {
									console.log(vue.autonumber)
										setTimeout(function () {
											window.location.href = that.urlAdd
										}, 1500);
								}

								
			
							}
						});
			
					},
					checkData_isExists: function () {
						var vue = this;
						var arr=vue.detailData
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						const a = [];
						const objectArray = Object.entries(vue.detailData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;
					},	
					checkValue_isExists: function (value, arr) {
						var vue = this;
	
						var status = 'Not exist';
	
						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i].id;
							console.log(contains)
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}
	
						return status;
					},
				},
				

				mounted: function () {
                    var vue = this;
					var id = $("#id").val();

				// 	$.ajax({
				// 		url: window.APP.siteUrl + 'adm/selling_orders/get_data_ppn',
				// 		success: function (response) {
				// 			vue.$set(vue, 'ppn_amount', response);
				// 		}
				// 	});
					
					
                    if(id != 'new'){
						vue.handleData();
						vue.handleJenisHarga();
						vue.checkData_isExists();
						this.$nextTick(() => this.countQtyAndItem());
						console.log(vue.a)
					}
					vue.handleJenisHarga();
					vue.handleCheckbox();
					vue.countQtyAndItem();
					
					
					setTimeout(function () {
						// $(that.elForm).validate();

						// $(that.elVue).block({
						// 	message: '<h4>Please Wait..</h4>'
						// });

						that.handleForm();
				// 		vue.countQtyAndItem();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
				// 		vue.countDiscount();
						var ppn_id = $("#ppn_id").val();
						if(ppn_id == "1"){
							$("#ppn_id").attr("checked", true);
							vue.$set(vue, 'ppn_id', true);
						}else{
							$("#ppn_id").attr("checked", false);
							vue.$set(vue, 'ppn_id', false);
						}
						

						// $(that.elVue).unblock();
					}, 1500);
				}
			});

		},
// 		watch: function(){
//           detailData:function lmao (val) {
//             // executes when value changes
//             this.$nextTick(() => this.countQtyAndItem());
//           }
//         },
	
		

		// form
		handleForm: function () {
			var that = this;
	
			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$("#savebutton").removeAttr('disabled');
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					// if (response.status == "success") {
					// 	setTimeout(function () {
					// 		window.location.href = window.APP.siteUrl + 'adm/purchase_orders/'
					// 	}, 1500);
					// }

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);