/**
 * Javascript Purchase Order
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/selling_orders/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Edit">' + data + '</a>';
	}

	var renderPrint = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/selling_orders/printout_invoice/' + full['id'];
        return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Print"><i class="fa fa-print btn btn-success btn-sm"></i></a>';
    }

	var renderExport = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/selling_orders/printout_invoice/' + full['id'];
        return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Print"><i class="fa fa-print btn btn-success btn-sm"></i></a>';
    }

	var renderReturn = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/purchase_returns/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Retur"><i class="fas fa-undo-alt btn btn-danger btn-sm"></i></a>';
    }

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elTable: '#master-table',
		elBtnDelete: '.master-delete',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		urlDeleteData: window.APP.siteUrl + 'adm/selling_orders/delete',
		urlRequestData: window.APP.siteUrl + 'adm/selling_orders/get_data_header',
        allowed:false,
		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				methods: {
					addRowType: function () {
						var vue = this;
					},

				},
				mounted: function () {
					parentThis.handleDataTable();
				}
			});

		},
		
		handlePassword : function(){
		    var vue = this;
		    
		    $( "#password" ).on( "keyup", function() {
              var password = $("#password").val();
              console.log(password)
		    if(password == "1sampai10"){
			      vue.allowed = true;
			      console.log(vue.allowed)
			     // $("#edit").removeClass('disabled');
			     // $("#delete").removeAttr('disabled');
		        $("#password").removeClass(' bg-danger').addClass(' bg-success');
		        $("#passicon").html('<i class="nav-icon fas fa-unlock mr-3 mt-2"></i>');
		        console.log("SUCCESS")
		    }else{
		      vue.allowed = false;
		      console.log(vue.allowed)
		        console.log("GAGAL")
		      //  $("#edit").addClass('disabled');
			     // $("#delete").attr('disabled','disabled');
		        $("#password").addClass(' bg-danger');
		        $("#passicon").html('<i class="nav-icon fas fa-lock mr-3 mt-2"></i>');
		    }
		    vue.elDatatable.destroy();
            vue.handleDataTable();
            } );
		    
		    
		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},

		// Purchase Order : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");
			if(parentThis.allowed == true){


			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [{
						data: 'no',
						width: '20',
						className: 'fit-width',
						
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'username',
					},
					{
						data: 'customer',
					},
				// 		{
				// 		data: 'jenis_bayar',
				// 	},
					{
						data: 'grand_total',
					},
					{
						render: renderExport
					},
					
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					parentThis.handlePassword();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
			}else{
			    parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [{
						data: 'no',
						width: '20',
						className: 'fit-width',
						
					},
					{
						data: 'number',
				// 		render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'username',
					},
					{
						data: 'customer',
					},
				// 		{
				// 		data: 'jenis_bayar',
				// 	},
					{
						data: 'grand_total',
					},
					{
						render: renderExport
					},
					
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					parentThis.handlePassword();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
			}
		},

		// Purchase Order : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

	}

})(jQuery);