/**
 * Javascript Embed
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

window.EMBED = (function ($) {
	return {

		initVue: null,
		elVue: '#embed-vue',
		elTable: "#embed-table",
		elClose: '.embed-close',

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		urlGetData: window.APP.siteUrl + 'adm/cash_out/get_data_embed',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					listData: [],
					a:'',
				},
				methods: {
					getDataEmbed: function (Event) {
                        var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
                        var value = $("#search").val();
						
						$.ajax({
                            url: that.urlGetData,
                            type: 'post',
                            data: {
                                'search': value
                            },
							dataType: "json",
							success: function (response) {
								// vue.$set(vue, 'listData', response.data);
								
								var items = response.data;
								var listData = {};

								for (i = 0; i < items.length; i++) {
									var item = items[i];

									var amount = item.amount;

									var btncolor = 'btn-default';
									var btnicon = '';

									if (vue.checkValue_isExists(item.id, vue.a) == 'Exist') {
										btncolor = 'btn-success';
										btnicon = 'fa fa-check';
										index = editVueInit.detailData.map(function (item) {
											return item.id
										}).indexOf(item.id);

										amount  = editVueInit.detailData[index].amount;
									}

									listData[i] = {
										'no'       : item.no,
										'id'       : item.id,
								// 		'type_name': item.type_name,
										'name'     : item.name,
										'number'   : item.number,
										'amount'    : amount,
										'description'   : '',
										'btncolor' : btncolor,
										'btnicon'  : btnicon,
									};

								}
								vue.listData = listData;
							}
						});
					},

					handleInput: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.$set(row, field_name, value);
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
						}
					},

					getSelectedData: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							editVueInit.detailData.splice(index, 1);
							vue.$set(vue.listData[idx], 'btncolor', 'btn-default');
							vue.$set(vue.listData[idx], 'btnicon', '');
						}else{
							editVueInit.detailData.push({
								'id'       : row.id,
								// 'type_name': row.type_name,
								'name'     : row.name,
								'number'   : row.number,
								'amount'    : row.amount,
								'description'   : '',
							});
							vue.$set(vue.listData[idx], 'btncolor', 'btn-success');
							vue.$set(vue.listData[idx], 'btnicon', 'fa fa-check');
						}
						
						vue.checkData_isExists();
					},

					closeModal: function () {
						$(that.elClose).click();
					},

					checkData_isExists: function () {
						var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						const a = [];
						const objectArray = Object.entries(editVueInit.detailData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;
					},	

					checkValue_isExists: function (value, arr) {
						var vue = this;

						var status = 'Not exist';

						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i];
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}

						return status;
					}
				},
				mounted: function () {
					var vue = this;

					vue.getDataEmbed();
					vue.checkData_isExists();

				}
			});

		},
	}
})(jQuery);