<?php

/**
 * Pengaturan Akun Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Account_settings extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Accounts_model');
	}

	public function index()
	{
		$data['content_title'] = 'Pengaturan Akun';
		$data['msg_unit']      = $this->session->userdata('msg_unit');
		$data['account_data']  = $this->Accounts_model->get_data()->result();

		$data['po'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'PO'))->result();
		$data['po_retur'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'POR'))->result();
		$data['po_retur_kredit'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'PORK'))->result();

		$data['so'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'SO'))->result();
		$data['so_kredit'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'SOK'))->result();
		$data['so_retur'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'SOR'))->result();
		$data['so_retur_kredit'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'SORK'))->result();

		$data['hutang'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'H'))->result();
		$data['piutang'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'P'))->result();

		$data['stok'] = $this->Accounts_model->get_data_settings(array('trx_type' => 'ST'))->result();


		// $msg = true;
		// $this->session->set_userdata('msg_unit', $msg);

		$this->twiggy_display('adm/account_settings/index', $data);
		$this->session->unset_userdata('msg_unit');
	}

	public function save()
	{
		$po        = $this->input->post('po');
		$po_status = $this->input->post('po_status');

		$po_retur        = $this->input->post('po_retur');
		$po_retur_status = $this->input->post('po_retur_status');

		$po_retur_kredit        = $this->input->post('po_retur_kredit');
		$po_retur_kredit_status = $this->input->post('po_retur_kredit_status');

		$so        = $this->input->post('so');
		$so_status = $this->input->post('so_status');

		$so_kredit        = $this->input->post('so_kredit');
		$so_kredit_status = $this->input->post('so_kredit_status');

		$so_retur        = $this->input->post('so_retur');
		$so_retur_status = $this->input->post('so_retur_status');

		$so_retur_kredit        = $this->input->post('so_retur_kredit');
		$so_retur_kredit_status = $this->input->post('so_retur_kredit_status');

		$hutang        = $this->input->post('hutang');
		$hutang_status = $this->input->post('hutang_status');

		$piutang        = $this->input->post('piutang');
		$piutang_status = $this->input->post('piutang_status');

		$stok        = $this->input->post('stok');
		$stok_status = $this->input->post('stok_status');


		foreach ($po as $key => $value) {
			$data_po[]  = array(
				'trx_type'   => 'PO',
				'account_id' => $value,
				'status'     => $po_status[$key],
			);
		}

		foreach ($po_retur as $key => $value) {
			$data_po_retur[]  = array(
				'trx_type'   => 'POR',
				'account_id' => $value,
				'status'     => $po_retur_status[$key],
			);
		}

		foreach ($po_retur_kredit as $key => $value) {
			$data_po_retur_kredit[]  = array(
				'trx_type'   => 'PORK',
				'account_id' => $value,
				'status'     => $po_retur_kredit_status[$key],
			);
		}

		foreach ($so as $key => $value) {
			$data_so[]  = array(
				'trx_type'   => 'SO',
				'account_id' => $value,
				'status'     => $so_status[$key],
			);
		}

		foreach ($so_kredit as $key => $value) {
			$data_so_kredit[]  = array(
				'trx_type'   => 'SOK',
				'account_id' => $value,
				'status'     => $so_kredit_status[$key],
			);
		}

		foreach ($so_retur as $key => $value) {
			$data_so_retur[]  = array(
				'trx_type'   => 'SOR',
				'account_id' => $value,
				'status'     => $so_retur_status[$key],
			);
		}

		foreach ($so_retur_kredit as $key => $value) {
			$data_so_retur_kredit[]  = array(
				'trx_type'   => 'SORK',
				'account_id' => $value,
				'status'     => $so_retur_kredit_status[$key],
			);
		}

		foreach ($hutang as $key => $value) {
			$data_hutang[]  = array(
				'trx_type'   => 'H',
				'account_id' => $value,
				'status'     => $hutang_status[$key],
			);
		}

		foreach ($piutang as $key => $value) {
			$data_piutang[]  = array(
				'trx_type'   => 'P',
				'account_id' => $value,
				'status'     => $piutang_status[$key],
			);
		}

		foreach ($stok as $key => $value) {
			$data_stok[]  = array(
				'trx_type'   => 'ST',
				'account_id' => $value,
				'status'     => $stok_status[$key],
			);
		}


		$this->db->truncate('account_settings');

		$this->db->insert_batch('account_settings', $data_po);
		$this->db->insert_batch('account_settings', $data_po_retur);
		$this->db->insert_batch('account_settings', $data_po_retur_kredit);
		$this->db->insert_batch('account_settings', $data_so);
		$this->db->insert_batch('account_settings', $data_so_kredit);
		$this->db->insert_batch('account_settings', $data_so_retur);
		$this->db->insert_batch('account_settings', $data_so_retur_kredit);
		$this->db->insert_batch('account_settings', $data_hutang);
		$this->db->insert_batch('account_settings', $data_piutang);
		$insert = $this->db->insert_batch('account_settings', $data_stok);

		$msg = '';
		if ($insert) {
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}

		redirect('adm/account_settings/');
	}
}
