<?php

/**
 * Cash_transfers Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Cash_transfers extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Cash_transfers_model');
		$this->load->model('Accounts_model');
	}

	public function index()
	{
		$data['content_title'] = 'Kas Transfer';

		$this->twiggy_display('adm/cash_transfers/index', $data);
	}

	public function get_data()
	{
		$data = [];
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		
		$startOfMonth = date('Y-m-01');
        $endOfMonth = date('Y-m-t');
		
		$where = [];
		$where['date >='] = $startOfMonth;
        $where['date <='] = $endOfMonth;
		if(isset($fromdate) && $fromdate != '')
		{
			$where['date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['date <='] = change_format_date($todate);
		}
		$get_data = $this->Cash_transfers_model->get_data($where)->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->id,
					'number'      => $get_row->number,
					'date'        => indonesian_date($get_row->date),
					'from_name'   => $get_row->from_name,
					'to_name'     => $get_row->to_name,
					'amount'      => number_format($get_row->amount),
					'description' => $get_row->description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();
		$prefix           = "CT";
		$datenow          = date('Ym');
		$number_generator = $this->Cash_transfers_model->cash_in_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;
		$number = $autonumber;

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('id' => $id);
			$get_data = $this->Cash_transfers_model->get_data($where)->row_array();
			$number = $get_data['number'];
		}

		$data['id']            = $id;
		$data['number']        = $number;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['account_data']  = $this->Accounts_model->get_data(array('kasbank' => 1))->result();

		$this->twiggy_display('adm/cash_transfers/edit', $data);
	}

	public function save()
	{
		// post
		$id           = $this->input->post('id');
		$number       = $this->input->post('number');
		$from_account = $this->input->post('from_account');
		$to_account   = $this->input->post('to_account');
		$amount       = $this->input->post('amount');
		$description  = $this->input->post('description');
		$action       = $this->input->post('action');

		

		$data_save = array(
			'number'          => $number,
			'date'            => date_now(),
			'from_account_id' => $from_account,
			'to_account_id'   => $to_account,
			'amount'          => trims($amount),
			'description'     => $description,
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Cash_transfers_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Cash_transfers_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_cash_transfer = $this->Cash_transfers_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$name  = $this->input->post('id');
		$where     = array('cash_transfer_name' => $name);

		$check = $this->Cash_transfers_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
