<?php

/**
 * Debts Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Debts extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Debts_model');
		$this->load->model('Pembelian_model');
		$this->load->model('Purchase_returns_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Banks_model');
		$this->load->model('Accounts_model');
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Pembayaran Hutang';

		$this->twiggy_display('adm/debts/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
		$order = "debt_header_id DESC";
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		
	    $startOfMonth = date('Y-m-01');
        $endOfMonth = date('Y-m-t');

		$where['from_retur'] = 0;
		$where['debt_header_date >='] = $startOfMonth;
        $where['debt_header_date <='] = $endOfMonth;
		if(isset($fromdate) && $fromdate != '')
		{
			$where['debt_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['debt_header_date <='] = change_format_date($todate);
		}
		$get_data = $this->Debts_model->debt_header($where, $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->debt_header_id,
					'number'       => $get_row->debt_header_number,
					'date'         => indonesian_date($get_row->debt_header_date),
					'supplier'     => $get_row->supplier_name,
					'sub_total'    => number_format($get_row->debt_header_sub_total),
					'return_total' => number_format($get_row->debt_header_return_total),
					'grand_total'  => number_format($get_row->debt_header_grand_total),
					'bayar_total'  => number_format($get_row->debt_header_bayar_total),
					'description'  => $get_row->debt_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_autonumber()
	{
		$id      = $this->input->post('id');
		$datenow = date('mY');
		$number_generator = '';
		$where   = array('supplier_id' => $id);
		$supplier_data  = $this->Suppliers_model->get_data($where)->row();

		if ($supplier_data) {
			$number_generator = $this->Debts_model->debt_autonumber($supplier_data->supplier_code);
		}

		$prefix     = "DB-" . $supplier_data->supplier_code;
		$autonumber = $prefix . $datenow . $number_generator;

		echo json_encode($autonumber);
	}

	public function edit($id = 'new')
	{
		$title = "Tambah Pembayaran Hutang";
		$header_data = array(null);

		$autonumber = '';

		$date_text   = date_now();

		if ($id != 'new') {
			$title       = "Edit Pembayaran Hutang";
			$where       = array('debt_header_id' => $id);
			$header_data = $this->Debts_model->debt_header($where)->row_array();
			$autonumber  = $header_data['debt_header_number'];
			$date_text   = $header_data['debt_header_date'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		$data['bank_data']     = $this->Banks_model->get_data()->result();
		$data['account_data']  = $this->Accounts_model->get_data(array('kasbank' => 1))->result();


		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;

		$this->twiggy_display('adm/debts/edit', $data);
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('debt_detail_header_id' => $id);
		$order       = array('pembelian_header_number' => 'asc');

		$data = [];
		$get_data = $this->Debts_model->debt_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->debt_detail_id,
					'detail_header_id' => $get_row->debt_detail_header_id,
					'id'               => $get_row->debt_detail_purchase_order_header_id,
					'number'           => $get_row->pembelian_header_number,
					'date'             => indonesian_date($get_row->pembelian_header_date),
					'sub_total'        => number_format($get_row->debt_detail_price),
					'discount'         => number_format($get_row->debt_detail_discount_percentage),
					'discount_total'   => number_format($get_row->debt_detail_discount_total),
					'return_total'     => number_format($get_row->debt_detail_return_total),
					'total'            => number_format($get_row->debt_detail_total),
					'bayar'            => number_format($get_row->debt_detail_bayar),
					'plus'            => number_format($get_row->debt_plus),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Pembelian';
		$this->twiggy_display('adm/debts/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$supplier = $this->input->post('supplier');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Pembelian_model->purchaseorder_headersearch($type, $supplier, $search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$where             = array('pembelian_header_id' => $get_row->pembelian_header_id);
			$where_telah_bayar = array('debt_detail_purchase_order_header_id' => $get_row->pembelian_header_id);
			$return_total = 0;
			$paid_total = 0;
			$disc_total = 0;
// 			$return_data  = $this->Debts_model->get_sum_retur($where)->row();
			$paid_data  = $this->Debts_model->get_sum_telah_bayar($where_telah_bayar)->row();
// 			if ($return_data) {
// 				$return_total = $return_data->total_retur;
// 			}
			if ($paid_data) {
				$paid_total = $paid_data->total_telah_bayar;
				$disc_total = $paid_data->total_disc;
			}
			$total = ($get_row->pembelian_header_grand_total - $return_total - $paid_total - $disc_total);
			$data[] = array(
				'no'           => $no,
				'id'           => $get_row->pembelian_header_id,
				'number'       => $get_row->pembelian_header_number,
				'date'         => indonesian_date($get_row->pembelian_header_date, 'd/m/Y'),
				'sub_total'    => number_format($get_row->pembelian_header_grand_total),
				'paid_total'   => number_format($paid_total + $disc_total),
				'return_total' => number_format($return_total + $paid_total + $disc_total),
				'total'        => number_format($total),
				'bayar'        => number_format($total),
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
		$payment_method = $this->input->post("payment_method");
		$bank           = $this->input->post("bank");
		$number_giro    = $this->input->post("number_giro");
		$payment_due    = $this->input->post("payment_due");
		$sub_total      = $this->input->post("sub_total");
		$return_total   = $this->input->post("return_total");
		$grand_total    = $this->input->post("grand_total");
		$bayar_total    = $this->input->post("bayar_total");
		$description    = $this->input->post("description");
		$account    = $this->input->post("account");

		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;

		$payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));
        $discount_total = 0;
        $pembulatan_total = 0;
		$header_data = [
			'debt_header_number'         => $number,
			'debt_header_date'           => change_format_date($date),
			'debt_header_supplier_id'    => $supplier,
			'debt_header_bank_id'        => $bank,
			'debt_header_account_id'     => $account,
			'debt_header_payment_method' => 0,
			'debt_header_number_giro'    => $number_giro,
			'debt_header_payment_due'    => $payment_due_data,
			'debt_header_sub_total'      => trims($sub_total),
			'debt_header_return_total'   => trims($return_total),
			'debt_header_grand_total'    => trims($grand_total),
			'debt_header_bayar_total'    => trims($bayar_total),
			'debt_header_description'    => $description
		];

		$detail_data = [];
		$update_lunas = [];

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Debts_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'debt_detail_header_id'                => $header_id,
						'debt_detail_purchase_order_header_id' => $row['id'],
						'debt_detail_price'                    => trims($row['sub_total']),
						'debt_detail_discount_percentage'      => trims($row['discount']),
						'debt_detail_discount_total'           => trims($row['discount_total']),
						'debt_detail_return_total'             => trims($row['return_total']),
						'debt_detail_total'                    => trims($row['total']),
						'debt_detail_bayar'                    => trims($row['bayar']),
						'debt_plus'                    => trims($row['plus']),
					];
                    $discount_total +=  (int)trims($row['discount']);
                    $pembulatan_total += (int)trims($row['plus']);
					// $data = array(
					// 	'status_paid'  => 1
					// );

					// $where = $row['id'];

					// $update_status_paid = $this->Pembelian_model->update_header($where, $data);

					if (trims($row['total']) == trims($row['bayar'])) {
						$update_lunas[] = [
							'pembelian_header_id' => $row['id'],
							'status_paid'              => 1,
						];
					}
				}

				if (!empty($update_lunas)) {
					$update_lunas_po = $this->Purchase_returns_model->update_lunas_po($update_lunas);
				}

				$save_detail = $this->Debts_model->save_detail($detail_data, true);
				$get_account_name = $this->Accounts_model->get_data(array('account_id' => $account))->row();
				$save_journal = $this->save_journal($header_id, $bayar_total, $number,$discount_total,$pembulatan_total,$account,$get_account_name->account_name);
				// $prefix_jr           = "JR";
				// $datenow_jr          = date('Ym');
				// $number_generator_jr = $this->Journals_model->journal_autonumber();
				// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

				// $header_data_jr = [
				// 	'journal_header_number'       => $autonumber_jr,
				// 	'journal_header_trx_id'       => $header_id,
				// 	'journal_header_trx_type'     => "DEBT",
				// 	'journal_header_date'         => change_format_date($date),
				// 	'journal_header_total_debit'  => trims($bayar_total),
				// 	'journal_header_total_credit' => trims($bayar_total),
				// 	'journal_header_description'  => $number,
				// ];

				// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
				// $header_id_jr = $this->db->insert_id();

				// $detail_data_jr = [
				// 	[
				// 		'journal_detail_header_id'      => $header_id_jr,
				// 		'journal_detail_account_id'     => '24',
				// 		'journal_detail_trx_id'         => $header_id,
				// 		'journal_detail_trx_type'       => "DEBT",
				// 		'journal_detail_account_number' => '210000019',
				// 		'journal_detail_account_name'   => 'Utang Usaha',
				// 		'journal_detail_debit'          => trims($bayar_total),
				// 		'journal_detail_credit'         => 0,
				// 		'journal_detail_description'    => ''
				// 	],
				// 	[
				// 		'journal_detail_header_id'      => $header_id_jr,
				// 		'journal_detail_account_id'     => '18',
				// 		'journal_detail_trx_id'         => $header_id,
				// 		'journal_detail_trx_type'       => "DEBT",
				// 		'journal_detail_account_number' => '11000011',
				// 		'journal_detail_account_name'   => 'Kas Besar',
				// 		'journal_detail_debit'          => 0,
				// 		'journal_detail_credit'         => trims($bayar_total),
				// 		'journal_detail_description'    => ''
				// 	]
				// ];

				// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

				if ($save_detail) {
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {

			$where_detail    = array('debt_detail_header_id' => $header_id);
			$get_data_detail = $this->Debts_model->debt_detail($where_detail)->result();
			foreach ($get_data_detail as $row_detail) {
				$data = array(
					'status_paid'  => 0
				);

				$where = $row_detail->debt_detail_purchase_order_header_id;

				$update_status_paid = $this->Pembelian_model->update_header($where, $data);
			}

			$delete_detail = $this->Debts_model->delete_detail($id);

			$jr_delheader = $this->Journals_model->delete_headerbytrxid($header_id, "DEBT");
			$jr_deldetail = $this->Journals_model->delete_detailbytrxid($header_id, "DEBT");

			if ($delete_detail) {
				$save_header = $this->Debts_model->update_header($id, $header_data);
				$delete_journal = $this->delete_journal($id);
				if ($save_header) {
					// $header_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'debt_detail_header_id'                => $header_id,
							'debt_detail_purchase_order_header_id' => $row['id'],
							'debt_detail_price'                    => trims($row['sub_total']),
							'debt_detail_discount_percentage'      => trims($row['discount']),
							'debt_detail_discount_total'           => trims($row['discount_total']),
							'debt_detail_return_total'             => trims($row['return_total']),
							'debt_detail_total'                    => trims($row['total']),
							'debt_detail_bayar'                    => trims($row['bayar']),
							'debt_plus'                    => trims($row['plus']),
						];
						
						$discount_total +=  (int)trims($row['discount']);
                        $pembulatan_total += (int)trims($row['plus']);
						// $data = array(
						// 	'status_paid'  => 1
						// );

						// $where = $row['id'];

						// $update_status_paid = $this->Pembelian_model->update_header($where, $data);
						if (trims($row['total']) == trims($row['bayar'])) {
							$update_lunas[] = [
								'pembelian_header_id' => $row['id'],
								'status_paid'              => 1,
							];
						}
					}

					if (!empty($update_lunas)) {
						$update_lunas_po = $this->Purchase_returns_model->update_lunas_po($update_lunas);
					}

					$save_detail = $this->Debts_model->save_detail($detail_data, true);
					$get_account_name = $this->Accounts_model->get_data(array('account_id' => $account))->row();
					$save_journal = $this->save_journal($header_id, $bayar_total, $number,$discount_total,$pembulatan_total,$account,$get_account_name->account_name);
					// $prefix_jr           = "JR";
					// $datenow_jr          = date('Ym');
					// $number_generator_jr = $this->Journals_model->journal_autonumber();
					// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

					// $header_data_jr = [
					// 	'journal_header_number'       => $autonumber_jr,
					// 	'journal_header_trx_id'       => $header_id,
					// 	'journal_header_trx_type'     => "DEBT",
					// 	'journal_header_date'         => change_format_date($date),
					// 	'journal_header_total_debit'  => trims($bayar_total),
					// 	'journal_header_total_credit' => trims($bayar_total),
					// 	'journal_header_description'  => $number,
					// ];

					// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
					// $header_id_jr = $this->db->insert_id();

					// $detail_data_jr = [
					// 	[
					// 		'journal_detail_header_id'      => $header_id_jr,
					// 		'journal_detail_account_id'     => '24',
					// 		'journal_detail_trx_id'         => $header_id,
					// 		'journal_detail_trx_type'       => "DEBT",
					// 		'journal_detail_account_number' => '210000019',
					// 		'journal_detail_account_name'   => 'Utang Usaha',
					// 		'journal_detail_debit'          => trims($bayar_total),
					// 		'journal_detail_credit'         => 0,
					// 		'journal_detail_description'    => ''
					// 	],
					// 	[
					// 		'journal_detail_header_id'      => $header_id_jr,
					// 		'journal_detail_account_id'     => '18',
					// 		'journal_detail_trx_id'         => $header_id,
					// 		'journal_detail_trx_type'       => "DEBT",
					// 		'journal_detail_account_number' => '11000011',
					// 		'journal_detail_account_name'   => 'Kas Besar',
					// 		'journal_detail_debit'          => 0,
					// 		'journal_detail_credit'         => trims($bayar_total),
					// 		'journal_detail_description'    => ''
					// 	]
					// ];

					// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function save_journal($header_id, $total, $number,$discount,$pembulatan,$account_id,$account_name)
	{
		$prefix           = "JR";
		$datenow          = date('Ym');
		$number_generator = $this->Journals_model->journal_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$header_data = [
			// 'journal_header_number'       => ($id == "new" ? $autonumber : $number),
			'journal_header_trx_id'       => $header_id,
			'journal_header_trx_type'     => "DEBT",
			'journal_header_number'       => ($autonumber),
			'journal_header_date'         => date_now(),
			'journal_header_total_debit'  => trims($total),
			'journal_header_total_credit' => trims($total),
			'journal_header_description'  => $number,
		];

		$detail_data = [];

		$account =  $this->Accounts_model->get_data_settings_advance(array('trx_type' => 'H'))->result();

		$save_header_jr = $this->Journals_model->save_header($header_data);
		$header_id_jr = $this->db->insert_id();

		foreach ($account as $get_row) {

			$status = $get_row->status;
			$detail_data[] = [
				'journal_detail_trx_id'         => $header_id,
				'journal_detail_trx_type'       => "DEBT",
				'journal_detail_header_id'      => $header_id_jr,
				'journal_detail_account_id'     => ($get_row->account_id != 39  ? $get_row->account_id : $account_id),
				'journal_detail_account_number' => $get_row->account_number,
				'journal_detail_account_name'   => ($get_row->account_name != "Kas / Bank"  ? $get_row->account_name : $account_name),
				'journal_detail_debit'          => ($get_row->account_name != "PENDAPATAN PEMBULATAN"  ? ($status == "D" ? trims($total)  : 0) : ($status == "D" ? $pembulatan : 0)),
				'journal_detail_credit'         => ($get_row->account_name != "POTONGAN HUTANG"  ?  ($get_row->account_name != "PENDAPATAN PEMBULATAN"  ? ($status == "K" ? trims($total) - $pembulatan  : 0) : ($status == "K" ? $pembulatan : 0)) : ($status == "K" ? $discount : 0)),
				'journal_detail_description'    => ""
			];
		}

		$save_detail = $this->Journals_model->save_detail($detail_data, true);
	}

	public function delete_journal($id)
	{
		$type = "DEBT";
		$delete_header = $this->Journals_model->delete_headerbytrxid($id, $type);

		if ($delete_header) {
			$delete_type = $this->Journals_model->delete_headerbytrxid($id, $type);
		}
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$where_detail    = array('debt_detail_header_id' => $row);
			$get_data_detail = $this->Debts_model->debt_detail($where_detail)->result();
			foreach ($get_data_detail as $row_detail) {
				$data = array(
					'status_paid'  => 0
				);

				$where = $row_detail->debt_detail_purchase_order_header_id;

				$update_status_paid = $this->Pembelian_model->update_header($where, $data);
			}

			$delete_header = $this->Debts_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Debts_model->delete_detail($row);

				$delete_journal = $this->delete_journal($row);
				// $jr_delheader = $this->Journals_model->delete_headerbytrxid($row, "DEBT");
				// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($row, "DEBT");
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('debt_header_id' => $id);
		$where_detail = array('debt_detail_header_id' => $id);

		$header = $this->Debts_model->debt_header($where_header)->row_array();
		$detail = $this->Debts_model->debt_detail($where_detail)->result();

		$data['content_title'] = 'Print Invoice Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/debts/print_out', $data);
	}
}
