<?php
/**
 * Graduation Requirements Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Grad_requirements extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Batches_model');
		$this->load->model('Trainees_model');
		$this->load->model('Programs_model');
		$this->load->model('Requirements_model');
		$this->load->model('Grad_requirements_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Syarat Kelulusan';
		 
		if(check_roles('1') or check_roles('2')){
			$this->twiggy_display('adm/grad_requirements/index', $data);
		}else{
			redirect("Error");
		}
	}
	
	public function get_data_header()
	{	
		$data = [];
		$get_data = $this->Grad_requirements_model->batch_header()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{
				// $status = '<span class="badge badge-primary" style="width:100%">Ongoing</span>';
				// if($get_row->batch_header_start > date_now()){
				// 	$status = '<span class="badge badge-warning" style="width:100%">Upcoming</span>';
				// }
				// if($get_row->batch_header_end < date_now()){
				// 	$status = '<span class="badge badge-success" style="width:100%">Complete</span>';
				// }

				$status = 'Ongoing';
				if($get_row->batch_header_start > date_now()){
					$status = 'Upcoming';
				}
				if($get_row->batch_header_end < date_now()){
					$status = 'Complete';
				}

				$accr = '';
				if($get_row->program_header_accreditation_id != 0){
					$accr = '<span class="badge badge-info">'.$get_row->program_accreditation_name.'</span>';
				}
				
				$data[] = array(
					'no'      => $no,
					'id'      => $get_row->batch_header_id,
					'name'    => $get_row->batch_header_name,
					'program' => $get_row->program_header_name.' '.$accr,
					'class'   => $get_row->program_class_name,
					'type'    => $get_row->program_type_name,
					'date'    => indonesian_date($get_row->batch_header_start). ' - ' .indonesian_date($get_row->batch_header_end),
					'status'  => $status,
					'total_trainee' => $get_row->total_trainee." Peserta",
					'graduated'     => $get_row->graduated." Peserta",
					'ungraduated'   => $get_row->ungraduated." Peserta",
					'batch_info'   => $get_row->batch_header_info,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

 	public function edit($id)
	{	
		$title = "Syarat Kelulusan";
		$header_data = $this->Batches_model->batch_header($id)->row_array();
		
		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['program_data']  = $this->Programs_model->program_header()->result();

		if(check_roles('1') or check_roles('2')){
			$this->twiggy_display('adm/grad_requirements/edit', $data);
		}else{
			redirect("Error");
		}
	    
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");

		$data = [];
		$get_data = $this->Grad_requirements_model->batch_detail($id)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'        => $no,
					'batchid'   => $get_row->batch_detail_header_id,
					'traineeid' => $get_row->trainee_id,
					'code'      => $get_row->trainee_code,
					'name'      => $get_row->trainee_name,
					'job_title' => $get_row->trainee_job_title_id,
					'company'   => $get_row->company_name,
					'grad_id'   => $get_row->id,
					'info'      => $get_row->info,
					// 'certi_number' => 'CERT-29102'
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_graduated()
	{	
		$id = $this->input->post("id");

		$data = [];
		$response = [];
		$get_data = $this->Grad_requirements_model->get_graduated($id)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'        => $no,
					'batchid'   => $get_row->batch_id,
					'programid' => $get_row->program_id,
					'traineeid' => $get_row->trainee_id,
					'certi_number' => $get_row->certificate_number,
					'status'    => $get_row->status,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
	}

	public function get_data_requirement()
	{	
		$batchid = $this->input->post("batchid");
		$traineeid = $this->input->post("traineeid");

		$data = [];
		$get_data = $this->Grad_requirements_model->get_requirement_bybatchtrainee($batchid, $traineeid)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{
				$status = ($get_row->status == 1 ? 'bg-success' : '');
				$data[] = array(
					'no'      => $no,
					'batch_detail_id' => $get_row->batch_detail_id,
					'id'      => $get_row->requirement_id,
					'code'    => $get_row->requirement_code,
					'name'    => $get_row->requirement_name,
					'desc'    => $get_row->requirement_description,
					'status'  => $get_row->status,
					'bgcolor' => $status
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function save()
	{	
		$id      = $this->input->post('id');
		$name    = $this->input->post("name");
		$program = $this->input->post("program");
		$start   = $this->input->post("start");
		$end     = $this->input->post("end");
		
		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;
		
		$header_data = [
			'batch_header_program_id' => $program,
			'batch_header_name'       => $name,
			'batch_header_start'      => $start,
			'batch_header_end'        => $end
		];

		$detail_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Batches_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'batch_detail_header_id'  => $header_id,
						'batch_detail_program_id' => $program,
						'batch_detail_trainee_id' => $row['id']
					];
				}
				
				$save_detail = $this->Batches_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{

			$delete_header = $this->Batches_model->delete_header($id);

			if ($delete_header) {
				
				$delete_detail = $this->Batches_model->delete_detail($id);
				if ($delete_detail) {

				$save_header = $this->Batches_model->save_header($header_data);
				if($save_header)
				{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'batch_detail_header_id'  => $header_id,
						'batch_detail_program_id' => $program,
						'batch_detail_trainee_id' => $row['id']
					];
				}

				$save_detail = $this->Bacthes_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}

		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}
	
	public function save_info()
	{
		$id    = $this->input->post('id');
		$value = $this->input->post('value');
		
		$where = array(
			'id'   => $id
		);

		$data_update = array(
			'info' => $value,
		);

		$update = $this->Grad_requirements_model->update_info_graduates($where, $data_update);
		if($update)
		{
			$msg    = "Berhasil menyimpan data";
			$status = "success";
		}
		else
		{
			$msg    = "Gagal menyimpan data";
			$status = "error";	
		}

		$response = [
			'message' => $msg,
			'status'  => $status
		];
		output_json($response);
	}

	public function update_status()
	{	
		// $check_graduated   = $this->Grad_requirements_model->check_status()->result();
		// echo count($check_graduated);
		// die();
		$id   = $this->input->post('id');
		$data = $this->input->post('data');

		$bid = $this->input->post('batch_header_id');
		$pid = $this->input->post('program_id');
		$tid = $this->input->post('trainee_id');

		// echo "ID:" .$id. "<br/>";
		// echo "DATA:" .$data. "<br/>";
		// echo "BID:" .$bid. "<br/>";
		// echo "PID:" .$pid. "<br/>";
		// echo "TID:" .$tid. "<br/>";
		// die();
		$check_status_graduate  = 0;
		$update_status_graduate = true;

		$post = array(
			'status' => $data
		);
		
		$update_status_requirement = $this->Grad_requirements_model->update_status_requirements($id, $post);
		$count_meetingschedule = count($this->Grad_requirements_model->check_meeting_total($bid)->result());

		if($update_status_requirement){
			$program_data = $this->Programs_model->program_header($pid)->row();
			$program_name = $program_data->program_header_name;
			$accreditation = ($program_data->program_accreditation_id == null ? "" : "/".$program_data->program_accreditation_name);
			$program_string = '';

			foreach (preg_split('#[^a-z]+#i', $program_name, -1, PREG_SPLIT_NO_EMPTY) as $word) {
				$program_string .= $word[0];
			}
			
			$certificatenumber           = $this->Grad_requirements_model->certificatenumber_generator($program_string);
			if($program_data->program_header_certificate_release == 'Sertifikat'){
				$certificatenumber_generator = $certificatenumber."/".$program_string.$accreditation."/LIC";
			}else{
				$certificatenumber_generator = "-";
			}
			$check_deadline              = $this->Batches_model->batch_header($bid)->row();
			$check_status_graduate       = count($this->Grad_requirements_model->check_status($bid, $pid, $tid, 0)->result());
			$late_data = 0;

			if($check_status_graduate == 0){
				if($check_deadline->batch_header_end < date_now()){
					$late_data = 1;
				}
			}
			
			$status_data = ($check_status_graduate == 0 ? 1 : 0);
			$certifitenumber_data = ($check_status_graduate == 0 ? $certificatenumber_generator : "");
			$timestamp   = date("Y-m-d H:i:s");

			$where = array(
				'batch_id'   => $bid,
				'program_id' => $pid,
				'trainee_id' => $tid,
			);

			$data_update = array(
				'certificate_number' => $certifitenumber_data,
				'status'     => $status_data,
				'late'       => $late_data,
				'timestamp'  => $timestamp
			);

			if($check_status_graduate == 0){
				$update_status_graduate = $this->Grad_requirements_model->update_status_graduates($where, $data_update);
			}else{
				$update_status_graduate = $this->Grad_requirements_model->update_status_graduates($where, $data_update);
			}
		}

		if($update_status_graduate)
		{
			$response = [
				'message' => 'Berhasil menyimpan data',
				'status'  => 'success',
				'graduate'=> $check_status_graduate,
				'certi_number' => $certificatenumber_generator
			];
		}
		else
		{
			$response = [
				'message' => 'Gagal menyimpan data',
				'status'  => 'error',
				'graduate'=> $check_status_graduate,
				'certi_number' => $certificatenumber_generator
			];
		}	
		
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		
		foreach($id as $row)
		{	
			$delete_header = $this->Batches_model->delete_header($row);
			
			if($delete_header){
				$delete_type = $this->Batches_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}

?>
