<?php
/**
 * Report Credits Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Posting extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model

		$this->load->model('Sales_orders_model');
		$this->load->model('Sales_returns_model');
		$this->load->model('Customers_model');
		$this->load->model('Logs_model');
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Posting';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        // $data['wilayah_data'] = $this->Wilayah_model->get_data()->result();
		
		$this->twiggy_display('adm/posting/index', $data);
	}

	public function get_data_detail()
	{	
// 		$customer = $this->input->post("customer");
// 		$wilayah = $this->input->post("wilayah");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("sales_order_header_number ASC");

//         if(isset($customer) && $customer != '' && $customer != '(Semua)')
// 		{
// 			$where['selling_order_header_customer_id'] = $customer;
// 		}
// 		 if(isset($wilayah) && $wilayah != '' && $wilayah != '(Semua)')
// 		{
// 			$where['wilayah_id'] = $wilayah;
// 		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_order_header_date <='] = change_format_date($todate);
		}
		
		$get_data = $this->Sales_orders_model->salesorder_header($where, $order)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{		
			    
			    $hpp = 0;
			    $total_status_1 = 0;
			    $total_status_2 = 0;
			    $total_status_3 = 0;
			    $where_detail = array('sales_order_detail_header_id' => $get_row->sales_order_header_id);
			    $get_data_detail = $this->Sales_orders_model->salesorder_detail($where_detail)->result();
			    foreach($get_data_detail as $detail){
			        	$dtstamp                    = change_format_date($get_row->sales_order_header_date). " " .date("H:i:s");
						$where                      = array('log_item_id' => $detail->sales_order_detail_item_id, 'a.timestamp <' => $dtstamp);
						$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
						$last_total_stock           = 0;
						$last_log_total_stock_value = 0;
						$last_log_avg_large         = 0;
						$last_log_avg_medium        = 0;
						$last_log_avg_small         = 0;

						if(!empty($log_data_check)){
							$last_total_stock           = $log_data_check['log_total_stock'];
							$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
							$last_log_avg_large         = $log_data_check['log_average_large_unit'];
							$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
							$last_log_avg_small         = $log_data_check['log_average_small_unit'];
						}
						$hpp += $last_log_avg_large * trims($detail->sales_order_detail_large_unit_quantity);
						if($detail->sales_order_detail_ppn_status == 1){
						    $total_status_1 += trims($detail->sales_order_detail_total);
						}
						
						if($detail->sales_order_detail_ppn_status == 2){
						    $total_status_2 += trims($detail->sales_order_detail_total);
						}
						if($detail->sales_order_detail_ppn_status == 3){
						    $total_status_3 += trims($detail->sales_order_detail_total);
						}
			    }
			    
				$save_journal = $this->save_journal($get_row->sales_order_header_id, $get_row->sales_order_header_grand_total, $get_row->sales_order_header_payment_method, $get_row->sales_order_header_number,$hpp,trims($get_row->sales_order_header_ppn_total),$total_status_1,$total_status_2,$total_status_3,$get_row->sales_order_header_date);
                
			}
		}
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);
        $response = [
			'message' => 'success',
			'status'  => 'success',
// 			'id'      => $header_id
		];
		output_json($response);
	}
	
	public function save_journal($header_id, $total, $payment_type, $number,$hpp,$ppn,$total_status_1,$total_status_2,$total_status_3,$date)
	{
		$prefix           = "JR";
		$datenow          = date('Ym');
		$number_generator = $this->Journals_model->journal_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$header_data = [
			// 'journal_header_number'       => ($id == "new" ? $autonumber : $number),
			'journal_header_trx_id'       => $header_id,
			'journal_header_trx_type'     => "SELL",
			'journal_header_number'       => ($autonumber),
			'journal_header_date'         => $date,
			'journal_header_total_debit'  => trims($total),
			'journal_header_total_credit' => trims($total),
			'journal_header_description'  => $number." TES POSTING",
		];

		$detail_data = [];
		$where = $payment_type == "Tunai" ? array('trx_type' => 'SO') : array('trx_type' => 'SOK');

		$account =  $this->Accounts_model->get_data_settings_advance($where)->result();

		$save_header_jr = $this->Journals_model->save_header($header_data);
		$header_id_jr = $this->db->insert_id();

		foreach ($account as $get_row) {

			$status = $get_row->status;
			
 			if($get_row->account_id == 36){
     			    if($total_status_1 != 0){
     			        $detail_data[] = [
            				'journal_detail_trx_id'         => $header_id,
            				'journal_detail_trx_type'       => "SELL",
            				'journal_detail_header_id'      => $header_id_jr,
            				'journal_detail_account_id'     => $get_row->account_id,
            				'journal_detail_account_number' => $get_row->account_number,
            				'journal_detail_account_name'   => $get_row->account_name,
            				'journal_detail_account_group'      => $get_row->account_group_name,
            				'journal_detail_debit'          => ($get_row->account_name != "HPP"  ? ($status == "D" ? $total_status_1 : 0) : ($status == "D" ? $hpp : 0)),
            				'journal_detail_credit'         => ($get_row->account_name != "Persediaan"   ? ($get_row->account_name != "PPN KELUARAN"  ? ($status == "K" ? $total_status_1 : 0) : ($status == "K" ? $ppn : 0)) : ($status == "K" ? $hpp : 0)),
            				'journal_detail_description'    => "NON-PPN"
            			];
     			    }
         			
        			if($total_status_2 != 0){
        			    $detail_data[] = [
            				'journal_detail_trx_id'         => $header_id,
            				'journal_detail_trx_type'       => "SELL",
            				'journal_detail_header_id'      => $header_id_jr,
            				'journal_detail_account_id'     => $get_row->account_id,
            				'journal_detail_account_number' => $get_row->account_number,
            				'journal_detail_account_name'   =>  $get_row->account_name,
            				'journal_detail_account_group'      => $get_row->account_group_name,
            				'journal_detail_debit'          => ($get_row->account_name != "HPP"  ? ($status == "D" ? $total_status_2 - $ppn : 0) : ($status == "D" ? $hpp : 0)),
            				'journal_detail_credit'         => ($get_row->account_name != "Persediaan"   ? ($get_row->account_name != "PPN KELUARAN"  ? ($status == "K" ? $total_status_2 - $ppn : 0) : ($status == "K" ? $ppn : 0)) : ($status == "K" ? $hpp : 0)),
            				'journal_detail_description'    => "PPN"
        			    ];
        			}
        			if($total_status_3 != 0){
        			    $detail_data[] = [
            				'journal_detail_trx_id'         => $header_id,
            				'journal_detail_trx_type'       => "SELL",
            				'journal_detail_header_id'      => $header_id_jr,
            				'journal_detail_account_id'     => $get_row->account_id,
            				'journal_detail_account_number' => $get_row->account_number,
            				'journal_detail_account_name'   =>  $get_row->account_name,
            				'journal_detail_account_group'      => $get_row->account_group_name,
            				'journal_detail_debit'          => ($get_row->account_name != "HPP"  ? ($status == "D" ? $total_status_3  : 0) : ($status == "D" ? $hpp : 0)),
            				'journal_detail_credit'         => ($get_row->account_name != "Persediaan"   ? ($get_row->account_name != "PPN KELUARAN"  ? ($status == "K" ? $total_status_3  : 0) : ($status == "K" ? $ppn : 0)) : ($status == "K" ? $hpp : 0)),
            				'journal_detail_description'    => "ROKOK"
        			    ];
        			}
			    	
 			}else{
 			    $detail_data[] = [
				'journal_detail_trx_id'         => $header_id,
				'journal_detail_trx_type'       => "SELL",
				'journal_detail_header_id'      => $header_id_jr,
				'journal_detail_account_id'     => $get_row->account_id,
				'journal_detail_account_number' => $get_row->account_number,
				'journal_detail_account_name'   => $get_row->account_name,
				'journal_detail_account_group'      => $get_row->account_group_name,
				'journal_detail_debit'          => ($get_row->account_name != "HPP"  ? ($status == "D" ? trims($total) : 0) : ($status == "D" ? $hpp : 0)),
				'journal_detail_credit'         => ($get_row->account_name != "Persediaan"   ? ($get_row->account_name != "PPN KELUARAN"  ? ($status == "K" ? trims($total) : 0) : ($status == "K" ? $ppn : 0)) : ($status == "K" ? $hpp : 0)),
				'journal_detail_description'    => ""
			];
 			}
		

		}
	
		

		$save_detail = $this->Journals_model->save_detail($detail_data, true);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order    = ("selling_order_header_number ASC");
		$customer_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['selling_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['selling_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['selling_order_header_date <='] = change_format_date($todate);
		}

		$where['status_paid'] = 0;
		
		$get_data = $this->selling_orders_model->salesorder_header($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PIUTANG")
							   ->setSubject("PIUTANG")
							   ->setDescription("PIUTANG")
							   ->setKeywords("PIUTANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Piutang");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$fromdate_text." - ".$todate_text);

	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Nomor Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "Jatuh Tempo");
	    $excel->setActiveSheetIndex(0)->setCellValue('D6', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Total");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E6')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$where        = array('selling_order_header_id' => $get_row->selling_order_header_id);
			$return_total = 0;
			$return_data  = $this->Sales_returns_model->salesreturn_header($where)->row();
			if($return_data){
				$return_total = $return_data->sales_return_header_grand_total;
			}

			$sub_total = ($get_row->selling_order_header_grand_total - $get_row->selling_order_header_paid_total);
			$total     = ($sub_total - $return_total);

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->selling_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->selling_order_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, change_format_date($get_row->selling_order_header_payment_due, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($total));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('E'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PIUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PIUTANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
