<?php

/**
 * Purchase Return Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Purchase_returns extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Purchase_returns_model');
		$this->load->model('Pembelian_model');
		// $this->load->model('Customers_model');
		// $this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Warehouses_model');
		$this->load->model('Transfer_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Debts_model');
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
$this->load->model('Ppn_model');
		// $this->load->model('Wholesale_prices_model');
		// $this->load->model('Special_prices_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Retur Pembelian';
		$this->twiggy_display('adm/purchase_returns/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
		$order = "purchase_return_header_date DESC, purchase_return_header_number";
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		
		$startOfMonth = date('Y-m-01');
        $endOfMonth = date('Y-m-t');
		
		$where = [];
		$where['purchase_return_header_date >='] = $startOfMonth;
        $where['purchase_return_header_date <='] = $endOfMonth;
		if(isset($fromdate) && $fromdate != '')
		{
			$where['purchase_return_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['purchase_return_header_date <='] = change_format_date($todate);
		}
		$get_data = $this->Purchase_returns_model->purchasereturn_header($where, $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$status = ($get_row->purchase_return_header_status == 'Lunas' ? '<i class="fas fa-circle text-success"></i>&nbsp;&nbsp;&nbsp;Lunas' : '<i class="fas fa-circle text-warning"></i>&nbsp;&nbsp;&nbsp;Belum Lunas');
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->purchase_return_header_id,
					'po_id'       => $get_row->pembelian_header_id,
					'number'      => $get_row->purchase_return_header_number,
					'date'        => indonesian_date($get_row->purchase_return_header_date),
					'supplier'    => $get_row->supplier_name,
					'total'       => number_format($get_row->purchase_return_header_grand_total),
					'potong'       => number_format($get_row->purchase_return_header_total_hutang),
					'tunai'       => number_format($get_row->purchase_return_header_total_tunai),
					'description' => $get_row->purchase_return_header_description,
					'status' => $status,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	
	

	public function edit($id = 'new')
	{
		$title = "Tambah Retur Pembelian";
		$return_data = array(null);

		$where       = array('purchase_return_header_id' => $id);
		$return_data = $this->Purchase_returns_model->purchasereturn_header($where)->row_array();
		$purchs_data = $this->Pembelian_model->purchaseorder_header()->result();
		$supplier_data = $this->Suppliers_model->get_data()->result();

// 		$datenow = date('ym');
// 		$number_generator = '';
// 		$prefix     = 'RB';
// 		$number_generator = $this->Purchase_returns_model->purchasereturn_autonumber();
// 		$autonumber = $prefix  . $datenow . '-' . $number_generator;
$ppn_total = 0;
		$rt_date   = date_now();
		$rt_description = '';
		$rt_number = '';

		$tmstamp   = date("H:i:s");
		$tunai = 0;
		$default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row()->warehouse_name;
			$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		if ($id != 'new') {
			$title     = "Edit Retur Pembelian";
			$rt_number = $return_data['purchase_return_header_number'];
			$rt_date   = $return_data['purchase_return_header_date'];
			$ppn_amount   = $return_data['purchase_return_header_ppn_percentage'];
// 	$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
// 		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		$ppn_total  = $return_data['purchase_return_header_ppn_total'];
			$rt_description = $return_data['purchase_return_header_description'];
			if ($return_data['purchase_return_header_total_tunai'] != 0)
				$tunai = number_format($return_data['purchase_return_header_total_tunai']);
		}

		$data['default_warehouse'] = $default_warehouse;

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['ppn_total'] = $ppn_total;

		$data['rt_number']      = $rt_number;
		$data['rt_date']        = $rt_date;
		$data['rt_description'] = $rt_description;
		$data['ppn_amount']      = $ppn_amount;
		$data['tmstamp']        = $tmstamp;
		$data['purchs_data']    = $purchs_data;
		$data['header_data']    = $return_data;
		$data['supplier_data']  = $supplier_data;
		$data['tunai'] = $tunai;

		$this->twiggy_display('adm/purchase_returns/edit', $data);
	}

	public function get_data_debt()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$supplier = $this->input->post('supplier');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Debts_model->purchaseorder_headersearch($type, $supplier, $search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$where             = array('pembelian_header_id' => $get_row->pembelian_header_id);
			$where_telah_bayar = array('debt_detail_purchase_order_header_id' => $get_row->pembelian_header_id);
			$return_total = 0;
			$paid_total = 0;
			$disc_total = 0;
			$return_data  = $this->Debts_model->get_sum_retur($where)->row();
			$paid_data  = $this->Debts_model->get_sum_telah_bayar($where_telah_bayar)->row();
			if ($return_data) {
				$return_total = $return_data->total_retur;
			}
			if ($paid_data) {
				$paid_total = $paid_data->total_telah_bayar;
				$disc_total = $paid_data->total_disc;
			}
			$total = ($get_row->pembelian_header_grand_total - $return_total - $paid_total - $disc_total);
			if ($total > 0) {
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->pembelian_header_id,
					'number'       => $get_row->pembelian_header_number,
					'date'         => indonesian_date($get_row->pembelian_header_date, 'd/m/Y'),
					'sub_total'    => number_format($get_row->pembelian_header_grand_total),
					'paid_total'   => number_format($paid_total + $disc_total),
					'return_total' => number_format($return_total + $paid_total + $disc_total),
					'total'        => number_format($total),
					'total_bayar'        => number_format(0),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_debt_edit()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$po_id    = $this->input->post('po_id');
		$supplier = $this->input->post('supplier');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Debts_model->purchaseorder_headersearch($type, $supplier, $search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$where  = array('pembelian_header_id' => $get_row->pembelian_header_id);
			$where2 = array('purchase_return_header_id' => $id, 'pembelian_header_id' => $get_row->pembelian_header_id);
            // debt_detail_purchase_order_header_id
			$where_telah_bayar  = array('debt_detail_purchase_order_header_id' => $get_row->pembelian_header_id);
			$where_telah_bayar2 = array(
				'debt_detail_purchase_order_header_id' => $get_row->pembelian_header_id,
				'debt_header_retur_id' => $id
			);

			$return_total  = 0;
			$return_total2 = 0;
			$paid_total    = 0;
			$disc_total    = 0;
			$paid_total2   = 0;
			$disc_total2   = 0;
			$return_data   = $this->Debts_model->get_sum_retur($where)->row();
			$return_data2  = $this->Debts_model->get_sum_retur($where2)->row();
			$paid_data     = $this->Debts_model->get_sum_telah_bayar($where_telah_bayar)->row();
			$paid_data2    = $this->Debts_model->get_sum_telah_bayar($where_telah_bayar2)->row();
			if ($return_data) {
				$return_total = $return_data->total_retur;
			}
			if ($return_data2) {
				$return_total2 = $return_data2->total_retur;
			}
			if ($paid_data) {
				$paid_total = $paid_data->total_telah_bayar;
				$disc_total = $paid_data->total_disc;
			}

			if ($paid_data2) {
				$paid_total2 = $paid_data2->total_telah_bayar;
				$disc_total2 = $paid_data2->total_disc;
			}
			$total = ($get_row->pembelian_header_grand_total - $return_total - $paid_total - $disc_total);
			if (($total + $paid_total2 + $return_total2) > 0) {
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->pembelian_header_id,
					'number'       => $get_row->pembelian_header_number,
					'date'         => indonesian_date($get_row->pembelian_header_date, 'd/m/Y'),
					'sub_total'    => number_format($get_row->pembelian_header_grand_total),
					'paid_total'   => number_format($paid_total + $disc_total),
					'return_total' => number_format($return_total + $paid_total + $disc_total),
					'total'        => number_format($total + $paid_total2 + $return_total2),
					'total_bayar'  => number_format($paid_total2),
				);

				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_detail_edit()
	{
		$id     = $this->input->post("id");
		$where  = array('purchase_return_detail_header_id' => $id);
		$order  = array('item_name' => 'asc');

		$data = [];


		$get_data = $this->Purchase_returns_model->purchasereturn_detail($where)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$large_unit_quantity  = 0;
				$medium_unit_quantity = 0;
				$small_unit_quantity  = 0;
				$result_large  = 0;
				$result_medium = 0;
				$result_small  = 0;
				$total = 0;

				$large_unit_quantity  = to_decimal($get_row->purchase_return_detail_large_unit_quantity);
				$medium_unit_quantity = to_decimal($get_row->purchase_return_detail_medium_unit_quantity);
				$small_unit_quantity  = to_decimal($get_row->purchase_return_detail_small_unit_quantity);
				$result_large         = number_format($get_row->purchase_return_detail_result_large);
				$result_medium        = number_format($get_row->purchase_return_detail_result_medium);
				$result_small         = number_format($get_row->purchase_return_detail_result_small);
				$large_price_order    = number_format($get_row->purchase_return_detail_large_unit_price);
				$medium_price_order   = number_format($get_row->purchase_return_detail_medium_unit_price);
				$small_price_order    = number_format($get_row->purchase_return_detail_small_unit_price);
				$total                = number_format($get_row->purchase_return_detail_total);


				$medium_price_order = ($medium_price_order == "0" ? (($get_row->purchase_return_detail_large_unit_price / to_decimal($get_row->large_unit_contain) * to_decimal($get_row->medium_unit_contain))) : $medium_price_order);
				$small_price_order  = ($small_price_order == "0" ? ($get_row->purchase_return_detail_large_unit_price / to_decimal($get_row->large_unit_contain)) : $small_price_order);

				$total_stock = (($get_row->large_unit_contain * $get_row->purchase_return_detail_large_unit_quantity)
					+ ($get_row->medium_unit_contain * $get_row->purchase_return_detail_medium_unit_quantity)
					+ ($get_row->small_unit_contain * $get_row->purchase_return_detail_small_unit_quantity));

				$data[] = array(
					'no'                => $no,
					'detail_id'         => $get_row->purchase_return_detail_id,
					'detail_header_id'  => $get_row->purchase_return_detail_header_id,
					'id'                => $get_row->purchase_return_detail_item_id,
					'name'              => $get_row->purchase_return_detail_item_name,
					'lg_unit'           => $get_row->purchase_return_detail_large_unit,
					'lg_unit_cnt'       => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty' 		=> $large_unit_quantity,
					'lg_unit_qty_order' => to_decimal($get_row->purchase_return_detail_large_unit_quantity),
					'lg_unit_prc'       => $large_price_order,
					'result_large'      => $result_large,
					'md_unit'           => $get_row->purchase_return_detail_medium_unit,
					'md_unit_cnt'       => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty' 		=> $medium_unit_quantity,
					'md_unit_qty_order' => to_decimal($get_row->purchase_return_detail_medium_unit_quantity),
					'md_unit_prc'       => $medium_price_order,
					'result_medium'     => $result_medium,
					'sm_unit'           => $get_row->purchase_return_detail_small_unit,
					'sm_unit_cnt'       => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty' 		=> $small_unit_quantity,
					'sm_unit_qty_order' => to_decimal($get_row->purchase_return_detail_small_unit_quantity),
					'sm_unit_prc'       => $small_price_order,
					'result_small'      => $result_small,
					'ppn_status'         => "2",
					// 'discount'          => to_decimal($get_row->purchase_return_detail_discount_percentage),
					// 'discount_total'    => number_format($get_row->purchase_return_detail_discount_total),
					'total'             => $total,
					'total_stock'       => $total_stock,
					'total_stock_stored' => $total_stock,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_detail_by_faktur()
	{
		$id     = $this->input->post("id");
		$where  = array('pembelian_detail_header_id' => $id);
		$order  = array('item_name' => 'asc');

		$data = [];


		$get_data = $this->Pembelian_model->purchaseorder_detail($where)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$retur_large_unit_quantity  = 0;
				$retur_medium_unit_quantity = 0;
				$retur_small_unit_quantity  = 0;

				$large_unit_quantity  = 0;
				$medium_unit_quantity = 0;
				$small_unit_quantity  = 0;
				$result_large  = 0;
				$result_medium = 0;
				$result_small  = 0;
				$total = 0;

				$where_retur = array('pembelian_header_id' => $get_row->pembelian_detail_header_id, 'purchase_return_detail_item_id' => $get_row->pembelian_detail_item_id);
				$gdata_retur = $this->Purchase_returns_model->purchasereturn_lite($where_retur)->row();
				if ($gdata_retur) {
					$retur_large_unit_quantity  = $gdata_retur->purchase_return_detail_large_unit_quantity;
					$retur_medium_unit_quantity = $gdata_retur->purchase_return_detail_medium_unit_quantity;
					$retur_small_unit_quantity  = $gdata_retur->purchase_return_detail_small_unit_quantity;
				}


				$large_unit_quantity  = to_decimal($get_row->pembelian_detail_large_unit_quantity - $retur_large_unit_quantity);
				$medium_unit_quantity = to_decimal($get_row->pembelian_detail_medium_unit_quantity - $retur_medium_unit_quantity);
				$small_unit_quantity  = to_decimal($get_row->pembelian_detail_small_unit_quantity - $retur_small_unit_quantity);
				$result_large         = number_format($get_row->pembelian_detail_result_large);
				$result_medium        = number_format($get_row->pembelian_detail_result_medium);
				$result_small         = number_format($get_row->pembelian_detail_result_small);
				$large_price_order    = number_format($get_row->pembelian_detail_large_unit_price);
				$medium_price_order   = number_format($get_row->pembelian_detail_medium_unit_price);
				$small_price_order    = number_format($get_row->pembelian_detail_small_unit_price);
				$total                = number_format($get_row->pembelian_detail_total);


				$medium_price_order = ($medium_price_order == "0" ? (($get_row->pembelian_detail_large_unit_price / to_decimal($get_row->large_unit_contain) * to_decimal($get_row->medium_unit_contain))) : $medium_price_order);
				$small_price_order  = ($small_price_order == "0" ? ($get_row->pembelian_detail_large_unit_price / to_decimal($get_row->large_unit_contain)) : $small_price_order);

				$total_stock = (($get_row->large_unit_contain * $large_unit_quantity)
					+ ($get_row->medium_unit_contain * $medium_unit_quantity)
					+ ($get_row->small_unit_contain * $small_unit_quantity));

				$data[] = array(
					'no'                => $no,
					'detail_id'         => $get_row->pembelian_detail_id,
					'detail_header_id'  => $get_row->pembelian_detail_header_id,
					'id'                => $get_row->pembelian_detail_item_id,
					'name'              => $get_row->pembelian_detail_item_name,
					'lg_unit'           => $get_row->pembelian_detail_large_unit,
					'lg_unit_cnt'       => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty' 		=> 0,
					'lg_unit_qty_order' => to_decimal($large_unit_quantity),
					'lg_unit_prc'       => $large_price_order,
					'result_large'      => 0,
					'md_unit'           => $get_row->pembelian_detail_medium_unit,
					'md_unit_cnt'       => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty' 		=> 0,
					'md_unit_qty_order' => to_decimal($medium_unit_quantity),
					'md_unit_prc'       => $medium_price_order,
					'result_medium'     => 0,
					'sm_unit'           => $get_row->pembelian_detail_small_unit,
					'sm_unit_cnt'       => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty' 		=> 0,
					'sm_unit_qty_order' => to_decimal($small_unit_quantity),
					'sm_unit_prc'       => $small_price_order,
					'result_small'      => 0,
					// 'discount'          => to_decimal($get_row->purchase_return_detail_discount_percentage),
					// 'discount_total'    => number_format($get_row->purchase_return_detail_discount_total),
					'total'             => 0,
					'ppn_status'         => "2",
    				'ppn_status_color'   => "",
    				'ppn_total'          => 0,
					'total_stock'       => $total_stock,
					'total_stock_stored' => $total_stock,
				);
				$no++;
			}
		}

		output_json($data);
	}
	
	public function get_data_ppn()
	{
		$id = $this->input->post("id");

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);

		if ($id != 'new') {
			$where       = array('purchase_return_header_id' => $id);
			$header_data = $this->Purchase_returns_model->purchasereturn_header($where)->row_array();
			$ppn_amount   = $header_data['purchase_return_header_ppn_percentage'];
		}

		echo json_encode(to_decimal($ppn_amount));
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/purchase_returns/embed', $data);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$number_po         = $this->input->post("number_po");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
			$ppn_id         = $this->input->post("ppn_id");
		$ppn_percentage = $this->input->post("ppn_percentage");
		$ppn_total      = $this->input->post("ppn_total");
		// $payment_method = $this->input->post("payment_method");
		// $payment_term   = $this->input->post("payment_term");
		// $payment_due    = $this->input->post("payment_due");
		$total_retur    = $this->input->post("total_retur");
		$total_hutang    = $this->input->post("total_hutang");
		$total_tunai    = $this->input->post("total_tunai");
		$description    = $this->input->post("description");

		$tmstamp         = $this->input->post("tmstamp");
$ppn_type = ($ppn_id == NULL ? 0 : 1);
		$vuedata = $this->input->post('vuedata');
		$db_vuedata = $this->input->post('db_vuedata');

		// $payment_term_data = ($payment_term == "" ? "0" : substr($payment_term ,0 ,-5));
		// $payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));

		$header_id   = $id;

		$trheader_id       = 0;
		$default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row_array();
		$transfer_number   = $this->Transfer_model->transfer_autonumber();
		$prefix            = 'TF';
		$datenow           = date('ym');
		$autonumber        = $prefix . $datenow . '-' . $transfer_number;

		$status_bayar = 'Lunas';
		if (trims($total_retur) > (trims($total_hutang) + trims($total_tunai))) {
			$status_bayar = 'Belum Lunas';
		}

		$header_data = [
			'pembelian_header_id'            => $number_po,
			'purchase_return_header_number'       => $number,
			'purchase_return_header_date'         => change_format_date($date),
			'purchase_return_header_supplier_id'  => $supplier,
			'purchase_return_header_grand_total'  => trims($total_retur),
			'purchase_return_header_total_hutang' => trims($total_hutang),
			'purchase_return_header_ppn_id'         => $ppn_type,
			'purchase_return_header_ppn_percentage' => $ppn_percentage,
			'purchase_return_header_ppn_total'      => trims($ppn_total),
			'purchase_return_header_total_tunai'  => trims($total_tunai),
			'purchase_return_header_description'  => $description,
			'purchase_return_header_status'  => $status_bayar,
		];

// 		$trheader_data = [
// 			'header_number' => $autonumber,
// 			'header_date'   => change_format_date($date),
// 			'header_from'   => $default_warehouse['warehouse_id'],
// 			'header_to'     => 0
// 		];

		$db_detail_data = [];
		$detail_data = [];
		$log_data = [];
		$update_lunas = [];

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Purchase_returns_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();

				// $save_trheader = $this->Transfer_model->save_header($trheader_data);
				// $trheader_id = $this->db->insert_id();
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'purchase_return_detail_header_id'            => $header_id,
						'purchase_return_detail_item_id'              => $row['id'],
						'purchase_return_detail_item_name'            => $row['name'],
						'purchase_return_detail_large_unit'           => $row['lg_unit'],
						'purchase_return_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
						'purchase_return_detail_large_unit_price'     => trims($row['lg_unit_prc']),
						'purchase_return_detail_result_large'         => trims($row['result_large']),
						'purchase_return_detail_medium_unit'          => $row['md_unit'],
						'purchase_return_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
						'purchase_return_detail_medium_unit_price'    => trims($row['md_unit_prc']),
						'purchase_return_detail_result_medium'        => trims($row['result_medium']),
						'purchase_return_detail_small_unit'           => $row['sm_unit'],
						'purchase_return_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
						'purchase_return_detail_small_unit_price'     => trims($row['sm_unit_prc']),
						'purchase_return_detail_result_small'         => trims($row['result_small']),
						'purchase_return_detail_ppn_status'           => $row['ppn_status'],
						'purchase_return_detail_ppn_total'            => trims($row['ppn_total']),
						'purchase_return_detail_total'                => trims($row['total'])
					];

				// 	$trdetail_data[] = [
				// 		'header_id'      => $trheader_id,
				// 		'transaction_id' => $header_id,
				// 		'item_id'        => $row['id'],
				// 		'lg_qty'         => trims($row['lg_unit_qty']),
				// 		'md_qty'         => trims($row['md_unit_qty']),
				// 		'sm_qty'         => trims($row['sm_unit_qty']),
				// 		'status'         => "R-BUY",
				// 	];

					// $where                 = array('log_item_id' => $row['id']);
					$dtstamp = change_format_date($date) . " " . date("H:i:s");
					$where   = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
					$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
					$last_total_stock      = 0;
					$last_log_total_stock_value = 0;
					// $last_log_avg_large = 0;

					if (!empty($log_data_check)) {
						$last_total_stock           = $log_data_check['log_total_stock'];
						$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
						// $last_log_avg_large         = $log_data_check['log_average_large_unit'];
					}

					$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : (trims($row['lg_unit_prc']) / $row['md_unit_cnt']));
					$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : (trims($row['lg_unit_prc']) / $row['lg_unit_cnt']));

					$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (-trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (-trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (-trims($row['sm_unit_qty'])));
					$log_total_transaction_value = ((-trims($row['lg_unit_qty'])) * trims($row['lg_unit_prc'])) + ((-trims($row['md_unit_qty'])) * $medium_purchase_price) + ((-trims($row['sm_unit_qty'])) * $small_purchase_price);
					$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
					$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
					// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
					$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
					$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
					$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

					$log_data[] = [
						'log_type'                            => 'R-BUY',
						'log_transaction_id'                  => $header_id,
						'log_item_id'                         => $row['id'],
						'log_large_unit'                      => $row['lg_unit'],
						'log_large_unit_contain'              => $row['lg_unit_cnt'],
						'log_large_unit_quantity'             => (-trims($row['lg_unit_qty'])),
						// 'log_large_unit_purchase_price'       => $last_log_avg_large,
						'log_large_unit_purchase_price'        => trims($row['lg_unit_prc']),
						'log_medium_unit'                     => $row['md_unit'],
						'log_medium_unit_contain'             => $row['md_unit_cnt'],
						'log_medium_unit_quantity'            => (-trims($row['md_unit_qty'])),
						// 'log_medium_unit_purchase_price'      => $medium_purchase_price,
						'log_medium_unit_purchase_price'       => trims($row['md_unit_prc']),
						'log_small_unit'                      => $row['sm_unit'],
						'log_small_unit_contain'              => $row['sm_unit_cnt'],
						'log_small_unit_quantity'             => (-trims($row['sm_unit_qty'])),
						// 'log_small_unit_purchase_price'       => $small_purchase_price,
						'log_small_unit_purchase_price'        => trims($row['sm_unit_prc']),
						'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
						'log_total_transaction_value'         => $log_total_transaction_value,
						'log_total_stock'                     => $log_total_stock,
						'log_total_stock_value'               => $log_total_stock_value,
						'log_average_large_unit'              => $log_average_large_unit,
						'log_average_medium_unit'             => $log_average_medium_unit,
						'log_average_small_unit'              => $log_average_small_unit,
						'timestamp'                           => $dtstamp
					];
				}

				$save_detail = $this->Purchase_returns_model->save_detail($detail_data, true);
				// $save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

				if ($save_detail) {
					$save_log = $this->Logs_model->save($log_data, true);

					if ($save_log) {
						$update_log = $this->update_log($vuedata, $header_id, $date);
						// $update_log = true;
						if ($update_log) {
							// $s_trx = 'update';
							// $update_master_item = $this->Pembelian_model->update_master_item_batch($newprice_data);

							$db_datenow          = date('mY');
							$db_number_generator = '';
							$db_where            = array('supplier_id' => $supplier);
							$db_supplier_data    = $this->Suppliers_model->get_data($db_where)->row();

							if ($db_supplier_data) {
								$number_generator = $this->Debts_model->debt_autonumber($db_supplier_data->supplier_code);
							}

							$db_prefix     = "DB-" . $db_supplier_data->supplier_code;
							$db_autonumber = $db_prefix . $db_datenow . $db_number_generator;

							$db_header_data = [
								'debt_header_number'         => $db_autonumber,
								'debt_header_retur_id'       => $header_id,
								'debt_header_date'           => change_format_date($date),
								'debt_header_supplier_id'    => $supplier,
								'debt_header_bank_id'        => 0,
								'debt_header_payment_method' => 'Tunai/Lainnya',
								'debt_header_number_giro'    => '',
								'debt_header_payment_due'    => '',
								'debt_header_sub_total'      => trims($total_hutang),
								'debt_header_return_total'   => 0,
								'debt_header_grand_total'    => trims($total_hutang),
								'debt_header_total_hutang'    => trims($total_hutang),
								'debt_header_bayar_total'    => trims($total_hutang),
								'debt_header_total_tunai'    => trims($total_tunai),
								'debt_header_description'    => '',
								'from_retur'                    => 1
							];

							$db_save_header = $this->Debts_model->save_header($db_header_data);
							if ($db_save_header) {
								$db_header_id = $this->db->insert_id();
								foreach ($db_vuedata as $db_row) {
									if ($db_row['total_bayar'] > 0) {
										$db_detail_data[] = [
											'debt_detail_header_id'                => $db_header_id,
											'debt_detail_purchase_order_header_id' => $db_row['id'],
											'debt_detail_price'                    => trims($db_row['total']),
											'debt_detail_discount_percentage'      => 0,
											'debt_detail_discount_total'           => 0,
											'debt_detail_return_total'             => 0,
											'debt_detail_total'                    => trims($db_row['total']),
											'debt_detail_bayar'                    => trims($db_row['total_bayar']),
										];
									}

									if (trims($db_row['total']) == trims($db_row['total_bayar'])) {
										$update_lunas[] = [
											'pembelian_header_id' => $db_row['id'],
											'status_paid'              => 1,
										];
									}
								}

								if (!empty($update_lunas)) {
									$update_lunas_po = $this->Purchase_returns_model->update_lunas_po($update_lunas);
								}

								$db_save_detail = false;
								$db_delete_header = false;
								if (!empty($db_detail_data)) {
									$db_save_detail = $this->Debts_model->save_detail($db_detail_data, true);
								} else {
									$db_delete_header = $this->Debts_model->delete_header($db_header_id);
								}

								if ($db_save_detail || $db_delete_header) {

									$save_journal = $this->save_journal($header_id, $total_retur, $total_tunai, $number,trims($ppn_total),$total_hutang);

									// $prefix_jr           = "JR";
									// $datenow_jr          = date('Ym');
									// $number_generator_jr = $this->Journals_model->journal_autonumber();
									// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

									// $header_data_jr = [
									// 	'journal_header_number'       => $autonumber_jr,
									// 	'journal_header_trx_id'       => $header_id,
									// 	'journal_header_trx_type'     => "R-BUY",
									// 	'journal_header_date'         => change_format_date($date),
									// 	'journal_header_total_debit'  => trims($total_retur),
									// 	'journal_header_total_credit' => trims($total_retur),
									// 	'journal_header_description'  => $number,
									// ];

									// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
									// $header_id_jr = $this->db->insert_id();

									// $detail_data_jr = [
									// 	[
									// 		'journal_detail_header_id'      => $header_id_jr,
									// 		'journal_detail_trx_id'         => $header_id,
									// 		'journal_detail_trx_type'       => "R-BUY",
									// 		'journal_detail_account_id'     => '24',
									// 		'journal_detail_account_number' => '210000019',
									// 		'journal_detail_account_name'   => 'Utang Usaha',
									// 		'journal_detail_debit'          => trims($total_retur),
									// 		'journal_detail_credit'         => 0,
									// 		'journal_detail_description'    => ''
									// 	],
									// 	[
									// 		'journal_detail_header_id'      => $header_id_jr,
									// 		'journal_detail_trx_id'         => $header_id,
									// 		'journal_detail_trx_type'       => "R-BUY",
									// 		'journal_detail_account_id'     => '20',
									// 		'journal_detail_account_number' => '11000035',
									// 		'journal_detail_account_name'   => 'Persediaan Material',
									// 		'journal_detail_debit'          => 0,
									// 		'journal_detail_credit'         => trims($total_retur),
									// 		'journal_detail_description'    => ''
									// 	]
									// ];

									// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

									$msg    = "Berhasil menyimpan data";
									$status = "success";
								} else {
									$msg    = "Gagal menyimpan data";
									$status = "error";
								}
							}

							// if($update_master_item)
							// {
							// $msg    = "Berhasil menyimpan data";
							// $status = "success";
							// }else{
							// 	$msg    = "Gagal menyimpan data #CKP-U01";
							// 	$status = "error";	
							// }
						} else {
							$msg    = "Gagal menyimpan data #CKP-U01";
							$status = "error";
						}
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {

			// This New Update
// 			$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $header_id, 'status' => 'R-BUY'))->row()->header_id;
			$id_debt  = $this->Debts_model->debt_header_lite(array('debt_header_retur_id' => $header_id))->row()->id;

			$delete_detail = $this->Purchase_returns_model->delete_detail($id);

// 			$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
// 			$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

			$db_delheader = $this->Debts_model->delete_headerbyretur($header_id);
			$db_deldetail = $this->Debts_model->delete_detail($id_debt);

			$jr_delheader = $this->Journals_model->delete_headerbytrxid($header_id, "R-BUY");
			$jr_deldetail = $this->Journals_model->delete_detailbytrxid($header_id, "R-BUY");

			if ($delete_detail) {

				// $delete_log = $this->delete_log($id);
				$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'R-BUY'));

				if ($delete_log) {
					$save_header = $this->Purchase_returns_model->update_header($id, $header_data);
					$delete_journal = $this->delete_journal($id);


					if ($save_header) {
						// $header_id = $this->db->insert_id();
				// 		$save_trheader = $this->Transfer_model->save_header($trheader_data);
						$trheader_id = $this->db->insert_id();

						foreach ($vuedata as $row) {
							$detail_data[] = [
								'purchase_return_detail_header_id'            => $header_id,
								'purchase_return_detail_item_id'              => $row['id'],
								'purchase_return_detail_item_name'            => $row['name'],
								'purchase_return_detail_large_unit'           => $row['lg_unit'],
								'purchase_return_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
								'purchase_return_detail_large_unit_price'     => trims($row['lg_unit_prc']),
								'purchase_return_detail_result_large'         => trims($row['result_large']),
								'purchase_return_detail_medium_unit'          => $row['md_unit'],
								'purchase_return_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
								'purchase_return_detail_medium_unit_price'    => trims($row['md_unit_prc']),
								'purchase_return_detail_result_medium'        => trims($row['result_medium']),
								'purchase_return_detail_small_unit'           => $row['sm_unit'],
								'purchase_return_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
								'purchase_return_detail_small_unit_price'     => trims($row['sm_unit_prc']),
								'purchase_return_detail_result_small'         => trims($row['result_small']),
								'purchase_return_detail_ppn_status'           => $row['ppn_status'],
						        'purchase_return_detail_ppn_total'            => 0,
								'purchase_return_detail_total'                => trims($row['total'])
							];

							// $where                 = array('log_item_id' => $row['id'], 'a.timestamp <' => $tmstamp);
							$dtstamp = change_format_date($date) . " " . $tmstamp;
							$where   = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
							$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
							$last_total_stock      = 0;
							$last_log_total_stock_value = 0;
							$last_log_avg_large = 0;
							$last_log_avg_medium = 0;
							$last_log_avg_small = 0;

							if (!empty($log_data_check)) {
								$last_total_stock           = $log_data_check['log_total_stock'];
								$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
								$last_log_avg_large         = $log_data_check['log_average_large_unit'];
								$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
								$last_log_avg_small         = $log_data_check['log_average_small_unit'];
							}

							$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
							$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));

							$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (-trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (-trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (-trims($row['sm_unit_qty'])));
							$log_total_transaction_value = ((-trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((-trims($row['md_unit_qty'])) * $medium_purchase_price) + ((-trims($row['sm_unit_qty'])) * $small_purchase_price);
							$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
							$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
							$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

							$log_data[] = [
								'log_type'                            => 'R-BUY',
								'log_transaction_id'                  => $header_id,
								'log_item_id'                         => $row['id'],
								'log_large_unit'                      => $row['lg_unit'],
								'log_large_unit_contain'              => $row['lg_unit_cnt'],
								'log_large_unit_quantity'             => (-trims($row['lg_unit_qty'])),
								// 'log_large_unit_purchase_price'       => $last_log_avg_large,
								'log_large_unit_purchase_price'        => trims($row['lg_unit_prc']),
								'log_medium_unit'                     => $row['md_unit'],
								'log_medium_unit_contain'             => $row['md_unit_cnt'],
								'log_medium_unit_quantity'            => (-trims($row['md_unit_qty'])),
								// 'log_medium_unit_purchase_price'      => $medium_purchase_price,
								'log_medium_unit_purchase_price'       => trims($row['md_unit_prc']),
								'log_small_unit'                      => $row['sm_unit'],
								'log_small_unit_contain'              => $row['sm_unit_cnt'],
								'log_small_unit_quantity'             => (-trims($row['sm_unit_qty'])),
								// 'log_small_unit_purchase_price'       => $small_purchase_price,
								'log_small_unit_purchase_price'        => trims($row['sm_unit_prc']),
								'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
								'log_total_transaction_value'         => $log_total_transaction_value,
								'log_total_stock'                     => $log_total_stock,
								'log_total_stock_value'               => $log_total_stock_value,
								'log_average_large_unit'              => $log_average_large_unit,
								'log_average_medium_unit'             => $log_average_medium_unit,
								'log_average_small_unit'              => $log_average_small_unit,
								'timestamp'                           => $dtstamp
							];

				// 			$trdetail_data[] = [
				// 				'header_id'      => $trheader_id,
				// 				'transaction_id' => $header_id,
				// 				'item_id'        => $row['id'],
				// 				'lg_qty'         => trims($row['lg_unit_qty']),
				// 				'md_qty'         => trims($row['md_unit_qty']),
				// 				'sm_qty'         => trims($row['sm_unit_qty']),
				// 				'status'         => "R-BUY",
				// 			];
						}

						$save_detail = $this->Purchase_returns_model->save_detail($detail_data, true);
				// 		$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

						if ($save_detail) {

							$save_log = $this->Logs_model->save($log_data, true);

							if ($save_log) {
								$update_log = $this->update_log($vuedata, $header_id, $date);
								// $update_log = true;
								if ($update_log) {
									// $s_trx = 'update';
									// $checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
									// if($checkpoint)
									// {
									// $msg    = "Berhasil menyimpan data";
									// $status = "success";
									// }else{
									// 	$msg    = "Gagal menyimpan data #CKP-U01";
									// 	$status = "error";	
									// }


									$db_datenow          = date('mY');
									$db_number_generator = '';
									$db_where            = array('supplier_id' => $supplier);
									$db_supplier_data    = $this->Suppliers_model->get_data($db_where)->row();

									if ($db_supplier_data) {
										$number_generator = $this->Debts_model->debt_autonumber($db_supplier_data->supplier_code);
									}

									$db_prefix     = "DB-" . $db_supplier_data->supplier_code;
									$db_autonumber = $db_prefix . $db_datenow . $db_number_generator;

									$db_header_data = [
										'debt_header_number'         => $db_autonumber,
										'debt_header_retur_id'       => $header_id,
										'debt_header_date'           => change_format_date($date),
										'debt_header_supplier_id'    => $supplier,
										'debt_header_bank_id'        => 0,
										'debt_header_payment_method' => 'Tunai/Lainnya',
										'debt_header_number_giro'    => '',
										'debt_header_payment_due'    => '',
										'debt_header_sub_total'      => trims($total_hutang),
										'debt_header_return_total'   => 0,
										'debt_header_grand_total'    => trims($total_hutang),
										'debt_header_total_hutang'   => trims($total_hutang),
										'debt_header_bayar_total'    => trims($total_hutang),
										'debt_header_total_tunai'    => trims($total_tunai),
										'debt_header_description'    => '',
										'from_retur'                    => 1
									];

									$db_save_header = $this->Debts_model->save_header($db_header_data);
									if ($db_save_header) {
										$db_header_id = $this->db->insert_id();
										foreach ($db_vuedata as $db_row) {
											if ($db_row['total_bayar'] > 0) {
												$db_detail_data[] = [
													'debt_detail_header_id'                => $db_header_id,
													'debt_detail_purchase_order_header_id' => $db_row['id'],
													'debt_detail_price'                    => trims($db_row['total']),
													'debt_detail_discount_percentage'      => 0,
													'debt_detail_discount_total'           => 0,
													'debt_detail_return_total'             => 0,
													'debt_detail_total'                    => trims($db_row['total']),
													'debt_detail_bayar'                    => trims($db_row['total_bayar']),
												];
											}

											if (trims($db_row['total']) == trims($db_row['total_bayar'])) {
												$update_lunas[] = [
													'pembelian_header_id' => $db_row['id'],
													'status_paid'              => 1,
												];
											}
										}

										if (!empty($update_lunas)) {
											$update_lunas_po = $this->Purchase_returns_model->update_lunas_po($update_lunas);
										}

										$db_save_detail = false;
										$db_delete_header = false;
										if (!empty($db_detail_data)) {
											$db_save_detail = $this->Debts_model->save_detail($db_detail_data, true);
										} else {
											$db_delete_header = $this->Debts_model->delete_header($db_header_id);
										}

										if ($db_save_detail || $db_delete_header) {

											$save_journal = $this->save_journal($header_id, $total_retur, $total_tunai, $number,trims($ppn_total),$total_hutang);


											// $prefix_jr           = "JR";
											// $datenow_jr          = date('Ym');
											// $number_generator_jr = $this->Journals_model->journal_autonumber();
											// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

											// $header_data_jr = [
											// 	'journal_header_number'       => $autonumber_jr,
											// 	'journal_header_trx_id'       => $header_id,
											// 	'journal_header_trx_type'     => "R-BUY",
											// 	'journal_header_date'         => change_format_date($date),
											// 	'journal_header_total_debit'  => trims($total_retur),
											// 	'journal_header_total_credit' => trims($total_retur),
											// 	'journal_header_description'  => $number,
											// ];

											// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
											// $header_id_jr = $this->db->insert_id();

											// $detail_data_jr = [
											// 	[
											// 		'journal_detail_header_id'      => $header_id_jr,
											// 		'journal_detail_trx_id'         => $header_id,
											// 		'journal_detail_trx_type'       => "R-BUY",
											// 		'journal_detail_account_id'     => '24',
											// 		'journal_detail_account_number' => '210000019',
											// 		'journal_detail_account_name'   => 'Utang Usaha',
											// 		'journal_detail_debit'          => trims($total_retur),
											// 		'journal_detail_credit'         => 0,
											// 		'journal_detail_description'    => ''
											// 	],
											// 	[
											// 		'journal_detail_header_id'      => $header_id_jr,
											// 		'journal_detail_trx_id'         => $header_id,
											// 		'journal_detail_trx_type'       => "R-BUY",
											// 		'journal_detail_account_id'     => '20',
											// 		'journal_detail_account_number' => '11000035',
											// 		'journal_detail_account_name'   => 'Persediaan Material',
											// 		'journal_detail_debit'          => 0,
											// 		'journal_detail_credit'         => trims($total_retur),
											// 		'journal_detail_description'    => ''
											// 	]
											// ];

											// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

											$msg    = "Berhasil menyimpan data";
											$status = "success";
										} else {
											$msg    = "Gagal menyimpan data";
											$status = "error";
										}
									} else {
										$msg    = "Gagal menyimpan data #DEB-U01";
										$status = "error";
									}
								} else {
									$msg    = "Gagal menyimpan data #CKP-U01";
									$status = "error";
								}
							} else {
								$msg    = "Gagal menyimpan data #LOG-S01";
								$status = "error";
							}
						} else {
							$msg    = "Gagal menyimpan data #LOG-U01";
							$status = "error";
						}
					} else {
						$msg    = "Gagal menyimpan data #HED-U01";
						$status = "error";
					}
				} else {
				}
			} else {
				$msg    = "Gagal menyimpan data #DEL-U01";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function save_journal($header_id, $sub_total, $total_tunai, $number,$ppn,$total_hutang)
	{
		$prefix           = "JR";
		$datenow          = date('Ym');
		$number_generator = $this->Journals_model->journal_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$header_data = [
			// 'journal_header_number'       => ($id == "new" ? $autonumber : $number),
			'journal_header_trx_id'       => $header_id,
			'journal_header_trx_type'     => "RBUY",
			'journal_header_number'       => ($autonumber),
			'journal_header_date'         => date_now(),
			'journal_header_total_debit'  => trims($sub_total),
			'journal_header_total_credit' => trims($sub_total),
			'journal_header_description'  => $number,
		];

		$detail_data = [];

		if($total_tunai == 0){
			$account =  $this->Accounts_model->get_data_settings_advance(array('trx_type' => 'PORK'))->result();
		}else{
			$account =  $this->Accounts_model->get_data_settings_advance(array('trx_type' => 'POR'))->result();
		}

		$save_header_jr = $this->Journals_model->save_header($header_data);
		$header_id_jr = $this->db->insert_id();

		foreach ($account as $get_row) {

			$status = $get_row->status;
			$detail_data[] = [
				'journal_detail_trx_id'         => $header_id,
				'journal_detail_trx_type'       => "RBUY",
				'journal_detail_header_id'      => $header_id_jr,
				'journal_detail_account_id'     => $get_row->account_id,
				'journal_detail_account_number' => $get_row->account_number,
				'journal_detail_account_name'   => $get_row->account_name,
				'journal_detail_account_group'      => $get_row->account_group_name,
				'journal_detail_debit'          => ($get_row->account_name != "Kas / Bank"  ? ($status == "D" ? trims($total_hutang) : 0) : ($status == "D" ? trims($total_tunai) : 0)),
				'journal_detail_credit'         => ($get_row->account_name != "PPN MASUKAN"  ? ($status == "K" ? trims($sub_total) - $ppn : 0) : ($status == "K" ? $ppn : 0)),
				'journal_detail_description'    => ""
			];
		}

		$save_detail = $this->Journals_model->save_detail($detail_data, true);
	}

	public function delete_journal($id)
	{
		$type = "RBUY";
		$delete_header = $this->Journals_model->delete_headerbytrxid($id, $type);

		if ($delete_header) {
			$delete_type = $this->Journals_model->delete_headerbytrxid($id, $type);
		}
	}

	public function update_log($vuedata, $header_id, $date)
	{
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach ($vuedata as $rowes) {

			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->cek_data($where_1)->result();

			if (count($get_first) > 1) {
				$get_first       = $this->Logs_model->get_data_first($where_1)->row();
				$logs_id         = $get_first->tmslog;

				$total_stok      = $get_first->log_total_stock;
				$total_stok_rupiah = $get_first->log_total_stock_value;

				$avg_lg  = ($get_first->log_average_large_unit);
				$avg_md  = ($get_first->log_average_medium_unit);
				$avg_sm  = ($get_first->log_average_small_unit);

				$log_total_transaction_value = 0;

				$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
				$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

				foreach ($get_data_all_logs_by_item as $row) {


					$total_stok      += $row->log_total_transaction_in_small_unit;

					if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
						$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
					} else {
						$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
					}
					$total_stok_rupiah += $log_total_transaction_value;


					$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
					$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
					$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

					// $log_total_transaction_value = a;

					if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
						$avg_lg  = ($log_average_large_unit);
						$avg_md  = ($log_average_medium_unit);
						$avg_sm  = ($log_average_small_unit);
						$data_log[] = array(
							'log_id'                        => $row->log_id,
							// 'log_medium_unit_purchase_price' => $medium_purchase_price,
							// 'log_small_unit_purchase_price'  => $small_purchase_price,
							// 'log_total_transaction_value' => $log_total_transaction_value,
							'log_total_stock'             => $total_stok,
							'log_total_stock_value'       => $total_stok_rupiah,
							'log_average_large_unit'      => $log_average_large_unit,
							'log_average_medium_unit'     => $log_average_medium_unit,
							'log_average_small_unit'      => $log_average_small_unit,
							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
						);
					} else {

						$data_log[] = array(
							'log_id'                         => $row->log_id,
							'log_large_unit_purchase_price'  => $avg_lg,
							'log_medium_unit_purchase_price' => $avg_md,
							'log_small_unit_purchase_price'  => $avg_sm,
							'log_total_transaction_value'    => $log_total_transaction_value,
							'log_total_stock'                => $total_stok,
							'log_total_stock_value'          => $total_stok_rupiah,
							'log_average_large_unit'         => $log_average_large_unit,
							'log_average_medium_unit'        => $log_average_medium_unit,
							'log_average_small_unit'         => $log_average_small_unit,
							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
						);
					}
				}
			} else {
				return true;
			}
		}

		$after_row_log_update = $this->Logs_model->update_item_batch($data_log);

		return true;
	}

	public function get_number()
	{
		$id      = $this->input->post('id');


		$where       = array('pembelian_header_supplier_id' => $id);
		$purchs_data = $this->Pembelian_model->purchaseorder_header($where)->result();
        
        $datenow = date('ym');
		$year = date('y');
		$month = date('m');
		$number_generator = '';
		$where   = array('supplier_id' => $id);
		$supplier_data  = $this->Suppliers_model->get_data($where)->row();

		if ($supplier_data) {
			$number_generator = $this->Purchase_returns_model->purchasereturn_autonumber();
		}

		$prefix     = 'RB';
		$autonumber = $prefix . $supplier_data->supplier_code . $year . $month . '-'. $number_generator;


		$response = [
			'id'           => $id,
			'purch_data' => $purchs_data,
			'autonumber' => $autonumber
		];

		echo json_encode($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {
			$where = array('log_type' => 'R-BUY', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if ($get_after_data) {
					foreach ($get_after_data as $row_list_detail) {

						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id,
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);

						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;

						// $where_this = array('log_type' => 'R-BUY', 'log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						// $log_id = $this->Logs_model->get_data($where_this)->row()->log_id;

						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;

						if (!empty($one_line_before_log_data)) {
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
						}

						$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						$after_row_data_update = array(
							'log_id'                  => $row_list_detail->log_id,
							'log_total_stock'         => $log_total_stock,
							'log_total_stock_value'   => $log_total_stock_value,
							'log_average_large_unit'  => $log_average_large_unit,
							'log_average_medium_unit' => $log_average_medium_unit,
							'log_average_small_unit'  => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				} else {
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id,
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Purchase_returns_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Purchase_returns_model->delete_detail($row);
				$delete_journal = $this->delete_journal($row);
			}

// 			$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $row, 'status' => 'R-BUY'))->row()->header_id;

// 			$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
// 			$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

			$id_debt  = $this->Debts_model->debt_header_lite(array('debt_header_retur_id' => $row))->row();
			// echo json_encode($id_debt);
			// die();
			if ($id_debt != NULL) {
				$db_delheader = $this->Debts_model->delete_headerbyretur($row);
				$db_deldetail = $this->Debts_model->delete_detail($id_debt->id);
			}

			// $jr_delheader = $this->Journals_model->delete_headerbytrxid($row, "R-BUY");
			// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($row, "R-BUY");
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('sales_order_header_id' => $id);
		$where_detail = array('sales_order_detail_header_id' => $id);

		$header = $this->Purchase_returns_model->salesorder_header($where_header)->row_array();
		$detail = $this->Purchase_returns_model->salesorder_detail($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_out', $data);
	}
}
