<?php
/**
 * Report debts Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_pembayaran_debts extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Debts_model');
// 		$this->load->model('Sales_model');
		$this->load->model('Suppliers_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Pembayaran Hutang';
        $data['supplier_data'] = $this->Suppliers_model->get_data()->result();
        // $data['sales_data'] = $this->Sales_model->get_data()->result();
		
		$this->twiggy_display('adm/report_pembayaran_debts/index', $data);
	}
	
	public function deposit()
 	{	
        $data['content_title'] = 'Laporan Deposit';
        $data['customer_data'] = $this->Suppliers_model->get_data()->result();
		
		$this->twiggy_display('adm/report_pembayaran_debts/deposit', $data);
	}
	
	public function history($id)
 	{	
        $data['content_title'] = 'History';
        $order = ("debt_header_number ASC");
        $get_data = $this->Debts_model->debt_detail_advanced_history(array('debt_detail_sales_order_header_id' => $id), $order)->result();
        
        $data['history_data'] = $get_data;
        $data['id'] = $id;
		
		$this->twiggy_display('adm/report_pembayaran_debts/history', $data);
	}

	public function get_data_detail()
	{	
		$supplier = $this->input->post("supplier");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
// 		$user = $this->input->post("user");
 

        $data  = [];
		$where = [];
		$order = ("debt_header_number ASC");
//         if(isset($user) && $user != '' && $user != '(Semua)')
// 		{
// 			$where['sales_order_header_sales_id'] = $user;
// 		}
        if(isset($supplier) && $supplier != '' && $supplier != '(Semua)')
		{
			$where['debt_header_supplier_id'] = $supplier;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['debt_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['debt_header_date <='] = change_format_date($todate);
		}

		
		$get_data = $this->Debts_model->debt_detail_advanced($where, $order)->result();
		$grand_total = 0;
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
			
				$data[] = array(
					'no'           => $no,
					'debt_number' => $get_row->debt_header_number,
					
					'debt_date'   => change_format_date($get_row->debt_header_date, 'd/m/Y'),
					'supplier'     => $get_row->supplier_name,
				// 	'sales'     => $get_row->sales_name,
					'sales_number' => $get_row->pembelian_header_number,
					'sales_order_header_id' => $get_row->pembelian_header_id,
					'debt_sisa' => number_format($get_row->debt_detail_total),
					'debt_bayar'        => number_format($get_row->debt_detail_bayar),
					'debt_bayar'        => number_format($get_row->debt_detail_bayar),
				);
				$grand_total += $get_row->debt_detail_bayar;
                $no++;
                
			}
		}
		$this->session->set_userdata('customer', $supplier);
// 		$this->session->set_userdata('user', $user);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);
		$response = array(
		    'data' =>$data,
		    'grand_total' =>number_format($grand_total)
		    );

		output_json($response);
	}
	
	public function get_data_detail_deposit()
	{	
		$customer = $this->input->post("customer");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("debt_header_number ASC");

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['debt_detail_sales_customer_id'] = $customer;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['debt_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['debt_header_date <='] = change_format_date($todate);
		}

		
		$get_data = $this->Debts_model->debt_detail_deposit_laporan($where, $order)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
			
				$data[] = array(
					'no'           => $no,
					'debt_number' => $get_row->debt_header_number,
					'debt_id' => $get_row->debt_detail_id,
					'debt_date'   => change_format_date($get_row->debt_header_date, 'd/m/Y'),
					'customer'     => $get_row->customer_name,
					'sales_number' => $get_row->sales_order_header_number,
					'debt_sisa' => number_format($get_row->debt_detail_total),
					'debt_bayar'        => number_format($get_row->debt_detail_bayar),
					'deposit'        => number_format($get_row->debt_detail_bayar - $get_row->debt_detail_total),
				);
                $no++;
                
			}
		}
		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		output_json($data);
	}

	public function export_excel() {
        // $user = $this->session->userdata('user');
		$customer = $this->session->userdata('customer');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order    = ("debt_header_number ASC");
		$customer_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

         
        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['debt_header_supplier_id'] = $customer;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['debt_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['debt_header_date <='] = change_format_date($todate);
		}

// 		$where['status_paid'] = 0;
		
		$get_data = $this->Debts_model->debt_detail_advanced($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PIUTANG")
							   ->setSubject("PIUTANG")
							   ->setDescription("PIUTANG")
							   ->setKeywords("PIUTANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Pembayaran Piutang");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$fromdate_text." - ".$todate_text);

	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Nomor Pembayaran");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "Pelanggan");
	    $excel->setActiveSheetIndex(0)->setCellValue('D6', "Nomor Jual");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Total");
		$excel->setActiveSheetIndex(0)->setCellValue('F6', "Bayar");
		$excel->setActiveSheetIndex(0)->setCellValue('G6', "Sales");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('F6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('G6')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
	    $grand_total = 0;

		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
// 		'no'           => $no,
// 					'debt_number' => $get_row->debt_header_number,
					
// 					'debt_date'   => change_format_date($get_row->debt_header_date, 'd/m/Y'),
// 					'customer'     => $get_row->customer_name,
// 					'sales'     => $get_row->sales_name,
// 					'sales_number' => $get_row->sales_order_header_number,
// 					'sales_order_header_id' => $get_row->sales_order_header_id,
// 					'debt_sisa' => number_format($get_row->debt_detail_total),
// 					'debt_bayar'        => number_format($get_row->debt_detail_bayar),
// 					'debt_bayar'        => number_format($get_row->debt_detail_bayar),

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->debt_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->debt_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, number_format($get_row->debt_detail_total));
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, number_format($get_row->debt_detail_bayar));
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->sales_name));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':G'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('G'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $grand_total += $get_row->debt_detail_bayar;
	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		
		    $excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, "Grand Total");
            $excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, number_format($grand_total));
        
            // Merge "Grand Total" label across A-E
            $excel->getActiveSheet()->mergeCells('A'.$numrow.':E'.$numrow);
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PEMBAYARAN PIUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PEMBAYARANPIUTANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
