<?php
/**
 * Report Stock Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_stocks extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Logs_model');
		$this->load->model('Penerimaan_model');
		$this->load->model('Purchase_returns_model');
		$this->load->model('Sales_orders_model');
		$this->load->model('Sales_returns_model');
		$this->load->model('Stocks_model');
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Transfer_model');
		$this->load->model('Warehouses_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	 public function card()
 	{	
        $data['content_title'] = 'Laporan Kartu Stok';
        $data['item_data']     = $this->Items_model->get_data()->result();
        $data['warehouse_data']     = $this->Warehouses_model->get_data()->result();
		
		$this->twiggy_display('adm/report_stocks/card', $data);
	}

	public function recap()
 	{	
        $data['content_title'] = 'Laporan Rekap Stok';
        $data['item_data']     = $this->Items_model->get_data()->result();
        $data['group_data']    = $this->Groups_model->get_data()->result();
		
		$this->twiggy_display('adm/report_stocks/recap', $data);
	}

	public function recap_warehouse()
 	{	
        $data['content_title'] = 'Laporan Rekap Stok Gudang';
        $data['item_data']     = $this->Items_model->get_data()->result();
        $data['group_data']    = $this->Groups_model->get_data()->result();
        $data['warehouse_data'] = $this->Warehouses_model->get_data()->result();
		
		$this->twiggy_display('adm/report_stocks/recap_warehouse', $data);
	}
	
	public function get_data_detail_card()
	{
		$item     = $this->input->post("item");
		$bulan = $this->input->post("val_bulan");
		$tahun = $this->input->post("val_tahun");
		$warehouse = $this->input->post("warehouse");
		
		$status = $this->input->post("status");

		$data  = [];
		$where_po = [];
		$where_so = [];
		$where_pr = [];
		$where_sr = [];
		$where_st = [];
		$order = ("b.timestamp ASC");

		if (isset($item) && $item != '' && $item != '(Semua)') {
			$where_po['a.penerimaan_detail_item_id'] = $item;
			$where_so['a.sales_order_detail_item_id '] = $item;
			$where_sr['a.sales_return_detail_item_id '] = $item;
			$where_pr['a.purchase_return_detail_item_id'] = $item;
			$where_st['a.stock_detail_item_id'] = $item;
			$where_tr['a.item_id'] = $item;
		}
		
		
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($warehouse) && $warehouse != '')
	    {
           
            $where_po['b.penerimaan_header_warehouse_id'] = $warehouse;
            $where_so['a.sales_order_detail_warehouse_id '] = $warehouse;
            // $where_sr['date(sales_return_header_date) >='] = $warehouse;
            // $where_pr['date(purchase_return_header_date) >='] = $warehouse;
            $where_st['b.stock_header_warehouse_id'] = $warehouse;
            

	    }
		if(isset($bulan) && $bulan != '')
		{
		    // Input month name
            
        if(isset($tahun) && $tahun != '')
	    {
		    // Input month name
            $input_month = $bulan;
            $input_year = $tahun;
            
            $month_number = date('m', strtotime($input_month));
            $first_date_of_month = date('Y-m-01', strtotime($input_year . '-' . $month_number . '-01'));
            $last_date_of_month = date('Y-m-t', strtotime($input_year . '-' . $month_number . '-01'));
            // echo change_format_date($first_date_of_month)."-".change_format_date($last_date_of_month);
            $where_po['date(penerimaan_header_date) <='] = change_format_date($last_date_of_month);
            $where_po['date(penerimaan_header_date) >='] = change_format_date($first_date_of_month);
            
            $where_so['date(b.timestamp) <='] = change_format_date($last_date_of_month);
            $where_so['date(b.timestamp) >='] = change_format_date($first_date_of_month);
            
            $where_sr['date(sales_return_header_date) <='] = change_format_date($last_date_of_month);
            $where_sr['date(sales_return_header_date) >='] = change_format_date($first_date_of_month);
            
            $where_pr['date(purchase_return_header_date) <='] = change_format_date($last_date_of_month);
            $where_pr['date(purchase_return_header_date) >='] = change_format_date($first_date_of_month);
            
            $where_st['date(stock_header_date) <='] = change_format_date($last_date_of_month);
            $where_st['date(stock_header_date) >='] = change_format_date($first_date_of_month);

	    }else{
	        $input_month = $bulan;
            $month_number = date('m', strtotime($input_month));
            $first_date_of_month = date('Y-m-01', strtotime(date('Y') . '-' . $month_number . '-01'));
            $last_date_of_month = date('Y-m-t', strtotime(date('Y') . '-' . $month_number . '-01'));
            // echo change_format_date($first_date_of_month)."-".change_format_date($last_date_of_month);
			 $where_po['date(penerimaan_header_date) <='] = change_format_date($last_date_of_month);
            $where_po['date(penerimaan_header_date) >='] = change_format_date($first_date_of_month);
            
            $where_so['date(b.timestamp) <='] = change_format_date($last_date_of_month);
            $where_so['date(b.timestamp) >='] = change_format_date($first_date_of_month);
            
            $where_sr['date(sales_return_header_date) <='] = change_format_date($last_date_of_month);
            $where_sr['date(sales_return_header_date) >='] = change_format_date($first_date_of_month);
            
            $where_pr['date(purchase_return_header_date) <='] = change_format_date($last_date_of_month);
            $where_pr['date(purchase_return_header_date) >='] = change_format_date($first_date_of_month);
            
            $where_st['date(stock_header_date) <='] = change_format_date($last_date_of_month);
            $where_st['date(stock_header_date) >='] = change_format_date($first_date_of_month);
	    }
            
            
		}
		if(isset($tahun) && $tahun != '')
	    {

            $input_year = $tahun;
            
            $first_date_of_year = date('Y-01-01', strtotime($input_year . '-01-01'));

            // Get the last date of the year
            $last_date_of_year = date('Y-12-31', strtotime($input_year . '-12-31'));
             $where_po['date(penerimaan_header_date) <='] = change_format_date($last_date_of_year);
            $where_po['date(penerimaan_header_date) >='] = change_format_date($first_date_of_year);
            
            $where_so['date(b.timestamp) <='] = change_format_date($last_date_of_year);
            $where_so['date(b.timestamp) >='] = change_format_date($first_date_of_year);
            
            $where_sr['date(sales_return_header_date) <='] = change_format_date($last_date_of_year);
            $where_sr['date(sales_return_header_date) >='] = change_format_date($first_date_of_year);
            
            $where_pr['date(purchase_return_header_date) <='] = change_format_date($last_date_of_year);
            $where_pr['date(purchase_return_header_date) >='] = change_format_date($first_date_of_year);
            
            $where_st['date(stock_header_date) <='] = change_format_date($last_date_of_year);
            $where_st['date(stock_header_date) >='] = change_format_date($first_date_of_year);
	    }
		
		

        $lg_stock = 0;
		$md_stock = 0;
		$sm_stock = 0;
		

		$buy = $this->Penerimaan_model->purchaseorder_detail_advance($where_po)->result_array();
        $return_buy = $this->Purchase_returns_model->purchasereturn_detail_advance($where_pr)->result_array();
        $sell = $this->Sales_orders_model->salesorder_detail_advance($where_so,$order)->result_array();
        $return_sell = $this->Sales_returns_model->salesreturn_detail_advance($where_sr)->result_array();
        $adjust = $this->Stocks_model->stock_detail_advance($where_st)->result_array();
        $transfer = $this->Transfer_model->transfer_advance2($where_tr)->result_array();
        $item_data = $this->Items_model->get_data(array('item_id' => $item))->row_array();
        $mergedArray = array_merge($buy, $sell, $adjust,$return_sell,$return_buy,$transfer);
        // penerimaan_timestamp
        // sales_return_timestamp
        // stock_timestamp
        // transfer_timestamp
        function sortByDatetime($a, $b) {
            $dateFields = array(
                'penerimaan_timestamp',
                'timestamp_sales_order',
                'purchase_return_header_date',
                'sales_return_timestamp',
                'stock_timestamp',
                'transfer_timestamp'
            );
        
            $earliestDateA = null;
            $earliestDateB = null;
        
            foreach ($dateFields as $dateField) {
                if (!empty($a[$dateField])) {
                    $earliestDateA = $a[$dateField];
                    break; // take the first found
                }
            }
        
            foreach ($dateFields as $dateField) {
                if (!empty($b[$dateField])) {
                    $earliestDateB = $b[$dateField];
                    break; // take the first found
                }
            }
        
            // If your DB columns are DATETIME or TIMESTAMP,
            // this will include both date and time in sorting
            return strtotime($earliestDateA) <=> strtotime($earliestDateB);
        }

        
        usort($mergedArray, 'sortByDatetime');
        $total_large = 0;
        $total_medium = 0;
        $total_small = 0;
        $unit_large = 0;
        $unit_medium = 0;
        $unit_small = 0;
        $item_name = "";
        $no = 1;
        $total_masuk = 0;
        $total_keluar = 0;
        $no = 1;
        foreach($mergedArray as $get_row){
            $item_data2 = $this->Items_model->get_data(array('item_id' => $item))->row_array();
            
            $transaction_id = '';
            $transaction_status = '';
            $transaction_date	= '';
			$transaction_number	= '';
			$transaction_actor	= '';
			$in_large   = 0;
			$in_medium  = 0;
			$in_small   = 0;
			$out_large  =0;
			$out_medium = 0;
			$out_small  = 0;
			if (isset($get_row['penerimaan_detail_large_unit_quantity']) && $get_row['penerimaan_detail_large_unit_quantity'] != null || isset($get_row['penerimaan_detail_medium_unit_quantity']) && $get_row['penerimaan_detail_medium_unit_quantity'] != null || isset($get_row['penerimaan_detail_small_unit_quantity']) && $get_row['penerimaan_detail_small_unit_quantity'] != null) {
			    

			    $transaction_id = $get_row['penerimaan_detail_id'];
				$transaction_status = 'Beli';
				// $get_data_pembelian = $this->Pembelian_model->purchaseorder_header(array('pembelian_header_penerimaan_id' => $get_row['penerimaan_detail_header_id']), $order)->row();
				// if($get_data_pembelian){
				//     $transaction_number = $get_data_pembelian->pembelian_header_number;
				// }else{
				$transaction_number = $get_row['penerimaan_header_number'];
				// }
				$utcDate = $get_row['penerimaan_timestamp']; // example: "2025-09-26 08:30:00"

                // Create DateTime object in UTC
                $date = new DateTime($utcDate, new DateTimeZone('UTC'));
                
                // Convert to Asia/Jakarta (WIB)
                $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                
                // Get formatted date
                $transaction_date = $date->format('Y-m-d H:i:s');
				// $transaction_date	= $get_row['penerimaan_timestamp'];
				$transaction_actor  = $get_row['supplier_name'];
				$in_large  = $get_row['penerimaan_detail_large_unit_quantity'];
				$in_medium  =  $get_row['penerimaan_detail_medium_unit_quantity'];
				$in_small  =  $get_row['penerimaan_detail_small_unit_quantity'];

			} else if (isset($get_row['sales_order_detail_large_unit_quantity']) && $get_row['sales_order_detail_large_unit_quantity'] != null || isset($get_row['sales_order_detail_medium_unit_quantity']) && $get_row['sales_order_detail_medium_unit_quantity'] != null || isset($get_row['sales_order_detail_small_unit_quantity']) && $get_row['sales_order_detail_small_unit_quantity'] != null) {
                $transaction_id = $get_row['sales_order_detail_id'];
				$transaction_status = 'Jual';
				

				$transaction_number = $get_row['sales_order_header_number'];
				$utcDate = $get_row['timestamp_sales_order']; // example: "2025-09-26 08:30:00"

                // Create DateTime object in UTC
                $date = new DateTime($utcDate, new DateTimeZone('UTC'));
                
                // Convert to Asia/Jakarta (WIB)
                $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                
                // Get formatted date
                $transaction_date = $date->format('Y-m-d H:i:s');
				// $transaction_date	= $get_row['timestamp_sales_order'];
				$transaction_actor  = $get_row['customer_name'];
				$out_large  = $get_row['sales_order_detail_large_unit_quantity'];
				$out_medium  =  $get_row['sales_order_detail_medium_unit_quantity'];
				$out_small  =  $get_row['sales_order_detail_small_unit_quantity'];
				
			} else if (isset($get_row['purchase_return_detail_large_unit_quantity']) &&$get_row['purchase_return_detail_large_unit_quantity'] != null || isset($get_row['purchase_return_detail_medium_unit_quantity']) &&$get_row['purchase_return_detail_medium_unit_quantity'] != null || isset($get_row['purchase_return_detail_small_unit_quantity']) &&$get_row['purchase_return_detail_small_unit_quantity'] != null) {
                $transaction_id = $get_row['purchase_return_detail_id'];
				$transaction_status = 'Retur Beli';

				$transaction_number = $get_row['purchase_return_header_number'];
				$transaction_date	= $get_row['purchase_return_header_date'];
				$transaction_actor  = $get_row['supplier_name'];
				$out_large  = $get_row['purchase_return_detail_large_unit_quantity'];
				$out_medium  =  $get_row['purchase_return_detail_medium_unit_quantity'];
				$out_small  =  $get_row['purchase_return_detail_small_unit_quantity'];

			}
			else if (isset($get_row['sales_return_detail_large_unit_quantity']) &&$get_row['sales_return_detail_large_unit_quantity'] != null || isset($get_row['sales_return_detail_medium_unit_quantity']) &&$get_row['sales_return_detail_medium_unit_quantity'] != null || isset($get_row['sales_return_detail_small_unit_quantity']) &&$get_row['sales_return_detail_small_unit_quantity'] != null) {
                $transaction_id = $get_row['sales_return_detail_id'];
				$transaction_status = 'Retur Jual';
								
        
				$transaction_number = $get_row['sales_return_header_number'];
				// $transaction_date	= $get_row['sales_return_timestamp'];
				$utcDate = $get_row['sales_return_timestamp']; // example: "2025-09-26 08:30:00"

                // Create DateTime object in UTC
                $date = new DateTime($utcDate, new DateTimeZone('UTC'));
                
                // Convert to Asia/Jakarta (WIB)
                $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                
                // Get formatted date
                $transaction_date = $date->format('Y-m-d H:i:s');
				$transaction_actor  = $get_row['customer_name'];
				$in_large  = $get_row['sales_return_detail_large_unit_quantity'];
				$in_medium  =  $get_row['sales_return_detail_medium_unit_quantity'];
				$in_small  =  $get_row['sales_return_detail_small_unit_quantity'];

			}
            else if (isset($get_row['lg_qty']) &&$get_row['lg_qty'] != null) {
                

                $transaction_id = $get_row['detail_id'];
				$transaction_status = 'Transfer';
				$transaction_number = $get_row['transfer_header_number'];
				// $transaction_number = $get_row['sales_return_header_number'];
				// $transaction_date	= $get_row['sales_return_timestamp'];
				$utcDate = $get_row['transfer_timestamp']; // example: "2025-09-26 08:30:00"

                // Create DateTime object in UTC
                $date = new DateTime($utcDate, new DateTimeZone('UTC'));
                
                // Convert to Asia/Jakarta (WIB)
                $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                
                // Get formatted date
                $transaction_date = $date->format('Y-m-d H:i:s');
				// $transaction_date	= $get_row['transfer_timestamp'];
				$transaction_actor  = "Admin";
				if(isset($warehouse) && $warehouse != ''){
				    if($get_row['gudang_from'] == $warehouse){
    				    $out_large  = $get_row['lg_qty'];
    				}
    				if($get_row['gudang_to'] == $warehouse){
    				    $in_large  = $get_row['lg_qty'];
    				}
				}else{
				    $out_large  = 0;
				    $in_large  = 0;
				}
				
				
				// $out_medium  =  $get_row['purchase_return_detail_large_unit_quantity'];

			}
			else if (isset($get_row['stock_detail_large_unit_quantity']) && $get_row['stock_detail_large_unit_quantity'] != null || isset($get_row['stock_detail_medium_unit_quantity']) && $get_row['stock_detail_medium_unit_quantity'] != null || isset($get_row['stock_detail_small_unit_quantity']) && $get_row['stock_detail_small_unit_quantity'] != null) {
                $transaction_id = $get_row['stock_detail_id'];
				$transaction_status = 'Pengaturan Stok';
				$transaction_number = $get_row['stock_header_number'];
				$utcDate = $get_row['stock_timestamp']; // example: "2025-09-26 08:30:00"

                // Create DateTime object in UTC
                $date = new DateTime($utcDate, new DateTimeZone('UTC'));
                
                // Convert to Asia/Jakarta (WIB)
                $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                
                // Get formatted date
                $transaction_date = $date->format('Y-m-d H:i:s');
				// $transaction_date	=$get_row['stock_timestamp'];
				$transaction_actor  = '-';
				$in_large  = $get_row['stock_detail_large_unit_quantity'];
				$in_medium  =  $get_row['stock_detail_medium_unit_quantity'];
				$in_small  =  $get_row['stock_detail_small_unit_quantity'];

			}
			
			$unit_large +=  $in_large - $out_large;
			$unit_medium +=  $in_medium - $out_medium;
			$unit_small +=  $in_small - $out_small;
			
            if($transaction_number != ""){
                $therest      = $unit_large + $unit_medium + $unit_small;
                $total_large  = ($item_data['large_unit_contain'] == 0 ? '-' : floor($unit_large + $unit_medium + $unit_small / $item_data['large_unit_contain']));
                $therest      = ($therest - ($total_large * $item_data['large_unit_contain']));
                $total_medium = ($item_data['medium_unit_contain'] == 0 ? '-' : floor($therest / $item_data['medium_unit_contain']));
                $therest      = ($therest - ($total_medium * $item_data['medium_unit_contain']));
                $total_small  = ($item_data['small_unit_contain'] == 0 ? '-' : floor($therest / $item_data['small_unit_contain']));
                $data[] = array(
        			'no'                 => $no,
        			'log_id'             => $transaction_id,
        			// 'log_date'           => change_format_date($get_row->tms_log, 'd/m/Y'),
        			// 'log_date'           => $get_row->tms_log,
        			'log_date'           => $transaction_date,
        			'transaction_status' => $transaction_status,
        			'transaction_number' => $transaction_number,
        			'transaction_actor'  => $transaction_actor,
        			'in_large'           => ($in_large),
        			'in_medium'          => $in_medium,
        			'in_small'           => $in_small,
        			'out_large'          => ($out_large),
        			'out_medium'         => $out_medium,
        			'out_small'          => $out_small,
        			'large_unit'         => $total_large,
        			'medium_unit'        =>  $total_medium,
        			'small_unit'         => $total_small,
        		);
        		$total_masuk += round($in_large);
        		$total_keluar += round($out_large);
        		$no++;
            }
            
    
    		$lg_stock = $total_large;
    		$item_name = $get_row['item_name'];
    		$md_stock = $total_medium;
    		$sm_stock = $total_small;
        }
		
		

		$this->session->set_userdata('item', $item);
        // $item_data = $this->Items_model->get_data(array('item_id' => $item))->row_array();
        output_json($data);
// 		$response = [
// 			'data' => $data,
// 			'lg_stock' => $lg_stock,
// 			'md_stock' => $md_stock,
// 			'sm_stock' => $sm_stock,
// // 			'total_masuk' => $total_masuk,

// // 			'total_keluar' => $total_keluar,
// // 			'lg_stock_awal' => $item_data['stok_awal'],
// // 			'md_stock_awal' => $md_stock_awal,
// // 			'sm_stock_awal' => $sm_stock_awal,
//             'item_name' => $item_name,
// 			'array'     => $mergedArray
// 		];
// 		output_json($response);
	}

// 	public function get_data_detail_card()
// 	{	
// 		$item     = $this->input->post("item");
// 		$bulan = $this->input->post("val_bulan");
// 		$tahun = $this->input->post("val_tahun");
		
// 		$status = $this->input->post("status");

//         $data  = [];
//         $where = [];
// 		$order = ("a.timestamp ASC");

//         if(isset($item) && $item != '' && $item != '(Semua)')
// 		{
// 			$where['a.log_item_id'] = $item;
// 		}
// 		if(isset($status) && $status != '' && $status != '(Semua)')
// 		{
// 			$where['b.ppn_status'] = $status;
// 		}
// 		if(isset($bulan) && $bulan != '')
// 		{
// 		    // Input month name
            
//             if(isset($tahun) && $tahun != '')
// 		    {
//     		    // Input month name
//                 $input_month = $bulan;
//                 $input_year = $tahun;
                
//                 $month_number = date('m', strtotime($input_month));
//                 $first_date_of_month = date('Y-m-01', strtotime($input_year . '-' . $month_number . '-01'));
//                 $last_date_of_month = date('Y-m-t', strtotime($input_year . '-' . $month_number . '-01'));
//                 // echo change_format_date($first_date_of_month)."-".change_format_date($last_date_of_month);
//     			$where['date(a.timestamp) <='] = change_format_date($last_date_of_month);
//     			$where['date(a.timestamp) >='] = change_format_date($first_date_of_month);
// 		    }else{
// 		        $input_month = $bulan;
//                 $month_number = date('m', strtotime($input_month));
//                 $first_date_of_month = date('Y-m-01', strtotime(date('Y') . '-' . $month_number . '-01'));
//                 $last_date_of_month = date('Y-m-t', strtotime(date('Y') . '-' . $month_number . '-01'));
//                 // echo change_format_date($first_date_of_month)."-".change_format_date($last_date_of_month);
//     			$where['date(a.timestamp) <='] = change_format_date($last_date_of_month);
//     			$where['date(a.timestamp) >='] = change_format_date($first_date_of_month);
// 		    }
            
            
// 		}
// 		if(isset($tahun) && $tahun != '')
// 	    {

//             $input_year = $tahun;
            
//             $first_date_of_year = date('Y-01-01', strtotime($input_year . '-01-01'));

//             // Get the last date of the year
//             $last_date_of_year = date('Y-12-31', strtotime($input_year . '-12-31'));
//             $where['date(a.timestamp) <='] = change_format_date($last_date_of_year);
// 			$where['date(a.timestamp) >='] = change_format_date($first_date_of_year);
// 	    }
		

// 		$get_data = $this->Logs_model->get_data_advance($where, $order)->result();

// 		// echo json_encode();
// 		// die();

// 		// ketika data tersedia
// 		// maka generate data json untuk Datatable
// 		if($get_data)
// 		{
// 			$no = 1;
// 			foreach($get_data as $get_row)
// 			{	
// 				$transaction_status = '';
// 				$transaction_number	= '';
// 				$transaction_actor	= '';
// 				$in_large   = '-';
// 				$in_medium  = '-';
// 				$in_small   = '-';
// 				$out_large  = '-';
// 				$out_medium = '-';
// 				$out_small  = '-';
// 				if($get_row->log_type == 'PNBUY'){

// 					$transaction_status = 'Penerimaan';
// 					$transaction_number = $get_row->penerimaan_header_number;
// 					$transaction_actor  = $get_row->supplier_name;
// 					$in_large  = $get_row->log_large_unit_quantity;
// 					$in_medium = $get_row->log_medium_unit_quantity;
// 					$in_small  = $get_row->log_small_unit_quantity;

// 				}elseif($get_row->log_type == 'SELL'){

// 					$transaction_status = 'Jual';
// 					$transaction_number = $get_row->sales_order_header_number;
// 					$transaction_actor  = $get_row->customer_name;
// 					$out_large  = $get_row->log_large_unit_quantity;
// 					$out_medium = $get_row->log_medium_unit_quantity;
// 					$out_small  = $get_row->log_small_unit_quantity;

// 				}elseif($get_row->log_type == 'R-BUY'){

// 					$transaction_status = 'Retur Beli';
// 					$transaction_number = $get_row->purchase_return_header_number;
// 					$transaction_actor  = $get_row->supplier_name;
// 					$out_large  = $get_row->log_large_unit_quantity;
// 					$out_medium = $get_row->log_medium_unit_quantity;
// 					$out_small  = $get_row->log_small_unit_quantity;

// 				}elseif($get_row->log_type == 'R-SELL'){

// 					$transaction_status = 'Retur Jual';
// 					$transaction_number = $get_row->sales_return_header_number;
// 					$transaction_actor  = $get_row->customer_name;
// 					$in_large  = $get_row->log_large_unit_quantity;
// 					$in_medium = $get_row->log_medium_unit_quantity;
// 					$in_small  = $get_row->log_small_unit_quantity;

// 				}else if($get_row->log_type == 'STO'){

// 					$transaction_status = 'Pengaturan Stok';
// 					$transaction_number = $get_row->stock_header_number;
// 					$transaction_actor  = '-';
// 					$in_large  = $get_row->log_large_unit_quantity;
// 					$in_medium = $get_row->log_medium_unit_quantity;
// 					$in_small  = $get_row->log_small_unit_quantity;

// 				}
				
// 				if($get_row->log_type != 'BUY' && $get_row->log_type != 'PBUY'){
// 				    //Calculate 
//                     $therest      = $get_row->log_total_stock;
//                     $total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
//                     $therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
//                     $total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
//                     $therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
//                     $total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));
    				
//     				$data[] = array(
//     					'no'                 => $no,
//     					'log_id'             => $get_row->log_id,
//     					'log_date'           => change_format_date($get_row->tms_log, 'd/m/Y'),
//     					'transaction_status' => $transaction_status,
//     					'transaction_number' => $transaction_number,
//     					'transaction_actor'  => $transaction_actor,
//     					'in_large'           => $in_large,
//     					'in_medium'          => $in_medium,
//     					'in_small'           => $in_small,
//     					'out_large'          => $out_large,
//     					'out_medium'         => $out_medium,
//     					'out_small'          => $out_small,
//     					'large_unit'         => $total_large,
//     					'medium_unit'        => $total_medium,
//     					'small_unit'         => $total_small,
//     				// 	'tes' => $first_date_of_month,
//     					'is_hold'			 => ($get_row->is_hold == 1 ? 'bg-warning' : '')
//     				);
//                     $no++;
// 				}

				
                
// 			}
// 		}
// 		$this->session->set_userdata('item', $item);
// 		$this->session->set_userdata('status', $status);
// // 		$this->session->set_userdata('date_log', $date_log);

// 		output_json($data);
// 	}

	public function get_data_detail_recap()
	{	
		$item     = $this->input->post("item");
		$group    = $this->input->post("group");
		$status    = $this->input->post("status");
		$stock    = $this->input->post("stock");
		$date_log = $this->input->post("date_log");

        $data  = [];
        $where = [];
        $where_timestamp = date_now();

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
		}
		if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['b.item_group_id'] = $group;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where_timestamp = change_format_date($date_log);
		}
		if(isset($stock) && $stock != '' && $stock != '(Semua)')
		{
			if($stock == '1'){
				$where['a.log_total_stock >'] = '0';
			}else{
				$where['a.log_total_stock <='] = '0';
			}
		}

		
		
		$get_data = $this->Logs_model->get_data_detail_recap2($where, $where_timestamp)->result();
		$total = 0;
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	

				$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
				$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
				$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

				$unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");

				//Calculate 
                $therest      = $get_row->log_total_stock;
                $total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
                $therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
                $total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
                $therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
                $total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));

                $avg_large  = ($get_row->log_large_unit_contain == 0 ? '-' : number_format($get_row->log_average_large_unit));
                $avg_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : number_format($get_row->log_average_medium_unit));
                $avg_small  = ($get_row->log_small_unit_contain == 0 ? '-' : number_format($get_row->log_average_small_unit));

                $lg_unit = $total_large  ." ". $get_row->log_large_unit;
                $md_unit = $total_medium ." ". $get_row->log_medium_unit;
                $sm_unit = $total_small  ." ". $get_row->log_small_unit;
				$data[] = array(
					'no'                  => $no,
					'log_id'              => $get_row->log_id,
					'item_name'           => $get_row->item_name,
					'unit_contain'        => $unit_contain,
					'group_name'          => $get_row->group_name,
					'large_unit'          => $total_large,
					'medium_unit'         => $total_medium,
					'small_unit'          => $total_small,
					'average_large_unit'  => $avg_large,
					'average_medium_unit' => $avg_medium,
					'average_small_unit'  => $avg_small,
					'total_value'         => number_format($get_row->log_total_stock_value)
				);
                $no++;
                $total += $get_row->log_total_stock_value;
			}
		}
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('group', $group);
		$this->session->set_userdata('status', $status);
		$this->session->set_userdata('date_log', $date_log);
		$this->session->set_userdata('total', $total);

		$response = [
			'data'  => $data,
			'total' => number_format($total)
		];

		output_json($response);
	}

	// public function get_data_detail_recap_warehouse()
	// {	
	// 	$item      = $this->input->post("item");
	// 	$group     = $this->input->post("group");
	// 	$status    = $this->input->post("status");
	// 	$stock     = $this->input->post("stock");
	// 	$warehouse = $this->input->post("warehouse");
	// 	$date_log  = $this->input->post("date_log");

    //     $data  = [];
    //     $where = [];
    //     $where_timestamp = date_now();

    //     if(isset($item) && $item != '' && $item != '(Semua)')
	// 	{
	// 		$where['a.log_item_id'] = $item;
	// 	}
	// 	if(isset($group) && $group != '' && $group != '(Semua)')
	// 	{
	// 		$where['b.item_group_id'] = $group;
	// 	}
	// 	if(isset($status) && $status != '' && $status != '(Semua)')
	// 	{
	// 		$where['b.ppn_status'] = $status;
	// 	}
	// 	if(isset($date_log) && $date_log != '')
	// 	{
	// 		$where_timestamp = change_format_date($date_log);
	// 	}
	// 	if(isset($stock) && $stock != '' && $stock != '(Semua)')
	// 	{
	// 		if($stock == '1'){
	// 			$where['a.log_total_stock >'] = '0';
	// 		}else{
	// 			$where['a.log_total_stock <='] = '0';
	// 		}
	// 	}	
		
	// 	$get_data = $this->Transfer_model->transfer_advance('','', true)->result();
		
	// 	$total = 0;
	// 	// ketika data tersedia
	// 	// maka generate data json untuk Datatable
	// 	if($get_data)
	// 	{
	// 		$no = 1;
	// 		foreach($get_data as $get_row)
	// 		{	

	// 			$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
	// 			$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
	// 			$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

	// 			$unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");

	// 			//Calculate 

	// 			$in_stock = 0;
	// 			$ou_stock = 0;
	// 			$total_stock = 0;

	// 			// $warehouse = $this->Warehouses_model->get_data(array('is_default' => 1))->row()->warehouse_id;

	// 			$get_stock_in = $this->Transfer_model->transfer_advance(array('header_to' => $get_row->header_to, 'item_id' => $get_row->item_id), 'item_id, header_to')->row();
	// 			$get_stock_ou = $this->Transfer_model->transfer_advance(array('header_from' => $get_row->header_from, 'item_id' => $get_row->item_id), 'item_id, header_from')->row();

	// 			if($get_stock_in){
	// 				$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
	// 			}

	// 			if($get_stock_ou){
	// 				$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
	// 			}

	// 			$total_stock = $ou_stock;


	// 			// echo json_encode($total_stock);
				
	// 			// $total_stock = (($get_row->large_qty * $get_row->large_unit_contain) + ($get_row->medium_qty * $get_row->medium_unit_contain) + ($get_row->small_qty * $get_row->small_unit_contain));

    //             $therest      = $total_stock;
    //             $total_large  = ($get_row->large_unit_contain == 0 ? '-' : floor($total_stock / $get_row->large_unit_contain));
    //             $therest      = ($therest - ($total_large * $get_row->large_unit_contain));
    //             $total_medium = ($get_row->medium_unit_contain == 0 ? '-' : floor($therest / $get_row->medium_unit_contain));
    //             $therest      = ($therest - ($total_medium * $get_row->medium_unit_contain));
    //             $total_small  = ($get_row->small_unit_contain == 0 ? '-' : floor($therest / $get_row->small_unit_contain));

    //             $lg_unit = $total_large  ." ". $get_row->large_unit;
    //             $md_unit = $total_medium ." ". $get_row->medium_unit;
    //             $sm_unit = $total_small  ." ". $get_row->small_unit;
	// 			$data[] = array(
	// 				'no'                  => $no,
	// 				'log_id'              => 1,
	// 				'item_name'           => $get_row->item_name,
	// 				'unit_contain'        => $unit_contain,
	// 				'group_name'          => $this->Groups_model->get_data(array('group_id' => $get_row->item_group_id))->row()->group_name,
	// 				'warehouse_name'      => $this->Warehouses_model->get_data(array('warehouse_id' => $get_row->header_to))->row()->warehouse_name,
	// 				'large_unit'          => $total_large,
	// 				'medium_unit'         => $total_medium,
	// 				'small_unit'          => $total_small,
	// 				// 'average_large_unit'  => $avg_large,
	// 				// 'average_medium_unit' => $avg_medium,
	// 				// 'average_small_unit'  => $avg_small,
	// 				// 'total_value'         => number_format($get_row->log_total_stock_value)
	// 			);
    //             $no++;
    //             // $total += $get_row->log_total_stock_value;
	// 		}
	// 	}
	// 	$this->session->set_userdata('item', $item);
	// 	$this->session->set_userdata('group', $group);
	// 	$this->session->set_userdata('status', $status);
	// 	$this->session->set_userdata('date_log', $date_log);
	// 	// $this->session->set_userdata('total', $total);

	// 	$response = [
	// 		'data'  => $data,
	// 		// 'total' => number_format($total)
	// 	];

	// 	output_json($response);
	// }

	public function get_data_detail_recap_warehouse()
	{	
		$item     = $this->input->post("item");
		$group    = $this->input->post("group");
		$status   = $this->input->post("status");
		$stock    = $this->input->post("stock");
		$date_log = $this->input->post("date_log");
// 		$warehouse = $this->input->post("warehouse");

        $data  = [];
        // $where = [];
        $where_warehouse = [];
        $where_timestamp = date_now();

        $filters = [];

        if(isset($item) && $item != '' && $item != '(Semua)') {
        	$filters[] = "item_id = '{$item}'";
        }
        
        if(isset($group) && $group != '' && $group != '(Semua)') {
        	$filters[] = "item_group_id = '{$group}'";
        }
        
        if(isset($status) && $status != '' && $status != '(Semua)') {
        	$filters[] = "ppn_status = '{$status}'";
        }
        
        if(isset($stock) && $stock != '' && $stock != '(Semua)') {
        	if($stock == '1'){
        		$filters[] = "(stok_pos_gd1 > 0 OR stok_pos_gd2 > 0 OR stok_pos_gd3 > 0)";
        	} else if($stock == '2'){
        		$filters[] = "(stok_pos_gd1 = 0 OR stok_pos_gd2 = 0 OR stok_pos_gd3 = 0)";
        	} else if($stock == '3'){
        		$filters[] = "(stok_pos_gd1 < 0 OR stok_pos_gd2 < 0 OR stok_pos_gd3 < 0)";
        	}
        }
        $where = implode(' AND ', $filters);
// 		if(isset($warehouse) && $warehouse != '')
// 		{
// 			$where_warehouse['warehouse_id'] = $warehouse;
// 		}

		
		$updateStock = $this->Items_model->updateStock();
                
                $updateStockGd1 = $this->Items_model->updateStockGd1();
                $updateStockGd2 = $this->Items_model->updateStockGd2();
                $updateStockGd3 = $this->Items_model->updateStockGd3();
		$get_data = $this->Items_model->get_data($where)->result();
		$total = 0;
		$totalGd1 = 0;
		$totalGd2 = 0;
		$totalGd3 = 0;
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			// $no = 1;	

			foreach($get_data as $value)
			{	
				// $where['penerimaan_header_warehouse_id'] = $value->warehouse_id;
				$lg_unit = ($value->large_unit_contain == "0.00" ? "" : to_decimal($value->large_unit_contain));
				$md_unit = ($value->medium_unit_contain == "0.00" ? "" : to_decimal($value->medium_unit_contain));
				$sm_unit = ($value->small_unit_contain == "0.00" ? "" : to_decimal($value->small_unit_contain));

				$unit_contain = rtrim($value->large_unit." ".$lg_unit.", ".$value->medium_unit." ".$md_unit.", ".$value->small_unit." ".$sm_unit, ", ");

				$data[] = array(
				// 	'number_length' => count($gdata_detail),
					'item_name'     => $value->item_name,
					'unit_contain'    => $unit_contain,
					'large_unit'    => $value->stok_pos,
					'medium_unit'    => $value->stok_pos_sedang,
					'total' => number_format($value->stok_pos * $value->last_purchase_price_large_unit + $value->stok_pos_sedang * $value->last_purchase_price_medium_unit),
					'large_unit_gd_1'    => $value->stok_pos_gd1,
					'medium_unit_gd_1'    => $value->stok_pos_sedang_gd1,
					'total_gd_1' => number_format($value->stok_pos_gd1 * $value->last_purchase_price_large_unit + $value->stok_pos_sedang_gd1 * $value->last_purchase_price_medium_unit),
					'large_unit_gd_2'    => $value->stok_pos_gd2,
					'medium_unit_gd_2'    => $value->stok_pos_sedang_gd2,
					'total_gd_2' => number_format($value->stok_pos_gd2 * $value->last_purchase_price_large_unit + $value->stok_pos_sedang_gd2 * $value->last_purchase_price_medium_unit),
					'large_unit_gd_3'    => $value->stok_pos_gd3,
					'medium_unit_gd_3'    => $value->stok_pos_sedang_gd3,
					'total_gd_3' => number_format($value->stok_pos_gd3 * $value->last_purchase_price_large_unit + $value->stok_pos_sedang_gd3 * $value->last_purchase_price_medium_unit),
				);
				$totalGd1 += $value->stok_pos_gd1 * $value->last_purchase_price_large_unit ;
                $totalGd2 += $value->stok_pos_gd2 * $value->last_purchase_price_large_unit + $value->stok_pos_sedang_gd2 * $value->last_purchase_price_medium_unit;
                $totalGd3 += $value->stok_pos_gd3 * $value->last_purchase_price_large_unit + $value->stok_pos_sedang_gd3 * $value->last_purchase_price_medium_unit;
                $total    += $value->stok_pos * $value->last_purchase_price_large_unit + $value->stok_pos_sedang * $value->last_purchase_price_medium_unit;
			
				
				

			}

		}
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('group', $group);
		$this->session->set_userdata('status', $status);
		$this->session->set_userdata('date_log', $date_log);
		$this->session->set_userdata('total', $total);

		$response = [
			'data'  => $data,
			'total' => number_format($total),
			'totalGd1' => number_format($totalGd1),
			'totalGd2' => number_format($totalGd2),
			'totalGd3' => number_format($totalGd3)
		];

		// echo json_encode($data);
		// die();

		output_json($response);
	}

	public function export_excel_card() {

		$item     = $this->session->userdata('item');
		$date_log = $this->session->userdata('date_log');
		$status = $this->session->userdata('status');

		$data  = [];
        $where = [];
		$order = ("a.log_id ASC");

		$item_name  = '-';
		$date_text = ($date_log == '' ? '-' : change_format_date($date_log, 'd/m/Y'));

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}

		$get_data = $this->Logs_model->get_data_advance($where, $order)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("KARTU STOK")
							   ->setSubject("KARTU STOK")
							   ->setDescription("KARTU STOK")
							   ->setKeywords("KARTU STOK");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Kartu Stok");
	    $excel->getActiveSheet()->mergeCells('A1:M1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$date_text);
		
		$excel->getActiveSheet()->mergeCells('A6:A7');
		$excel->getActiveSheet()->mergeCells('B6:B7');
		$excel->getActiveSheet()->mergeCells('C6:C7');
		$excel->getActiveSheet()->mergeCells('D6:D7');

		$excel->getActiveSheet()->mergeCells('E6:G6');
		$excel->getActiveSheet()->mergeCells('H6:J6');
		$excel->getActiveSheet()->mergeCells('K6:M6');

		
	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Status");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "No. Transaksi");
		$excel->setActiveSheetIndex(0)->setCellValue('D6', "Supplier/Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Pemasukan");
		$excel->setActiveSheetIndex(0)->setCellValue('H6', "Pengeluaran");
		$excel->setActiveSheetIndex(0)->setCellValue('K6', "Stok");
		
		$excel->setActiveSheetIndex(0)->setCellValue('E7', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('F7', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('G7', "Kecil");
		$excel->setActiveSheetIndex(0)->setCellValue('H7', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('I7', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('J7', "Kecil");
		$excel->setActiveSheetIndex(0)->setCellValue('K7', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('L7', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('M7', "Kecil");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6:A7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6:B7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6:C7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D6:D7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E6:G6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H6:J6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K6:M6')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('E7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('M7')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 8; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$transaction_status = '';
				$transaction_number	= '';
				$transaction_actor	= '';
				$in_large   = '-';
				$in_medium  = '-';
				$in_small   = '-';
				$out_large  = '-';
				$out_medium = '-';
				$out_small  = '-';
				if($get_row->log_type == 'BUY'){

					$transaction_status = 'Beli';
					$transaction_number = $get_row->purchase_order_header_number;
					$transaction_actor  = $get_row->supplier_name;
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'SELL'){

					$transaction_status = 'Jual';
					$transaction_number = $get_row->sales_order_header_number;
					$transaction_actor  = $get_row->customer_name;
					$out_large  = $get_row->log_large_unit_quantity;
					$out_medium = $get_row->log_medium_unit_quantity;
					$out_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'R-BUY'){

					$transaction_status = 'Retur Beli';
					$transaction_number = $get_row->purchase_return_header_number;
					$transaction_actor  = $get_row->supplier_name;
					$out_large  = $get_row->log_large_unit_quantity;
					$out_medium = $get_row->log_medium_unit_quantity;
					$out_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'R-SELL'){

					$transaction_status = 'Retur Jual';
					$transaction_number = $get_row->sales_return_header_number;
					$transaction_actor  = $get_row->customer_name;
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}else{

					$transaction_status = 'Pengaturan Stok';
					$transaction_number = $get_row->stock_header_number;
					$transaction_actor  = '-';
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}

				//Calculate 
                $therest      = $get_row->log_total_stock;
                $total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
                $therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
                $total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
                $therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
                $total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));
				
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, change_format_date($get_row->tms_log, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $transaction_status);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $transaction_number);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $transaction_actor);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $in_large);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $in_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $in_small);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $out_large);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $out_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $out_small);
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $total_large);
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, $total_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, $total_small);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':M'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('A'.$numrow.':M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			if($get_row->is_hold == '1'){
				$excel->getActiveSheet()->getStyle('A'.$numrow.':M'.$numrow)->applyFromArray($style_row_warning);
			}
	      	$no++; // Tambah 1 setiap kali looping
			$numrow++; // Tambah 1 setiap kali looping
			  
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("KARTU STOK");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'KARTUSTOK_'.$item_name.'_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_excel_recap() {

        $item     = $this->session->userdata('item');
        $group    = $this->session->userdata('group');
        $status   = $this->session->userdata('status');
        $date_log = $this->session->userdata('date_log');
    
        $where = [];
        $item_name  = '-';
        $group_name = '-';
        $filters    = [];
    
        if(isset($item) && $item != '' && $item != '(Semua)') {
            $filters[] = "item_id = '{$item}'";
        }
        
        if(isset($group) && $group != '' && $group != '(Semua)') {
            $filters[] = "item_group_id = '{$group}'";
        }
        
        if(isset($status) && $status != '' && $status != '(Semua)') {
            $filters[] = "ppn_status = '{$status}'";
        }
        
        if(isset($stock) && $stock != '' && $stock != '(Semua)') {
            if($stock == '1'){
                $filters[] = "(stok_pos_gd1 > 0 OR stok_pos_gd2 > 0 OR stok_pos_gd3 > 0)";
            } else if($stock == '2'){
                $filters[] = "(stok_pos_gd1 = 0 OR stok_pos_gd2 = 0 OR stok_pos_gd3 = 0)";
            } else if($stock == '3'){
                $filters[] = "(stok_pos_gd1 < 0 OR stok_pos_gd2 < 0 OR stok_pos_gd3 < 0)";
            }
        }
        $where = implode(' AND ', $filters);
    
        // Update stock before export
        $this->Items_model->updateStock();
        $this->Items_model->updateStockGd1();
        $this->Items_model->updateStockGd2();
        $this->Items_model->updateStockGd3();
    
        $get_data = $this->Items_model->get_data($where)->result();
    
        $total    = 0;
        $totalGd1 = 0;
        $totalGd2 = 0;
        $totalGd3 = 0;
    
        // Load PHPExcel
        $excel = new PHPExcel();
        $excel->getProperties()->setCreator('TOKO TEST INDONESIA')
                               ->setLastModifiedBy('TOKO TEST INDONESIA')
                               ->setTitle("REKAP STOK")
                               ->setSubject("REKAP STOK")
                               ->setDescription("REKAP STOK")
                               ->setKeywords("REKAP STOK");
    
        // Styles
        $style_col = array(
            'font' => array('bold' => true),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER
            ),
            'borders' => array(
                'allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN)
            ),
            'fill' => array(
                'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'FFCC00')
            )
        );
    
        $style_row = array(
            'alignment' => array('vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER),
            'borders' => array(
                'allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN)
            )
        );
    
        $style_foo = array(
            'font' => array('bold' => true),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER
            ),
            'borders' => array(
                'allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN)
            ),
            'fill' => array(
                'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'FFCC00')
            )
        );
    
        // Title
        $excel->setActiveSheetIndex(0)->setCellValue('A1', "Rekap Stok");
        $excel->getActiveSheet()->mergeCells('A1:O1');
        $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
    
        // ================= HEADER =================
        $excel->getActiveSheet()->mergeCells('A7:A8');
        $excel->getActiveSheet()->mergeCells('B7:B8');
        $excel->getActiveSheet()->mergeCells('C7:C8');
    
        $excel->getActiveSheet()->mergeCells('D7:F7'); // Stok Gd 1
        $excel->getActiveSheet()->mergeCells('G7:I7'); // Stok Gd 2
        $excel->getActiveSheet()->mergeCells('J7:L7'); // Stok Gd 3
        $excel->getActiveSheet()->mergeCells('M7:O7'); // Stok
    
        $excel->setActiveSheetIndex(0)->setCellValue('A7', "Nama Barang");
        $excel->setActiveSheetIndex(0)->setCellValue('B7', "Satuan & Isi");
        $excel->setActiveSheetIndex(0)->setCellValue('C7', "Grup");
    
        $excel->setActiveSheetIndex(0)->setCellValue('D7', "Stok Gd 1");
        $excel->setActiveSheetIndex(0)->setCellValue('G7', "Stok Gd 2");
        $excel->setActiveSheetIndex(0)->setCellValue('J7', "Stok Gd 3");
        $excel->setActiveSheetIndex(0)->setCellValue('M7', "Stok");
    
        // Second header row
        $excel->setActiveSheetIndex(0)->setCellValue('D8', "Besar");
        $excel->setActiveSheetIndex(0)->setCellValue('E8', "Sedang");
        $excel->setActiveSheetIndex(0)->setCellValue('F8', "Total");
    
        $excel->setActiveSheetIndex(0)->setCellValue('G8', "Besar");
        $excel->setActiveSheetIndex(0)->setCellValue('H8', "Sedang");
        $excel->setActiveSheetIndex(0)->setCellValue('I8', "Total");
    
        $excel->setActiveSheetIndex(0)->setCellValue('J8', "Besar");
        $excel->setActiveSheetIndex(0)->setCellValue('K8', "Sedang");
        $excel->setActiveSheetIndex(0)->setCellValue('L8', "Total");
    
        $excel->setActiveSheetIndex(0)->setCellValue('M8', "Besar");
        $excel->setActiveSheetIndex(0)->setCellValue('N8', "Sedang");
        $excel->setActiveSheetIndex(0)->setCellValue('O8', "Total");
    
        $excel->getActiveSheet()->getStyle('A7:O8')->applyFromArray($style_col);
    
        // ================= DATA =================
        $numrow = 9;
        foreach($get_data as $get_row){
    	    $lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
			$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
			$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

            $unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");
            $excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->item_name);
            $excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $unit_contain);
            $excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, "");
    
            // Gd 1
            $excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->stok_pos_gd1);
            $excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->stok_pos_sedang_gd1);
            $excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, number_format($get_row->stok_pos_gd1 * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang_gd1 * $get_row->last_purchase_price_medium_unit));
    
            // Gd 2
            $excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->stok_pos_gd2);
            $excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $get_row->stok_pos_sedang_gd2);
            $excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, number_format($get_row->stok_pos_gd2 * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang_gd2 * $get_row->last_purchase_price_medium_unit));
    
            // Gd 3
            $excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $get_row->stok_pos_gd3);
            $excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $get_row->stok_pos_sedang_gd3);
            $excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, number_format($get_row->stok_pos_gd3 * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang_gd3 * $get_row->last_purchase_price_medium_unit));
    
            // Total
            $excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, $get_row->stok_pos);
            $excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, $get_row->stok_pos_sedang);
            $excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, number_format($get_row->stok_pos * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang * $get_row->last_purchase_price_medium_unit));
    
            $excel->getActiveSheet()->getStyle('A'.$numrow.':O'.$numrow)->applyFromArray($style_row);
    
            // Running totals
            $totalGd1 += $get_row->stok_pos_gd1 * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang_gd1 * $get_row->last_purchase_price_medium_unit;
            $totalGd2 += $get_row->stok_pos_gd2 * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang_gd2 * $get_row->last_purchase_price_medium_unit;
            $totalGd3 += $get_row->stok_pos_gd3 * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang_gd3 * $get_row->last_purchase_price_medium_unit;
            $total    += $get_row->stok_pos * $get_row->last_purchase_price_large_unit + $get_row->stok_pos_sedang * $get_row->last_purchase_price_medium_unit;
    
            $numrow++;
        }
    
        // ================= FOOTER =================
        $excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, "Grand Total");
        $excel->getActiveSheet()->mergeCells('A'.$numrow.':C'.$numrow);
    
        $excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, number_format($totalGd1));
        $excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, number_format($totalGd2));
        $excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, number_format($totalGd3));
        $excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, number_format($total));
    
        $excel->getActiveSheet()->getStyle('A'.$numrow.':O'.$numrow)->applyFromArray($style_foo);
    
        // Column width
        foreach(range('A','O') as $col){
            $excel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }
    
        $excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
        $excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $excel->getActiveSheet(0)->setTitle("REKAP STOK");
        $excel->setActiveSheetIndex(0);
    
        // Output file
        $date_now = change_format_date(date_now(), 'Ymd');
        $filename = 'REKAPSTOK_'.$date_now.'.xlsx';
    
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'.$filename.'"');
        header('Cache-Control: max-age=0');
        $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $write->save('php://output');
    }


}

?>
