
<?php
/**
 * Report Credits Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class UbahHarga extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Ubah Harga';
        $data['group_data']       = $this->Groups_model->get_data()->result();
		
		$this->twiggy_display('adm/ubah_harga/index', $data);
	}

	public function get_data_detail()
	{	
		$group = $this->input->post("group");
		$mulai = $this->input->post("mulai");
// 		$fromdate = $this->input->post("fromdate");
// 		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("item_name ASC");

        if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['item_group_id'] = $group;
		}
	
		
		$get_data = $this->Items_model->get_data_ubah($where,$mulai)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
			    $lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
				$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
				$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));
			    $unit = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");
			
				$data[] = array(
					'no'           => $no,
					'id' => $get_row->item_id,
					'nama' => $get_row->item_name,
					'grup'          => $get_row->group_name,
					'grup_child'    => $get_row->group_child_name,
					'harga_beli'    => number_format($get_row->last_purchase_price_large_unit),
					'harga_jual'    => number_format($get_row->last_selling_price_large_unit),
					'unit'          => $unit,
					'is_updated' => 0

				);
                $no++;
                
			}
		}
		$this->session->set_userdata('group', $group);
// 		$this->session->set_userdata('fromdate', $fromdate);
// 		$this->session->set_userdata('todate', $todate);

		output_json($data);
	}
	
	public function save()
	{
		
		$detail_data = [];
		$vuedata = $this->input->post('vuedata');

		if ($vuedata) {

// 			$get_last_data = $this->Presensi_model->get_presensi_header('', 'id desc')->row();

// 			$delete_detail  = $this->Presensi_model->delete_detail($get_last_data->id);
			
// 			if ($delete_detail) {

				foreach ($vuedata as $row) {
                    if($row['is_updated'] == 1){
                        $detail_data = [
    						'last_purchase_price_large_unit' 				=> trims($row['harga_beli']),
    						'last_selling_price_large_unit' 				=> trims($row['harga_jual']),
    						
    					];
    					$save_detail = $this->Items_model->update($row['id'],$detail_data);
                    }
					

				}

				

				if ($save_detail) {
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				} else {
					$msg    = "Gagal menyimpan data #CKP-U01";
					$status = "error";
				}
					
// 			} else {
// 				$msg    = "Gagal menyimpan data";
// 				$status = "error";
// 			}
			
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => 200
		];
		output_json($response);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order    = ("sales_order_header_number ASC");
		$customer_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_order_header_date <='] = change_format_date($todate);
		}

		$where['status_paid'] = 0;
		
		$get_data = $this->Sales_orders_model->salesorder_header($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PIUTANG")
							   ->setSubject("PIUTANG")
							   ->setDescription("PIUTANG")
							   ->setKeywords("PIUTANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Piutang");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$fromdate_text." - ".$todate_text);

	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Nomor Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "Jatuh Tempo");
	    $excel->setActiveSheetIndex(0)->setCellValue('D6', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Total");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E6')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$where        = array('sales_order_header_id' => $get_row->sales_order_header_id);
			$return_total = 0;
			$return_data  = $this->Sales_returns_model->salesreturn_header($where)->row();
			if($return_data){
				$return_total = $return_data->sales_return_header_grand_total;
			}

			$sub_total = ($get_row->sales_order_header_grand_total - $get_row->sales_order_header_paid_total);
			$total     = ($sub_total - $return_total);

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->sales_order_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, change_format_date($get_row->sales_order_header_payment_due, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($total));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('E'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PIUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PIUTANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
