<?php
/**
 * Wasted Stocks Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Wasted_stocks extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Wasted_stocks_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Warehouses_model');
		$this->load->model('Materials_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Wasted Stock';
		
		$this->twiggy_display('adm/wasted_stocks/index', $data);

	}
	 
	public function get_data_header()
	{	
		$data = [];
		$get_data = $this->Wasted_stocks_model->wastedstock_header()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->wasted_stock_header_id,
					'number' => $get_row->wasted_stock_header_number,
					'date'   => indonesian_date($get_row->wasted_stock_header_date),
					'supplier'          => $get_row->supplier_name,
					'warehouse_branch'  => $get_row->warehouse_name. ' - ' .$get_row->branch_name,
					'description'       => $get_row->wasted_stock_header_description,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Wasted Stock";
		$header_data = array(null);

		$prefix  = "WS100";
		$datenow = date('Ym');
		$number_generator = $this->Wasted_stocks_model->wastedstock_autonumber();
		$autonumber = $prefix.$datenow.'-'.$number_generator;

		$date_text   = change_format_date(date_now(), 'd/m/Y');

	    if($id != 'new')
	    {
			$title       = "Edit Wasted Stock";
			$where       = array('wasted_stock_header_id' => $id);
			$header_data = $this->Wasted_stocks_model->wastedstock_header($where)->row_array();
			$autonumber  = $header_data['wasted_stock_header_number'];
			$date_text   = change_format_date($header_data['wasted_stock_header_date'], 'd/m/Y');
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['supplier_data']   = $this->Suppliers_model->get_data()->result();
		$data['warehouse_data']  = $this->Warehouses_model->get_data()->result();

		
		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;

		if(check_roles('1')){
			$this->twiggy_display('adm/wasted_stocks/edit', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");
		$where       = array('wasted_stock_detail_header_id' => $id);
		$order       = array('material_name' => 'asc');

		$data = [];
		$get_data = $this->Wasted_stocks_model->wastedstock_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->wasted_stok_detail_id,
					'detail_header_id' => $get_row->wasted_stok_detail_header_id,
					'id'               => $get_row->wasted_stok_detail_material_id,
					'code'             => $get_row->material_code,
					'name'             => $get_row->material_name,
					'unit_id'          => $get_row->wasted_stok_detail_unit_id,
					'unit'             => $get_row->unit_name,
					'quantity'         => $get_row->wasted_stok_detail_quantity,
					'remark'           => $get_row->wasted_stok_detail_remark,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Material';
		$this->twiggy_display('adm/wasted_stocks/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Materials_model->get_data_search($search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$data[] = array(
					'no'   => $no,
					'id'   => $get_row->material_id,
					'code' => $get_row->material_code,
					'name' => $get_row->material_name,
					'quantity' => $get_row->material_maxstock,
					'unit_id'  => $get_row->unit_id,
					'unit' => $get_row->unit_name,
					'btncolor' => '',
					'btnicon'  => '',
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		$id         = $this->input->post('id');
		$number     = $this->input->post("number");
		$date       = $this->input->post("date");
		$supplier   = $this->input->post("supplier");
		$warehouse  = $this->input->post("warehouse");
		$description  = $this->input->post("description");
		
		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;
		
		$header_data = [
			'wasted_stock_header_number'        => $number,
			'wasted_stock_header_date'          => change_format_date($date),
			'wasted_stock_header_supplier_id'   => $supplier,
			'wasted_stock_header_warehouse_id'  => $warehouse,
			'wasted_stock_header_description'   => $description
		];

		$detail_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Wasted_stocks_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'wasted_stock_detail_header_id'      => $header_id,
						'wasted_stock_detail_material_id'    => $row['id'],
						'wasted_stock_detail_material_name'  => $row['name'],
						'wasted_stock_detail_unit_id'        => $row['unit_id'],
						'wasted_stock_detail_quantity'       => $row['quantity'],
						'wasted_stock_detail_remark'         => $row['remark'],
					];
				}
				
				$save_detail = $this->Wasted_stocks_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
				
			$delete_detail = $this->Wasted_stocks_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Wasted_stocks_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'wasted_stock_detail_header_id'      => $header_id,
							'wasted_stock_detail_material_id'    => $row['id'],
							'wasted_stock_detail_material_name'  => $row['name'],
							'wasted_stock_detail_unit_id'        => $row['unit_id'],
							'wasted_stock_detail_quantity'       => $row['quantity'],
							'wasted_stock_detail_remark'         => $row['remark'],
						];
					}

					$save_detail = $this->Wasted_stocks_model->save_detail($detail_data, true);
					
					if($save_detail)
					{
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}

			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		
		foreach($id as $row)
		{	
			$delete_header = $this->Wasted_stocks_model->delete_header($row);
			
			if($delete_header){
				$delete_type = $this->Wasted_stocks_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{	
		$where_header = array('wasted_stock_header_id' => $id);
		$where_detail = array('wasted_stock_detail_header_id' => $id);

		$header = $this->Wasted_stocks_model->wastedstock_header($where_header)->row_array();
		$detail = $this->Wasted_stocks_model->wastedstock_detail($where_detail)->result();

		$data['content_title'] = 'Print Wasted Stock';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/wasted_stocks/print_out', $data);
	}

}

?>
