<?php

/**
 * Point Requirements Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Cash_out_model extends Model
{

	public function cash_out_autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(cash_out_headers.cash_out_header_number, 4) as serial_number', FALSE);
// 		$sql->where('MONTH(cash_out_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('cash_out_header_number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('cash_out_headers');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 0001;
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function cash_out_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('cash_out_headers a');
		$sql->join('master_accounts b', 'b.account_id = a.cash_out_header_account_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function cash_out_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('cash_out_details a');
		$sql->join('master_accounts b', 'b.account_id = a.cash_out_detail_account_id', 'inner');

// 		$sql->join('master_account_types c', 'c.account_type_id = b.account_type_id', 'inner');
		$sql->join('master_account_headers d', 'd.account_header_id = b.account_header_id', 'inner');

		$sql->join('master_account_header_childs e', 'e.account_header_child_id = b.account_header_child_id', 'inner');
		$sql->join('master_account_groups f', 'f.account_group_id = d.account_group_id', 'inner');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function cash_out_detail_advance($select_sum = false, $where = '', $order = '', $group_by = '')
	{
		$sql = $this->db;
		if ($select_sum) {
			$sql->select('*, coalesce(sum(cash_out_detail_debit),0) as ttl_debit, coalesce(sum(cash_out_detail_credit),0) as ttl_credit');
		} else {
			$sql->select('*');
		}
		$sql->from('cash_out_details a');
		$sql->join('cash_out_headers b', 'b.cash_out_header_id = a.cash_out_detail_header_id', 'left');
		$sql->join('master_accounts c', 'c.account_id = a.cash_out_detail_account_id', 'left');

// 		$sql->join('master_account_types d', 'd.account_type_id = c.account_type_id', 'inner');
		$sql->join('master_account_headers e', 'e.account_header_id = c.account_header_id', 'inner');

		$sql->join('master_account_header_childs f', 'f.account_header_child_id = c.account_header_child_id', 'inner');
		$sql->join('master_account_groups g', 'g.account_group_id = e.account_group_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function truncate_header()
	{
		return $this->db->empty_table("cash_out_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("cash_out_details");
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('cash_out_headers', $data);
		}

		return $this->db->insert('cash_out_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('cash_out_details', $data);
		}

		return $this->db->insert('cash_out_details', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('cash_out_header_id', $id);
		return $this->db->update('cash_out_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("cash_out_header_id", $id);
		return $this->db->delete("cash_out_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("cash_out_detail_header_id", $id);
		return $this->db->delete("cash_out_details");
	}

	public function delete_headerbytrxid($id, $type)
	{
		$this->db->where("cash_out_header_trx_id", $id);
		$this->db->where("cash_out_header_trx_type", $type);
		return $this->db->delete("cash_out_headers");
	}

	public function delete_detailbytrxid($id, $type)
	{
		$this->db->where("cash_out_detail_trx_id", $id);
		$this->db->where("cash_out_detail_trx_type", $type);
		return $this->db->delete("cash_out_details");
	}
}
