<?php

/**
 * Cash_transfers Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Cash_transfers_model extends Model
{
	public function cash_in_autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(cash_transfers.number, 4) as serial_number', FALSE);
		$sql->where('MONTH(date) = MONTH(CURRENT_DATE())');
		$sql->order_by('number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('cash_transfers');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 0001;
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*, b.account_name as from_name, c.account_name as to_name');
		$sql->from('cash_transfers a');
		$sql->join('master_accounts b', 'b.account_id = a.from_account_id', 'inner');
		$sql->join('master_accounts c', 'c.account_id = a.to_account_id', 'inner');

		$sql->order_by('date');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function truncate_header()
	{
		return $this->db->empty_table("cash_transfers");
	}

	public function save($data)
	{
		return $this->db->insert('cash_transfers', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('id', $id);
		return $this->db->update('cash_transfers', $data);
	}

	public function delete($id)
	{
		$this->db->where('id', $id);
		return $this->db->delete('cash_transfers');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('cash_transfers');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
