<?php

/**
 * Debts Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Debts_model extends Model
{

	public function debt_autonumber($supp_code)
	{
		$sql = $this->db;

		$sql->select('RIGHT(debt_headers.debt_header_number, 2) as serial_number', FALSE);
// 		$sql->where('MONTH(debt_header_date) = MONTH(CURRENT_DATE())');
		$sql->where('SUBSTR(debt_headers.debt_header_number, 4, 2) = "' . $supp_code . '"');
		$sql->order_by('debt_header_number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('debt_headers');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 01;
		}

		$serial_number_generate = str_pad($serial_number, 2, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function purchaseorder_headersearch($type = '', $supplier = '', $search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('pembelian_headers a');
		$sql->join('master_suppliers b', 'b.supplier_id = a.pembelian_header_supplier_id', 'inner');

		if ($search != '') {
		    $sql->group_start();
			$sql->like('pembelian_header_number', $search);
			$sql->or_like('pembelian_header_date', $search);
			$sql->group_end();
		}

		$sql->where('pembelian_header_supplier_id', $supplier);
		// $sql->where('status_paid', 0);
		$sql->order_by('pembelian_header_date asc');

		$get = $sql->get();

		return $get;
	}

	public function get_sum_retur($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(a.purchase_return_header_total_tunai) as total_retur');
		$sql->from('purchase_return_headers a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_sum_telah_bayar($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('a.*, b.debt_header_retur_id, SUM(a.debt_detail_bayar) as total_telah_bayar, SUM(a.debt_detail_discount_total) as total_disc');
		$sql->from('debt_details a');
		$sql->join('debt_headers b', 'b.debt_header_id = a.debt_detail_header_id', 'inner');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function debt_header_lite($where = '')
	{
		$sql = $this->db;

		$sql->select('debt_headers.debt_header_id as id');
		$sql->from('debt_headers');

		if ($where != '') {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function debt_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('debt_headers a');
		$sql->join('master_suppliers b', 'b.supplier_id = a.debt_header_supplier_id', 'inner');
		$sql->join('master_banks c', 'c.bank_id = a.debt_header_bank_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function debt_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('debt_details a');
		$sql->join('pembelian_headers b', 'b.pembelian_header_id = a.debt_detail_purchase_order_header_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function debt_detail_advanced($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('debt_details a');
		$sql->join('debt_headers b', 'b.debt_header_id = a.debt_detail_header_id', 'left');
		$sql->join('pembelian_headers c', 'c.pembelian_header_id = a.debt_detail_purchase_order_header_id', 'left');
		$sql->join('master_suppliers d', 'd.supplier_id = b.debt_header_supplier_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('debt_headers', $data);
		}

		return $this->db->insert('debt_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('debt_details', $data);
		}

		return $this->db->insert('debt_details', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('debt_header_id', $id);
		return $this->db->update('debt_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("debt_header_id", $id);
		return $this->db->delete("debt_headers");
	}

	public function delete_headerbyretur($id)
	{
		$this->db->where("debt_header_retur_id", $id);
		return $this->db->delete("debt_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("debt_detail_header_id", $id);
		return $this->db->delete("debt_details");
	}

	public function delete_byretur($id)
	{
		$this->db->where("debt_detail_header_id", $id);
		return $this->db->delete("debt_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("debt_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("debt_details");
	}
}
