/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/debts/print_out/',
        urlList: window.APP.siteUrl + 'adm/debts/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/debts/get_data_detail',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					paymentMethod: ''
				},
				methods: {
					detailAdd: function () {
						// show modal
						$(that.elModal).modal("show");
						$.ajax({
							url: that.urlList,
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								// var ii = $('.check-sub');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
                    },

					handleNumber: function () {
						var vue = this;

						var previousValue;
						$("#supplier-select").on('focus', function (e) {
							previousValue = this.value;
						}).change(function () {
							var storedPreviousValue = previousValue;
							vue.handleServiceNumber(this.value);

							if (vue.detailData.length > 0) {

								Swal.fire({
									title: 'Anda yakin ingin mengganti Supplier?',
									text: "Data item akan direset",
									type: 'warning',
									showCancelButton: true,
									confirmButtonColor: '#3085d6',
									cancelButtonColor: '#d33',
									confirmButtonText: 'Ya, Lanjut!',
									cancelButtonText: 'Batal'
								}).then((result) => {
									if (result.value) {
										vue.detailData.splice(0, vue.detailData.length);
										vue.handleServiceNumber(this.value);
									} else if (result.dismiss == 'cancel') {
										
										if (previousValue != undefined) {
											$("#supplier-select").val(storedPreviousValue).trigger('change.select2');
										}
										vue.handleServiceNumber(this.value);
										previousValue = storedPreviousValue;
									}
								})

							}

							previousValue = this.value;
						
						});
					},

					handleServiceNumber: function  (Event) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/debts/get_autonumber',
							dataType: "JSON",
							data: {
								id: Event
							},
							success: function (data) {
								$("#number").val(data);
							},
						});	
					},

					handleMethodPayment: function () {
						var vue = this;

						$("#payment-method-select").change(function (e) {
							var id = $(e.target).val();
							
							if(id == "Tunai/Lainnya"){
								vue.$set(vue, 'paymentMethod', "Tunai/Lainnya");
							}

							if(id == "Cek/Giro"){
								vue.$set(vue, 'paymentMethod', "Cek/Giro");
							}

							if(id == "Transfer Bank"){
								vue.$set(vue, 'paymentMethod', "Transfer Bank");
							}

							window.INPUT.handleSelect2();
						});
					},

					handleBayar: function(row, field_name, value) {
						var vue = this;

						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.$set(row, field_name, value);
						vue.handleCheckBayar(row, field_name, value);
						// }, 100);
					},

					handleCheckBayar: function(row, field_name, value) {
						var vue = this;

						let a = row.bayar.replace(/[^\w\s]/gi, '');
						let b = row.total.replace(/[^\w\s]/gi, '');
						let c = row.plus.replace(/[^\w\s]/gi, '');
						// console.log("bayar: " +parseInt(a));
						// console.log("total: " +parseInt(b));
						if((parseInt(a) + parseInt(c)) > parseInt(b)){
							toastr.warning('Pembayaran melebihi Total Hutang!');
							vue.$set(row, 'plus', 0);
							vue.$set(row, 'bayar', row.total);
							// console.log('Melebihi');
						}

						
						// console.log(value);
					},

					handleCount: function (row, field_name, value) {
						var vue = this;

						var discount = 0;

						total_paid = (row.sub_total.replace(/[^\w\s]/gi, '') - row.return_total.replace(/[^\w\s]/gi, ''))
						discount   = value.replace(/[^\w\s]/gi, '');
						total      = (total_paid - discount);
						vue.$set(row, field_name, value);
						vue.$set(row, 'total', total.toLocaleString("en-US"));
						vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
					},
					handlePlus: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						var plusVal = 0;
                        var total_bayar = 0;
						total_bayar = row.bayar.replace(/[^\w\s]/gi, '')
						plusVal   = value.replace(/[^\w\s]/gi, '');
						console.log(parseInt(total_bayar))
						console.log(parseInt(plusVal))
						total      = (parseInt(total_bayar) + parseInt(plusVal));
						console.log(total)
						vue.$set(row, field_name, value);
						vue.handleCheckBayar(row, field_name,value);
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].sub_total.replace(/,/g, ''));
						}

						return totalAmmount.toLocaleString("en-US");
					},

					countReturTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].return_total.replace(/,/g, ''));
						}

						return totalAmmount.toLocaleString("en-US");
					},

					countGrandTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}

						return totalAmmount.toLocaleString("en-US");
					},

					countBayarTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var plusAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].bayar.replace(/,/g, ''));
							if(items[i].plus != 0){
							    plusAmmount += parseFloat(items[i].plus.replace(/,/g, ''));
							}
							
							console.log(plusAmmount);
						}
                        var bayar_total = totalAmmount + plusAmmount;
                        console.log(plusAmmount);
						return bayar_total.toLocaleString("en-US");
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 1);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
				
                    if(id != 'new'){
						vue.handleData();
					}
					vue.handleNumber();
					vue.handleCheckbox();
					vue.handleMethodPayment();
					
					setTimeout(function () {
						that.handleForm();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
						var paymentMethod = $("#payment-method-select").val();
						vue.$set(vue, 'paymentMethod', paymentMethod);
						window.INPUT.handleSelect2();
					}, 500);
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						setTimeout(function () {
							// window.location.href = that.urlPrintOut +response.id
							window.location.href = window.APP.siteUrl + 'adm/debts/'
						}, 1500);
					}

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);