/**
 * Javascript Debts
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/debts/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Edit" target="_blank">' + data + '</a>';
	}

	var renderPrint = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/debts/print_out/' + full['id'];
        return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Print"><i class="fa fa-print btn btn-success btn-sm"></i></a>';
    }

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elTable: '#master-table',
		elBtnDelete: '.master-delete',
		elBtnFilter: '.master-filter',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		urlDeleteData: window.APP.siteUrl + 'adm/debts/delete',
		edit:false,
		urlRequestData: window.APP.siteUrl + 'adm/debts/get_data_header',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				methods: {
					addRowType: function () {
						var vue = this;
					},

				},
				mounted: function () {
					parentThis.handleDataTable();
				}
			});

		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},

		// Debts : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");
            var fromdate = $('#fromdate').val();
            var todate = $('#todate').val();
            console.log(fromdate);
            console.log(todate);
            if(parentThis.edit){
                console.log("Edit");
                $('.master-edit').removeAttr('style');
                $('.master-delete').removeAttr('style');
                parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					type: "POST",
					dataType: 'json',
					url: parentThis.urlRequestData,
					data: {
						fromdate: fromdate,
						todate: todate,
					},
				},
				columns: [{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'supplier',
					},
					{
						data: 'sub_total',
					},
					{
						data: 'return_total',
					},
					{
						data: 'grand_total',
					},
					{
						data: 'bayar_total',
					},
					// {
					// 	className: 'fit-width',
					// 	render: renderPrint
					// }
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleFilter();
					parentThis.checkPassword();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
            }else{
                $('.master-edit').attr('style','display:none');
                $('.master-delete').attr('style','display:none');
                parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					type: "POST",
					dataType: 'json',
					url: parentThis.urlRequestData,
					data: {
						fromdate: fromdate,
						todate: todate,
					},
				},
				columns: [{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
				// 		render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'supplier',
					},
					{
						data: 'sub_total',
					},
					{
						data: 'return_total',
					},
					{
						data: 'grand_total',
					},
					{
						data: 'bayar_total',
					},
					// {
					// 	className: 'fit-width',
					// 	render: renderPrint
					// }
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleFilter();
                    parentThis.checkPassword();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
            }
			
		},
		
		handleFilter: function () {
			var parentThis = this;

			$(parentThis.elBtnFilter).click(function () {
			 //   if ($.fn.DataTable.isDataTable(parentThis.elTable)) {
                    parentThis.elDatatable.destroy();
                // }
                parentThis.handleDataTable();
			});
		},

		// Debts : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},
		checkPassword: function () {
			var vue = this;
			$("#password").on("blur", function(e) {
			    var password = $(e.target).val();
                if(password == "kecapasin"){
			    vue.edit = true;
			    console.log(vue.edit)
			    vue.elDatatable.destroy();
                vue.handleDataTable();
                // vue.$set(vue, 'edit', true);
    			}else{
    			    vue.edit = false;
    			    console.log(vue.edit)
    			    vue.elDatatable.destroy();
                vue.handleDataTable();
    			 //   vue.$set(vue, 'edit', false);
    			}
            });
			
			
			
			
		},

	}

})(jQuery);