/**
 * Javascript Account Headers
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
	}

	var renderCheckboxChild = function (data, type, full, meta) {
		return '<input class="check-sub-child-master" type="checkbox" value="' + full['id'] + '">';
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/account_headers/edit/' + full['id'];
		return '<a href="' + url + '" class="master-edit btn btn-sm btn-warning" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click to Edit"><i class="far fa-edit"></i></a>';
	}

	var renderEditChild = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/account_headers/edit_child/' + full['id'];
		return '<a href="' + url + '" class="master-edit-child btn btn-sm btn-warning" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click to Edit"><i class="far fa-edit"></i></a>';
	}

	var renderText = function (data, type, full, meta) {
		return '<span class="text-child" id="text-child' + full['id'] + '">' + data + '</span>';
	}

	var renderChild = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/account_headers/edit/' + full['id'];
		return '<a href="#" class="master-child btn btn-sm btn-outline-info" id="master-child' + full['id'] + '" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click for Details"><i class="fas fa-indent"></i></a>';
	}

	return {

		elDatatable: null,
		elDatatableChild: null,
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elEditChild: '.master-edit-child',
		elChild: '.master-child',
		elTable: '#master-table',
		elTableChild: '#master-table-child',
		elModal: '.master-modal',
		elModalChild: '.master-modal-child',
		elBtnDelete: '.master-delete',
		elBtnDeleteChild: '.master-child-delete',
		elModalClose: '.master-cancel',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		elSubCheckboxChild: '.check-sub-child-master',
		elParentCheckboxChild: '.check-all-child-master',
		elModalContent: '.master-modal-content',
		elModalContentChild: '.master-modal-content-child',
		urlDeleteData: window.APP.siteUrl + 'adm/account_headers/delete',
		urlDeleteDataChild: window.APP.siteUrl + 'adm/account_headers/delete_child',
		urlRequestData: window.APP.siteUrl + 'adm/account_headers/get_data',
		urlRequestDataChild: window.APP.siteUrl + 'adm/account_headers/get_data_child',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			window.confApp = new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				data : {
					createUrl : ''
				},
				methods: {
					addRowType: function () {
						var vue = this;
					}
				},
				mounted: function () {
					parentThis.handleDataTable();
					parentThis.handleDataTableChild();
				}
			});

		},

		handleCheckboxParent: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},

		handleCheckboxChild: function () {
			var parentThis = this;

			$(parentThis.elTableChild).on("click", parentThis.elSubCheckboxChild, function () {
				var row     = ($('#master-table-child tr').length - 1);
				var checked = $('#master-table-child').find('input[class="check-sub-child-master"]:checked');

				if(row == checked.length){
					$('#check-all-child-master').prop('checked', true);
				}else{
					$('#check-all-child-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckboxChild).is(':checked')){
					$(parentThis.elSubCheckboxChild).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxChild).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckboxChild).is(':checked')){
					$(parentThis.elSubCheckboxChild).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxChild).prop('checked', false);
				}
			});

		},

		// Account Headers : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderText,
					},
					{
						data: 'name',
						render: renderText,
					},
					{
						data: 'group',
					},
					{
						data: 'name',
						className: 'fit-width',
						render: renderEdit,
					},
					{
						data: 'name',
						className: 'fit-width',
						render: renderChild,
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4,5],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM_ACCOUNT_HEADER.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatable
					);

					parentThis.handleDelete();
					parentThis.handleCheckboxParent();
					parentThis.handleCheckboxChild();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		handleDataTableChild: function () {
			var parentThis = this;
			
			$(parentThis.elTable).on("click", parentThis.elChild, function () {

				var id = $(this).attr('data-id');
				$(".master-child").removeClass('bg-info');
				$(".text-child").removeClass('text-info');
				$("#master-child" +id).addClass('bg-info');
				$("#text-child" +id).addClass('text-info');
				
				var vue = window.confApp;
				vue.$set(vue, 'createUrl', APP.siteUrl + 'adm/account_headers/edit_child/new/' +id);

				// Datatable
				$(parentThis.elTableChild).dataTable().fnDestroy();
				// $(parentThis.elTableChild).DataTable().clear().destroy();
				parentThis.elDatatableChild = $(parentThis.elTableChild).DataTable({
					ajax: {
						type: "POST",
						dataType: 'json',
						url: parentThis.urlRequestDataChild,
						data: {
							id: id,
						},
					},
					columns: [{
							data: 'no',
							width: '20',
							className: 'fit-width',
							render: renderCheckboxChild
						},
						{
							data: 'number',
						},
						{
							data: 'name',
						},
						{
							className: 'fit-width',
							render: renderEditChild,
						}
					],

					order: [],
					deferRender: true,
					scrollX: true,
					"columnDefs": [{
						"targets": [0,3],
						"orderable": false,
					}],
					"language": {
						"url": parentThis.urlBahasa,
						"sEmptyTable": "Tidads"
					},

					initComplete: function () {
						// handle form
						window.FORM_ACCOUNT_HEADER.handleEditModal(
							parentThis.elForm,
							parentThis.elEditChild,
							parentThis.elModalChild,
							parentThis.elModalContentChild,
							parentThis.elModalClose,
							parentThis.elDatatableChild
						);

						parentThis.handleDeleteChild();
						window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxChild, parentThis.elSubCheckboxChild);
					}

				});

			});

			$(parentThis.elTable).on("click", parentThis.elEdit, function () {

				var id = $(this).attr('data-id');
				$(".master-child").removeClass('bg-info');
				$(".text-child").removeClass('text-info');
				$("#master-child" +id).addClass('bg-info');
				$("#text-child" +id).addClass('text-info');
				
				var vue = window.confApp;
				vue.$set(vue, 'createUrl', APP.siteUrl + 'adm/account_headers/edit_child/new/' +id);

				// Datatable
				$(parentThis.elTableChild).dataTable().fnDestroy();
				// $(parentThis.elTableChild).DataTable().clear().destroy();
				parentThis.elDatatableChild = $(parentThis.elTableChild).DataTable({
					ajax: {
						type: "POST",
						dataType: 'json',
						url: parentThis.urlRequestDataChild,
						data: {
							id: id,
						},
					},
					columns: [{
							data: 'no',
							width: '20',
							className: 'fit-width',
							render: renderCheckboxChild
						},
						{
							data: 'number',
						},
						{
							data: 'name',
						},
						{
							className: 'fit-width',
							render: renderEditChild,
						},
					],

					order: [],
					deferRender: true,
					scrollX: true,
					"columnDefs": [{
						"targets": [0,3],
						"orderable": false,
					}],
					"language": {
						"url": parentThis.urlBahasa,
						"sEmptyTable": "Tidads"
					},

					initComplete: function () {
						// handle form
						window.FORM_ACCOUNT_HEADER.handleEditModal(
							parentThis.elForm,
							parentThis.elEditChild,
							parentThis.elModalChild,
							parentThis.elModalContentChild,
							parentThis.elModalClose,
							parentThis.elDatatableChild
						);

						parentThis.handleDeleteChild();
						window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxChild, parentThis.elSubCheckboxChild);
					}

				});

			});
			
		},

		// Account Headers : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM_ACCOUNT_HEADER.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();
									parentThis.elDatatableChild.ajax.reload();
									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

		handleDeleteChild: function () {
			var parentThis = this;

			$(parentThis.elBtnDeleteChild).click(function () {
				var Items = $(parentThis.elTableChild).find('input[class="check-sub-child-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteDataChild,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM_ACCOUNT_HEADER.showNotification(response.message, response.status);
									parentThis.elDatatableChild.ajax.reload();
									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

	}

})(jQuery);