/**
 * Javascript Accounts
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		// return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		// var checkbox = '';
		// if (full['so_data'] == false){
			checkbox = '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		// }
		return checkbox;
	}
	var renderCheckboxGrup = function (data, type, full, meta) {
		// return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		// var checkbox = '';
		// if (full['so_data'] == false){
			checkbox = '<input class="check-sub-master-group" type="checkbox" value="' + full['id'] + '">';
		// }
		return checkbox;
	}
	var renderCheckboxHeader = function (data, type, full, meta) {
		// return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		// var checkbox = '';
		// if (full['so_data'] == false){
			checkbox = '<input class="check-sub-master-header" type="checkbox" value="' + full['id'] + '">';
		// }
		return checkbox;
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/accounts/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Click to Edit">' + data + '</a>';
	}
	var renderEditGroup = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/account_groups/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Click to Edit">' + data + '</a>';
	}
	var renderEditHeader = function (data, type, full, meta) {
			var url = APP.siteUrl + 'adm/account_headers/edit/' + full['id'];
		return '<a href="' + url + '" class="master-edit btn btn-sm btn-warning" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click to Edit"><i class="far fa-edit"></i></a>';
	}
	var renderCheckboxChild = function (data, type, full, meta) {
		return '<input class="check-sub-child-master" type="checkbox" value="' + full['id'] + '">';
	}
	var renderEditChild = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/account_headers/edit_child/' + full['id'];
		return '<a href="' + url + '" class="master-edit-child btn btn-sm btn-warning" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click to Edit"><i class="far fa-edit"></i></a>';
	}
	var renderText = function (data, type, full, meta) {
		return '<span class="text-child" id="text-child' + full['id'] + '">' + data + '</span>';
	}
    var renderChild = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/account_headers/edit/' + full['id'];
		return '<a href="#" class="master-child btn btn-sm btn-outline-info" id="master-child' + full['id'] + '" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click for Details"><i class="fas fa-indent"></i></a>';
	}

	var renderPrice = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/special_prices/edit/' + full['id'];
		return '<a href="'+ url +'" class="btn btn-sm btn-warning" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click to Edit Special Prices"><i class="fas fa-tags"></i></a>';
	}

	return {

		elDatatable: null,
		elDatatableGroup: null,
		elDatatableHeader: null,
		elDatatableChild: null,
		
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elEditChild: '.master-edit-child',
		elChild: '.master-child',
		
		elTable: '#master-table',
		elTableChild: '#master-table-child',
		elTableHeader: '#master-table-header',
		elTableGrup: '#master-table-group',
		
		elModal: '.master-modal',
		
		elBtnDelete: '.master-delete',
		elBtnDeleteGroup: '.master-delete-group',
		elBtnDeleteHeader: '.master-delete-header',
		
		elModalClose: '.master-cancel',
		
		elSubCheckbox: '.check-sub-master',
		elSubCheckboxGroup: '.check-sub-master-group',
		elSubCheckboxHeader: '.check-all-master-header',
		elSubCheckboxChild: '.check-sub-child-master',
		elParentCheckbox: '.check-all-master',
		
		elParentCheckboxChild: '.check-all-child-master',
		elParentCheckboxGroup: '.check-all-master-group',
		elParentCheckboxHeader: '.check-all-master-header',
		
		elModalContent: '.master-modal-content',
		elModalContentChild: '.master-modal-content-child',
		
		urlDeleteData: window.APP.siteUrl + 'adm/accounts/delete',
		urlDeleteDataGroup: window.APP.siteUrl + 'adm/account_groups/delete',
		urlDeleteDataHeader: window.APP.siteUrl + 'adm/account_headers/delete',
		urlDeleteDataHeaderChild: window.APP.siteUrl + 'adm/account_headers/delete_child',
		
		urlRequestData: window.APP.siteUrl + 'adm/accounts/get_data',
		urlRequestGrup: window.APP.siteUrl + 'adm/account_groups/get_data',
		urlRequestHeader: window.APP.siteUrl + 'adm/account_headers/get_data',
		urlRequestHeaderChild: window.APP.siteUrl + 'adm/account_headers/get_data_child',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			window.confApp = new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				data : {
					createUrl : ''
				},
				methods: {
					addRowType: function () {
						var vue = this;
					}
				},
				mounted: function () {
				 	parentThis.handleDataTable();
					parentThis.handleDataTableGroup();
				    parentThis.handleDataTableHeaderChild();	
					parentThis.handleDataTableHeader();
					$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
						$.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
					});
				}
			});

		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},
		handleCheckboxGroup: function () {
			var parentThis = this;

			$(parentThis.elTableGrup).on("click", parentThis.elSubCheckboxGroup, function () {
				var row     = ($('#master-table-group tr').length - 1);
				var checked = $('#master-table-group').find('input[class="check-sub-master-group"]:checked');

				if(row == checked.length){
					$('#check-all-master-group').prop('checked', true);
				}else{
					$('#check-all-master-group').prop('checked', false);
				}

			});

			$('select[name="master-table-group_length"]').click(function(){
				if($(parentThis.elParentCheckboxGroup).is(':checked')){
					$(parentThis.elSubCheckboxGroup).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxGroup).prop('checked', false);
				}
				
			});

			$('#master-table-group_paginate').click(function(){
				if($(parentThis.elParentCheckboxGroup).is(':checked')){
					$(parentThis.elSubCheckboxGroup).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxGroup).prop('checked', false);
				}
			});

		},
		handleCheckboxHeader: function () {
			var parentThis = this;

			$(parentThis.elTableHeader).on("click", parentThis.elSubCheckboxHeader, function () {
				var row     = ($('#master-table-header tr').length - 1);
				var checked = $('#master-table-header').find('input[class="check-sub-master-header"]:checked');

				if(row == checked.length){
					$('#check-all-master-header').prop('checked', true);
				}else{
					$('#check-all-master-header').prop('checked', false);
				}

			});

			$('select[name="master-table-header_length"]').click(function(){
				if($(parentThis.elParentCheckboxHeader).is(':checked')){
					$(parentThis.elSubCheckboxHeader).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxHeader).prop('checked', false);
				}
				
			});

			$('#master-table-header_paginate').click(function(){
				if($(parentThis.elParentCheckboxHeader).is(':checked')){
					$(parentThis.elSubCheckboxHeader).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxHeader).prop('checked', false);
				}
			});

		},
		handleCheckboxChild: function () {
			var parentThis = this;

			$(parentThis.elTableChild).on("click", parentThis.elSubCheckboxChild, function () {
				var row     = ($('#master-table-child tr').length - 1);
				var checked = $('#master-table-child').find('input[class="check-sub-child-master"]:checked');

				if(row == checked.length){
					$('#check-all-child-master').prop('checked', true);
				}else{
					$('#check-all-child-master').prop('checked', false);
				}

			});

			$('select[name="master-table-header_length"]').click(function(){
				if($(parentThis.elParentCheckboxChild).is(':checked')){
					$(parentThis.elSubCheckboxChild).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxChild).prop('checked', false);
				}
				
			});

			$('#master-table-header_paginate').click(function(){
				if($(parentThis.elParentCheckboxChild).is(':checked')){
					$(parentThis.elSubCheckboxChild).prop('checked', true);
				}else{
					$(parentThis.elSubCheckboxChild).prop('checked', false);
				}
			});

		},

		// Accounts : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'name',
					},
					{
						data: 'normal_balance',
					},
				// 	{
				// 		data: 'type_name',
				// 	},
					{
						data: 'header_name',
					},
					{
						data: 'header_child_name',
					},
					{
						data: 'group_name',
					},
					{
						data: 'opening_balance',
					}
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatable
					);

					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},
		handleDataTableGroup: function () {
			var parentThis = this;

			// Datatable
			parentThis.elDatatableGroup = $(parentThis.elTableGrup).DataTable({
				ajax: {
					url: parentThis.urlRequestGrup
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckboxGrup
					},
					{
						data: 'name',
						render: renderEditGroup
					},
					{
						data: 'report',
					}
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatableGroup
					);

					parentThis.handleDeleteGroup();
					parentThis.handleCheckboxGroup();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxGroup, parentThis.elSubCheckboxGroup);
				}

			});
		},
		handleDataTableHeader: function () {
			var parentThis = this;

			// Datatable
			parentThis.elDatatableHeader = $(parentThis.elTableHeader).DataTable({
				ajax: {
					url: parentThis.urlRequestHeader
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckboxHeader
					},
					{
						data: 'number',
						render: renderText,
					},
					{
						data: 'name',
						render: renderText,
					},
					{
						data: 'group',
					},
					{
						data: 'name',
						className: 'fit-width',
						render: renderEditHeader,
					},
					{
						data: 'name',
						className: 'fit-width',
						render: renderChild,
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4,5],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM_ACCOUNT_HEADER.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatableHeader
					);

					parentThis.handleDeleteHeader();
					parentThis.handleCheckboxHeader();
					parentThis.handleCheckboxChild();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxHeader, parentThis.elSubCheckboxHeader);
				}

			});
		},
		handleDataTableHeaderChild: function () {
			var parentThis = this;
			console.log("HANDLE");
			$(parentThis.elTableHeader).on("click", parentThis.elChild, function () {

				var id = $(this).attr('data-id');
				$(".master-child").removeClass('bg-info');
				$(".text-child").removeClass('text-info');
				$("#master-child" +id).addClass('bg-info');
				$("#text-child" +id).addClass('text-info');
				
				var vue = window.confApp;
				vue.$set(vue, 'createUrl', APP.siteUrl + 'adm/account_headers/edit_child/new/' +id);

				// Datatable
				$(parentThis.elTableChild).dataTable().fnDestroy();
				// $(parentThis.elTableChild).DataTable().clear().destroy();
				parentThis.elDatatableChild = $(parentThis.elTableChild).DataTable({
					ajax: {
						type: "POST",
						dataType: 'json',
						url: parentThis.urlRequestHeaderChild,
						data: {
							id: id,
						},
					},
					columns: [{
							data: 'no',
							width: '20',
							className: 'fit-width',
							render: renderCheckboxChild
						},
						{
							data: 'number',
						},
						{
							data: 'name',
						},
						{
							className: 'fit-width',
							render: renderEditChild,
						}
					],

					order: [],
					deferRender: true,
					scrollX: true,
					"columnDefs": [{
						"targets": [0,3],
						"orderable": false,
					}],
					"language": {
						"url": parentThis.urlBahasa,
						"sEmptyTable": "Tidads"
					},

					initComplete: function () {
						// handle form
						window.FORM_ACCOUNT_HEADER.handleEditModal(
							parentThis.elForm,
							parentThis.elEditChild,
							parentThis.elModalChild,
							parentThis.elModalContentChild,
							parentThis.elModalClose,
							parentThis.elDatatableChild
						);

						parentThis.handleDeleteChild();
						window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxChild, parentThis.elSubCheckboxChild);
					}

				});

			});

			$(parentThis.elTableHeader).on("click", parentThis.elEdit, function () {

				var id = $(this).attr('data-id');
				$(".master-child").removeClass('bg-info');
				$(".text-child").removeClass('text-info');
				$("#master-child" +id).addClass('bg-info');
				$("#text-child" +id).addClass('text-info');
				
				var vue = window.confApp;
				vue.$set(vue, 'createUrl', APP.siteUrl + 'adm/account_headers/edit_child/new/' +id);

				// Datatable
				$(parentThis.elTableChild).dataTable().fnDestroy();
				// $(parentThis.elTableChild).DataTable().clear().destroy();
				parentThis.elDatatableChild = $(parentThis.elTableChild).DataTable({
					ajax: {
						type: "POST",
						dataType: 'json',
						url: parentThis.urlRequestDataChild,
						data: {
							id: id,
						},
					},
					columns: [{
							data: 'no',
							width: '20',
							className: 'fit-width',
							render: renderCheckboxChild
						},
						{
							data: 'number',
						},
						{
							data: 'name',
						},
						{
							className: 'fit-width',
							render: renderEditChild,
						},
					],

					order: [],
					deferRender: true,
					scrollX: true,
					"columnDefs": [{
						"targets": [0,3],
						"orderable": false,
					}],
					"language": {
						"url": parentThis.urlBahasa,
						"sEmptyTable": "Tidads"
					},

					initComplete: function () {
						// handle form
						window.FORM_ACCOUNT_HEADER.handleEditModal(
							parentThis.elForm,
							parentThis.elEditChild,
							parentThis.elModalChild,
							parentThis.elModalContentChild,
							parentThis.elModalClose,
							parentThis.elDatatableChild
						);

						parentThis.handleDeleteChild();
						window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxChild, parentThis.elSubCheckboxChild);
					}

				});

			});
			
		},

		// Accounts : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var accounts = [];
				for (var i = 0; i < Items.length; i++) {
					accounts.push($(Items[i]).val());
				}

				if (!accounts.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: accounts,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},
		handleDeleteGroup: function () {
			var parentThis = this;

			$(parentThis.elBtnDeleteGroup).click(function () {

				var Items = $(parentThis.elTableGrup).find('input[class="check-sub-master-group"]:checked');

				var accounts = [];
				for (var i = 0; i < Items.length; i++) {
					accounts.push($(Items[i]).val());
				}

				if (!accounts.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteDataGroup,
								data: {
									id: accounts,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatableGroup.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},
		handleDeleteHeader: function () {
			var parentThis = this;

			$(parentThis.elBtnDeleteHeader).click(function () {

				var Items = $(parentThis.elTableHeader).find('input[class="check-sub-master-header"]:checked');

				var accounts = [];
				for (var i = 0; i < Items.length; i++) {
					accounts.push($(Items[i]).val());
				}

				if (!accounts.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteDataHeader,
								data: {
									id: accounts,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatableHeader.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},
		handleDeleteChild: function () {
			var parentThis = this;

			$(parentThis.elBtnDeleteChild).click(function () {
				var Items = $(parentThis.elTableChild).find('input[class="check-sub-child-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteDataChild,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM_ACCOUNT_HEADER.showNotification(response.message, response.status);
									parentThis.elDatatableChild.ajax.reload();
									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

		getHeaderChild: function(id, hcid) {
			var parentThis = this;

			$.ajax({
				type: "POST",
				url: window.APP.siteUrl + 'adm/accounts/get_data_header_child',
				dataType: "JSON",
				data: {
					id: id
				},
				success: function (data) {

					$("#header-child-select").html("<option value=''>- Pilih -</option>");
					$.each(data, function (i, d) {
						if (hcid===d.account_header_child_id) {
							$('#header-child-select').append('<option value="' + d.account_header_child_id + '" selected="selected">' + d.account_header_child_number + ' - ' +d.account_header_child_name + '</option>');
						}else{
							$('#header-child-select').append('<option value="' + d.account_header_child_id + '">' + d.account_header_number +''+ d.account_header_child_number + ' - ' +d.account_header_child_name + '</option>');
						}
					});
					
				},
			});
		},

		getPrefix: function(id) {
			var parentThis = this;

			$.ajax({
				type: "POST",
				url: window.APP.siteUrl + 'adm/accounts/get_prefix',
				dataType: "JSON",
				data: {
					id: id
				},
				success: function (data) {

					$("#prefix-input").val(data);
					
				},
			});
		},

		handleHeader: function () {
			var parentThis = this;

			$("#header-select").change(function (e) {
				var value = $(e.target).val();
				parentThis.getHeaderChild(value);
			})
		},

		handleSubHeader: function () {
			var parentThis = this;

			$("#header-child-select").change(function (e) {
				var value = $(e.target).val();
				parentThis.getPrefix(value);
			})
		},

		handleEditSelect: function () {
			var parentThis = this;
			var value = $("#hid").val();
			var value2 = $("#hcid").val();
			parentThis.getHeaderChild(value, value2);
		}

	}

})(jQuery);