/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elSupplier: '.select-supplier',
		elFromDate: '.fromdate',
		elToDate: '.todate',

		urlRequestData: window.APP.siteUrl + 'adm/Datalog/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					supplier: '',
					fromdate: '',
					todate: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_search  = $("#search").val();
						

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'search': val_search,
								
							},
							dataType: "json",
							beforeSend : function() {
							   
							    
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
								 if(val_search == ""){
							        toastr.warning('Silahkan isi nomor terlebih dahulu!')
									$(that.elVue).unblock();
									return false;
							    }
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_debts/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);