/**
 * Javascript Embed
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

 window.EMBED = (function ($) {
	return {

		initVue: null,
		elVue: '#embed-vue',
		elTable: "#embed-table",
		elClose: '.embed-close',

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		urlGetData: window.APP.siteUrl + 'adm/pembelian/get_data_embed',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					listData: [],
					a:'',
				},
				methods: {
					getDataEmbed: function (Event) {
                        var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
                        var value = $("#search").val();
						
						$.ajax({
                            url: that.urlGetData,
                            type: 'post',
                            data: {
                                'search': value
                            },
							dataType: "json",
							success: function (response) {
								// vue.$set(vue, 'listData', response.data);
								
								var items = response.data;
								var listData = {};

								for (i = 0; i < items.length; i++) {
									var item = items[i];

									var lg_unit     = item.lg_unit;
									var md_unit     = item.md_unit;
									var sm_unit     = item.sm_unit;
									var lg_unit_cnt = item.lg_unit_cnt;
									var md_unit_cnt = item.md_unit_cnt;
									var sm_unit_cnt = item.sm_unit_cnt;
									var lg_unit_qty = 0;
									var md_unit_qty = 0;
									var sm_unit_qty = 0;
									var lg_unit_prc = item.lg_unit_prc;
									var md_unit_prc = item.md_unit_prc;
									var sm_unit_prc = item.sm_unit_prc;
									var discount = 0;
									var discount_total = 0;
									var result_large = 0;
									var result_medium = 0;
									var result_small = 0;
									var total = 0;
									var ppn_status_color = item.ppn_status_color;


									var overprice_lg = 0;
									var overprice_md = 0;
									var overprice_sm = 0;


									var btncolor = 'btn-default';
									var btnicon = '';

									if (vue.checkValue_isExists(item.id, vue.a) == 'Exist') {
										btncolor = 'btn-success';
										btnicon = 'fa fa-check';
										index = editVueInit.detailData.map(function (item) {
											return item.id
										}).indexOf(item.id);

										lg_unit_qty = editVueInit.detailData[index].lg_unit_qty;
										md_unit_qty = editVueInit.detailData[index].md_unit_qty;
										sm_unit_qty = editVueInit.detailData[index].sm_unit_qty;
										lg_unit_prc = editVueInit.detailData[index].lg_unit_prc;
										md_unit_prc = editVueInit.detailData[index].md_unit_prc;
										sm_unit_prc = editVueInit.detailData[index].sm_unit_prc;
										discount = editVueInit.detailData[index].discount;
										discount_total = editVueInit.detailData[index].discount_total;
										result_large = editVueInit.detailData[index].result_large;
										result_medium = editVueInit.detailData[index].result_medium;
										result_small = editVueInit.detailData[index].result_small;
										total = editVueInit.detailData[index].total;

										overprice_lg = editVueInit.detailData[index].overprice_lg;
										overprice_md = editVueInit.detailData[index].overprice_md;
										overprice_sm = editVueInit.detailData[index].overprice_sm;

									}
									listData[i] = {
										'no'              : item.no,
										'id'              : item.id,
										'name'            : item.name,
										'group_name'      : item.group_name,
										'group_child_name': item.group_child_name,
										'lg_unit'         : lg_unit,
										'lg_unit_cnt'     : lg_unit_cnt,
										'lg_unit_qty'     : lg_unit_qty,
										'lg_unit_prc'     : lg_unit_prc,
										'lg_unit_slg'     : item.lg_unit_slg,
										'md_unit'         : md_unit,
										'md_unit_cnt'     : md_unit_cnt,
										'md_unit_qty'     : md_unit_qty,
										'md_unit_prc'     : md_unit_prc,
										'md_unit_slg'     : item.md_unit_slg,
										'sm_unit'         : sm_unit,
										'sm_unit_cnt'     : sm_unit_cnt,
										'sm_unit_qty'     : sm_unit_qty,
										'sm_unit_prc'     : sm_unit_prc,
										'sm_unit_slg'     : item.sm_unit_slg,
										'discount'        : discount,
										'discount_total'        : discount_total,
										'result_large'    : result_large,
										'result_medium'   : result_medium,
										'result_small'    : result_small,
										'ppn_status_color'  : ppn_status_color,
										'total'           : total,
										'remark'          : '',

										'overprice_lg'         : overprice_lg,
										'overprice_md'         : overprice_md,
										'overprice_sm'         : overprice_sm,
								

										'btncolor'        : btncolor,
										'btnicon'         : btnicon,
									};
								}
								vue.listData = listData;
							}
						});
					},

					getSelectedData: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							editVueInit.detailData.splice(index, 1);
							vue.$set(vue.listData[idx], 'btncolor', 'btn-default');
							vue.$set(vue.listData[idx], 'btnicon', '');
						}else{
							editVueInit.detailData.push({
								id            : row.id,
								name          : row.name,
								lg_unit       : row.lg_unit,
								lg_unit_cnt   : row.lg_unit_cnt,
								lg_unit_qty   : row.lg_unit_qty,
								lg_unit_prc   : row.lg_unit_prc,
								lg_unit_slg   : row.lg_unit_slg,
								md_unit       : row.md_unit,
								md_unit_cnt   : row.md_unit_cnt,
								md_unit_qty   : row.md_unit_qty,
								md_unit_prc   : row.md_unit_prc,
								md_unit_slg   : row.md_unit_slg,
								sm_unit       : row.sm_unit,
								sm_unit_cnt   : row.sm_unit_cnt,
								sm_unit_qty   : row.sm_unit_qty,
								sm_unit_prc   : row.sm_unit_prc,
								sm_unit_slg   : row.sm_unit_slg,
								discount      : row.discount,
								discount_total: row.discount_total,
								result_large  : row.result_large,
								result_medium : row.result_medium,
								result_small  : row.result_small,
								ppn_status_color  : row.ppn_status_color,
								total         : row.total,

								overprice_lg         : row.overprice_lg,
								overprice_md         : row.overprice_md,
								overprice_sm         : row.overprice_sm,

								remark        : ''
							});
							vue.$set(vue.listData[idx], 'btncolor', 'btn-success');
							vue.$set(vue.listData[idx], 'btnicon', 'fa fa-check');
						}
						
						vue.checkData_isExists();
						$("#search").focus();
						$("#search").val("");
					},

					handlePrice: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						vue.$set(row, field_name, value);
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
						}
						
						var overprice_lg = 0;
						var overprice_md = 0;
						var overprice_sm = 0;
						if(field_name == 'lg_unit_prc'){
							if(parseFloat(row.lg_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.lg_unit_slg.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga beli melebihi harga jual!');
								vue.$set(row, 'overprice_lg', 1);
							}else{
								vue.$set(row, 'overprice_lg', 0);
							}
						}

						if(field_name == 'md_unit_prc'){
							if(parseFloat(row.md_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.md_unit_slg.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga beli melebihi harga jual!');
								vue.$set(row, 'overprice_md', 1);
							}else{
								vue.$set(row, 'overprice_md', 0);
							}

							var isi_besar   = row.lg_unit_cnt;
							var isi_sedang  = row.md_unit_cnt;
							var isi_kecil   = row.sm_unit_cnt;
							var harga_sedang = row.md_unit_prc.replace(/[^\w\s]/gi, '');

							
							var harga_kecil  = harga_sedang/isi_sedang;
							var harga_besar = harga_kecil * isi_besar;

							vue.$set(row, 'sm_unit_prc', Math.round(harga_kecil).toLocaleString("en-US"));
							vue.$set(row, 'lg_unit_prc', Math.round(harga_besar).toLocaleString("en-US"));

						}

						if(field_name == 'sm_unit_prc'){
							if(parseFloat(row.sm_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.sm_unit_slg.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga beli melebihi harga jual!');
								vue.$set(row, 'overprice_sm', 1);
							}else{
								vue.$set(row, 'overprice_sm', 0);
							}

							var isi_besar   = row.lg_unit_cnt;
							var isi_sedang  = row.md_unit_cnt;
							var isi_kecil   = row.sm_unit_cnt;
							var harga_kecil = row.sm_unit_prc.replace(/[^\w\s]/gi, '');

							
							var harga_sedang  = harga_kecil * isi_sedang;
							var harga_besar = harga_kecil * isi_besar;

							vue.$set(row, 'md_unit_prc', Math.round(harga_sedang).toLocaleString("en-US"));
							vue.$set(row, 'lg_unit_prc', Math.round(harga_besar).toLocaleString("en-US"));
						}

						vue.handleCount(row, field_name, value);
					},

					handleCount: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						var discount = 0;
						var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							if(row.sm_unit_cnt > 0){
								auto_smprc = (row.lg_unit_prc.replace(/[^\w\s]/gi, '') / row.lg_unit_cnt);
								auto_mdprc = (auto_smprc * row.md_unit_cnt);

								vue.$set(row, 'sm_unit_prc', Math.round(auto_smprc).toLocaleString("en-US"));
								vue.$set(row, 'md_unit_prc', Math.round(auto_mdprc).toLocaleString("en-US"));

								result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_small', result_small);
								result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_medium', result_medium);
							}else if(row.md_unit_cnt > 0 && row.sm_unit_cnt == 0){
								auto_mdprc = (row.lg_unit_prc.replace(/[^\w\s]/gi, '') / row.lg_unit_cnt);
								vue.$set(row, 'md_unit_prc', Math.round(auto_mdprc).toLocaleString("en-US"));
								vue.$set(row, 'sm_unit_prc', 0);

								result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_medium', result_medium);
							}else{
								vue.$set(row, 'sm_unit_prc', 0);
								vue.$set(row, 'md_unit_prc', 0);
							}
						
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);

							if(row.sm_unit_cnt > 0){
								result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_small', result_small);
							}
							
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
						
						}

						

						result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(result_large_total) + Number(result_medium_total) + Number(result_small_total));

						discount = total * row.discount / 100;
						sub_total = total - discount;
						vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
							vue.$set(editVueInit.detailData[index], 'result_large', result_large_total);
							vue.$set(editVueInit.detailData[index], 'result_medium', result_medium_total);
							vue.$set(editVueInit.detailData[index], 'result_small', result_small_total);
							vue.$set(editVueInit.detailData[index], 'discount_total', discount.toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'total', sub_total.toLocaleString("en-US"));

							vue.$set(editVueInit.detailData[index], 'lg_unit_prc', row.lg_unit_prc);
							vue.$set(editVueInit.detailData[index], 'md_unit_prc', row.md_unit_prc);
							vue.$set(editVueInit.detailData[index], 'sm_unit_prc', row.sm_unit_prc);

							vue.$set(editVueInit.detailData[index], 'overprice_lg', row.overprice_lg);
							vue.$set(editVueInit.detailData[index], 'overprice_md', row.overprice_md);
							vue.$set(editVueInit.detailData[index], 'overprice_sm', row.overprice_sm);
						}
					},

					closeModal: function () {
						$(that.elClose).click();
					},

					checkData_isExists: function () {
						var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						const a = [];
						const objectArray = Object.entries(editVueInit.detailData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;
					},	

					checkValue_isExists: function (value, arr) {
						var vue = this;

						var status = 'Not exist';

						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i];
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}

						return status;
					}
				},
				mounted: function () {
					var vue = this;

					vue.getDataEmbed();
					vue.checkData_isExists();
					
				}
			});

		},
	}
})(jQuery);