/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elSupplier: '.select-supplier',
		elFromDate: '.fromdate',
		elToDate: '.todate',

		urlRequestData: window.APP.siteUrl + 'adm/report_debts/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					supplier: '',
					fromdate: '',
					todate: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_supplier  = $(that.elSupplier).val();
						var val_fromdate      = $(that.elFromDate).val();
						var val_todate      = $(that.elToDate).val();

						var text_supplier = $(that.elSupplier + ' option:selected').text();
						
						vue.$set(vue, 'supplier', text_supplier);
						// vue.$set(vue, 'date', text_date);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'supplier': val_supplier,
								'fromdate': val_fromdate,
								'todate'  : val_todate
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_debts/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);