/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elCustomer: '.select-customer',
		elItem: '.select-item',
		elFromDate: '.fromdate',
		elToDate: '.todate',

		urlRequestData: window.APP.siteUrl + 'adm/report_sales_returns/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					customer: '',
					item_name: '',
					item: '',
					fromdate: '',
					todate: '',
					grand_total: 0,
					total_transaksi: 0,
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_customer  = $(that.elCustomer).val();
						var val_item  = $(that.elItem).val();
						var val_fromdate     = $(that.elFromDate).val();
						var val_todate     = $(that.elToDate).val();
						var val_user     = $('.select-user').val();

						var text_customer = $(that.elCustomer + ' option:selected').text();
						var text_item = $(that.elItem + ' option:selected').text();
						
						vue.$set(vue, 'customer', text_customer);
						vue.$set(vue, 'item_name', text_item);
						// vue.$set(vue, 'date', text_date);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'customer': val_customer,
								'item'    : val_item,
								'fromdate': val_fromdate,
								'todate'  : val_todate,
								'user':val_user
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response['detail_data']);
								vue.$set(vue, 'grand_total', response['grand_total']);
								vue.$set(vue, 'total_transaksi', response['total_transaksi']);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_sales_returns/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);