/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elGroup: '.select-group',
        elForm: ".edit-form",
		urlRequestData: window.APP.siteUrl + 'adm/UbahHarga/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					group: '',
					fromdate: '',
					todate: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_group  = $(that.elGroup).val();

						var text_group = $(that.elGroup + ' option:selected').text();
						   var val_mulai  = $('.mulai').val();
						vue.$set(vue, 'group', text_group);
						// vue.$set(vue, 'date', val_date);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'group': val_group,
                                'mulai': val_mulai,
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_credits/export_excel';
						}, 500);
					},
					handlePrice: function (row, field_name, value) {
						var vue = this;

						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);

                        console.log("price");
						vue.$set(row, field_name, value);
						vue.$set(row, 'is_updated', 1);

					},
					handleForm2: function () {
						var vue = this;

						window.DATETIME.initDatePicker();
						$(that.elVue).unblock();



						$(that.elForm).validate();

						$(that.elForm).ajaxForm({
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});

							},
							data: {
								vuedata: vue.detailData,
								// vuedatayard: vue.detailDataYard
							},
							dataType: "json",
							success: function (response) {

								window.FORM.showNotification(response.message, response.status);

								if (response.status == "success") {
									setTimeout(function () {
										window.location.href = window.APP.siteUrl + 'adm/UbahHarga/'
									}, 1500);
								}

							}
						});

					},
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);