<?php
/**
 * Conf Invoice Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Conf_invoice2 extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Configuration_model');
	}
	
	public function index() {
		$data['content_title'] = 'Faktur - PPN';

		$this->twiggy_display('adm/conf_invoice2/index', $data);
	}

	public function get_data() {
		$data = [];

		$where = array('ppn_status' => '2');
		$get_data = $this->Configuration_model->get_data_invoice($where)->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$is_active = ($get_row->is_active == '1' ? '<i class="fas fa-check text-success"></i>' : '<i class="fas fa-times text-danger"></i>');

				$data[] = array(
					'no'         => $no,
					'id'         => $get_row->id,
					'header'     => $get_row->header,
					'footer'     => $get_row->footer,
					'ppn_status' => '2',
					'is_active'  => $is_active
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('id' => $id, 'ppn_status' => '2');
			$get_data = $this->Configuration_model->get_data_invoice($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/conf_invoice2/edit', $data);
	}

	public function save() {
		// post
		$id     = $this->input->post('id');
		$header = $this->input->post('header');
		$footer = $this->input->post('footer');
		$active = $this->input->post('active');
		$action = $this->input->post('action');

		$data_save = array(
			'header'     => $header,
			'footer'     => $footer,
			'ppn_status' => '2',
			'is_active'  => $active,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save_1  = $this->Configuration_model->save_invoice($data_save);
			if($save_1){
				$next_id = $this->db->insert_id();
			}
		} else {
			$convert    = convert_button($action, $id);
			$where_this = array('id' => $id);
			$save_1     = $this->Configuration_model->update_invoice($where_this, $data_save);
			if($save_1){
				$next_id = $id;
			}
		}

		if($active == 1){
			$where  = array('id !=' => $next_id, 'ppn_status' => '2');
			$status = array(
				'is_active' => '0',
			);
			$save   = $this->Configuration_model->update_invoice($where, $status);
		}else{
			$save   = true;
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Configuration_model->delete_invoice($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}

?>
