<?php
/**
 * Report Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_sales_orders_item extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Penjualan';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_orders_item/index', $data);
	}

	public function get_data_detail()
	{	
		$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		$sel_order    = $this->input->post("sel_order");
		$sel_column   = $this->input->post("sel_column");

        $data  = [];
		$where = [];

		$order = "";
		if(isset($sel_order) && $sel_order != '' && $sel_order != '(Semua)' && isset($sel_column) && $sel_column != '' && $sel_column != '(Semua)'){
			$order = ($sel_column." ".$sel_order);
		}

		// echo json_encode($order);
		// die();

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		
		// $get_data    = $this->Sales_orders_model->salesorder_detail_advance_item($where, $order, 'sales_order_header_id')->result();
		$get_data    = $this->Sales_orders_model->salesorder_detail_advance_item($where, $order, 'sales_order_detail_item_id')->result();
		$grand_total = 0;

		// echo json_encode($get_data);
		// die();

		// echo json_encode($get_data);
		// die();
		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
				
			foreach ($get_data as $key => $value) {
				$ppn_status_color = '';

				// if($value->ppn_status == '1'){
				// 	$faktur = $value->faktur_1;
				// }
				if($value->ppn_status == '2'){
					$ppn_status_color = 'cl-success';
				}
				if($value->ppn_status == '3'){
					$ppn_status_color = 'cl-warning';
				}

				// $faktur = trim(($value->faktur_1 != "0" ? $value->faktur_1 : "")." ".($value->faktur_2 != "0" ? $value->faktur_2 : "")." ".($value->faktur_3 != "0" ? $value->faktur_3 : ""));
				// if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
				// {	
				// 	if($ppn == '1'){
				// 		$faktur = $value->faktur_1;
				// 	}
				// 	if($ppn == '2'){
				// 		$faktur = $value->faktur_2;
				// 	}
				// 	if($ppn == '3'){
				// 		$faktur = $value->faktur_3;
				// 	}
				// }

				$lg_cnt = $value->large_unit_contain;
				$md_cnt = $value->medium_unit_contain;
				$sm_cnt = $value->small_unit_contain;

				$ttl_qty = (($value->q_lg * $lg_cnt) + ($value->q_md * $md_cnt) + ($value->q_sm * $sm_cnt));

				$unit = '';

				if($value->sales_order_detail_small_unit != ""){
					$unit = $value->sales_order_detail_small_unit;
				}elseif($value->sales_order_detail_medium_unit != ""){
					$unit = $value->sales_order_detail_medium_unit;
				}else{
					$unit = $value->sales_order_detail_large_unit;
				}

				$data[] = array(	
					'no'               => $no,
					'sales_number'     => $value->sales_order_header_number,
					// 'faktur_number'    => $faktur,
					'customer'         => $value->customer_name,
					'sales_date'       => change_format_date($value->printed_date, 'd/m/Y'),
					'item_name'        => $value->sales_order_detail_item_name,
					'unit'             => $unit,
					'qty'              => to_decimal($ttl_qty),
					'ttl_price'        => number_format($value->ttl),
					'ppn_status_color' => $ppn_status_color,
					// 'total'            => number_format($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small),
					// 'total'            => number_format($value->sales_order_detail_total),
					'status'  => $value->sales_order_detail_ppn_status,
					'is_hold' => ($value->is_hold == 1 ? 'bg-warning' : '')
				);
				$line++;

				$grand_total += $value->ttl;
				// $total_all_tunai    += $tunai;
				// $total_all_transfer += $transfer;
				// $total_all_method   += $t_all;
				
			}
			$no++;
			
		}

		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('ppn', $ppn);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);
		$this->session->set_userdata('sel_order', $sel_order);
		$this->session->set_userdata('sel_column', $sel_column);

		$response = [
			// 'date_1'             => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'             => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data' => $data,
			'grand_total' => number_format($grand_total),
			'total_transaksi' => number_format(count($get_data))
		];

		output_json($response);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$item     = $this->session->userdata('item');
		$ppn      = $this->session->userdata('ppn');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');
		$sel_order   = $this->session->userdata('sel_order');
		$sel_column   = $this->session->userdata('sel_column');

		$where    = [];
		// $order = ("printed_date ASC, sales_order_header_number");

		$order = "";
		if(isset($sel_order) && $sel_order != '' && $sel_order != '(Semua)' && isset($sel_column) && $sel_column != '' && $sel_column != '(Semua)'){
			$order = ($sel_column." ".$sel_order);
		}

		$customer_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		
		// $get_data = $this->Sales_orders_model->salesorder_detail_advance($where, $order)->result();
		$get_data = $this->Sales_orders_model->salesorder_detail_advance_item($where, $order, 'sales_order_detail_item_id')->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PENJUALAN")
							   ->setSubject("PENJUALAN")
							   ->setDescription("PENJUALAN")
							   ->setKeywords("PENJUALAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_row_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5cb85c')
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Penjualan");
	    $excel->getActiveSheet()->mergeCells('A1:Q1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$fromdate_text." - ".$todate_text);


	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "No.");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Kuantitas");
	    $excel->setActiveSheetIndex(0)->setCellValue('D7', "Unit");
	    $excel->setActiveSheetIndex(0)->setCellValue('E7', "Nominal");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E7')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 8; // Set baris pertama untuk isi tabel adalah baris ke 9
		$numtrx = '';
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$ppn_status_color = '';

			// if($value->ppn_status == '1'){
			// 	$faktur = $value->faktur_1;
			// }
			if($get_row->ppn_status == '2'){
				$ppn_status_color = 'cl-success';
			}
			if($get_row->ppn_status == '3'){
				$ppn_status_color = 'cl-warning';
			}

			// $faktur = trim(($value->faktur_1 != "0" ? $value->faktur_1 : "")." ".($value->faktur_2 != "0" ? $value->faktur_2 : "")." ".($value->faktur_3 != "0" ? $value->faktur_3 : ""));
			// if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
			// {	
			// 	if($ppn == '1'){
			// 		$faktur = $value->faktur_1;
			// 	}
			// 	if($ppn == '2'){
			// 		$faktur = $value->faktur_2;
			// 	}
			// 	if($ppn == '3'){
			// 		$faktur = $value->faktur_3;
			// 	}
			// }

			$lg_cnt = $get_row->large_unit_contain;
			$md_cnt = $get_row->medium_unit_contain;
			$sm_cnt = $get_row->small_unit_contain;

			$ttl_qty = (($get_row->q_lg * $lg_cnt) + ($get_row->q_md * $md_cnt) + ($get_row->q_sm * $sm_cnt));

			$unit = '';

			if($get_row->sales_order_detail_small_unit != ""){
				$unit = $get_row->sales_order_detail_small_unit;
			}elseif($get_row->sales_order_detail_medium_unit != ""){
				$unit = $get_row->sales_order_detail_medium_unit;
			}else{
				$unit = $get_row->sales_order_detail_large_unit;
			}
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->sales_order_detail_item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $ttl_qty);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $unit);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->ttl);


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			if($get_row->is_hold == '1'){
				$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row_warning);
			}

			$excel->getActiveSheet()->getStyle('C'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('E'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
	
	      	 // Tambah 1 setiap kali looping
	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PENJUALAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PENJUALAN_PER_ITEM'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
