<?php
/**
 * Report Stock Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_stocks extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Logs_model');
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Transfer_model');
		$this->load->model('Warehouses_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	 public function card()
 	{	
        $data['content_title'] = 'Laporan Kartu Stok';
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_stocks/card', $data);
	}

	public function recap()
 	{	
        $data['content_title'] = 'Laporan Rekap Stok';
        $data['item_data']     = $this->Items_model->get_data()->result();
        $data['group_data']    = $this->Groups_model->get_data()->result();
		
		$this->twiggy_display('adm/report_stocks/recap', $data);
	}

	public function recap_warehouse()
 	{	
        $data['content_title'] = 'Laporan Rekap Stok Gudang';
        $data['item_data']     = $this->Items_model->get_data()->result();
        $data['group_data']    = $this->Groups_model->get_data()->result();
		
		$this->twiggy_display('adm/report_stocks/recap_warehouse', $data);
	}

	public function get_data_detail_card()
	{	
		$item     = $this->input->post("item");
		$date_log = $this->input->post("date_log");
		$status = $this->input->post("status");

        $data  = [];
        $where = [];
		$order = ("a.timestamp ASC");

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}
		

		$get_data = $this->Logs_model->get_data_advance($where, $order)->result();

		// echo json_encode();
		// die();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$transaction_status = '';
				$transaction_number	= '';
				$transaction_actor	= '';
				$in_large   = '-';
				$in_medium  = '-';
				$in_small   = '-';
				$out_large  = '-';
				$out_medium = '-';
				$out_small  = '-';
				if($get_row->log_type == 'BUY'){

					$transaction_status = 'Beli';
					$transaction_number = $get_row->purchase_order_header_number;
					$transaction_actor  = $get_row->supplier_name;
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'SELL'){

					$transaction_status = 'Jual';
					$transaction_number = $get_row->sales_order_header_number;
					$transaction_actor  = $get_row->customer_name;
					$out_large  = $get_row->log_large_unit_quantity;
					$out_medium = $get_row->log_medium_unit_quantity;
					$out_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'R-BUY'){

					$transaction_status = 'Retur Beli';
					$transaction_number = $get_row->purchase_return_header_number;
					$transaction_actor  = $get_row->supplier_name;
					$out_large  = $get_row->log_large_unit_quantity;
					$out_medium = $get_row->log_medium_unit_quantity;
					$out_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'R-SELL'){

					$transaction_status = 'Retur Jual';
					$transaction_number = $get_row->sales_return_header_number;
					$transaction_actor  = $get_row->customer_name;
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}else{

					$transaction_status = 'Pengaturan Stok';
					$transaction_number = $get_row->stock_header_number;
					$transaction_actor  = '-';
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}

				//Calculate 
                $therest      = $get_row->log_total_stock;
                $total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
                $therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
                $total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
                $therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
                $total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));
				
				$data[] = array(
					'no'                 => $no,
					'log_id'             => $get_row->log_id,
					'log_date'           => change_format_date($get_row->tms_log, 'd/m/Y'),
					'transaction_status' => $transaction_status,
					'transaction_number' => $transaction_number,
					'transaction_actor'  => $transaction_actor,
					'in_large'           => $in_large,
					'in_medium'          => $in_medium,
					'in_small'           => $in_small,
					'out_large'          => $out_large,
					'out_medium'         => $out_medium,
					'out_small'          => $out_small,
					'large_unit'         => $total_large,
					'medium_unit'        => $total_medium,
					'small_unit'         => $total_small,
					'is_hold'			 => ($get_row->is_hold == 1 ? 'bg-warning' : '')
				);
                $no++;
                
			}
		}
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('status', $status);
		$this->session->set_userdata('date_log', $date_log);

		output_json($data);
	}

	public function get_data_detail_recap()
	{	
		$item     = $this->input->post("item");
		$group    = $this->input->post("group");
		$status    = $this->input->post("status");
		$stock    = $this->input->post("stock");
		$date_log = $this->input->post("date_log");

        $data  = [];
        $where = [];
        $where_timestamp = date_now();

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
		}
		if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['b.item_group_id'] = $group;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where_timestamp = change_format_date($date_log);
		}
		if(isset($stock) && $stock != '' && $stock != '(Semua)')
		{
			if($stock == '1'){
				$where['a.log_total_stock >'] = '0';
			}else{
				$where['a.log_total_stock <='] = '0';
			}
		}

		
		
		$get_data = $this->Logs_model->get_data_detail_recap2($where, $where_timestamp)->result();
		$total = 0;
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	

				$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
				$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
				$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

				$unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");

				//Calculate 
                $therest      = $get_row->log_total_stock;
                $total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
                $therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
                $total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
                $therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
                $total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));

                $avg_large  = ($get_row->log_large_unit_contain == 0 ? '-' : number_format($get_row->log_average_large_unit));
                $avg_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : number_format($get_row->log_average_medium_unit));
                $avg_small  = ($get_row->log_small_unit_contain == 0 ? '-' : number_format($get_row->log_average_small_unit));

                $lg_unit = $total_large  ." ". $get_row->log_large_unit;
                $md_unit = $total_medium ." ". $get_row->log_medium_unit;
                $sm_unit = $total_small  ." ". $get_row->log_small_unit;
				$data[] = array(
					'no'                  => $no,
					'log_id'              => $get_row->log_id,
					'item_name'           => $get_row->item_name,
					'unit_contain'        => $unit_contain,
					'group_name'          => $get_row->group_name,
					'large_unit'          => $total_large,
					'medium_unit'         => $total_medium,
					'small_unit'          => $total_small,
					'average_large_unit'  => $avg_large,
					'average_medium_unit' => $avg_medium,
					'average_small_unit'  => $avg_small,
					'total_value'         => number_format($get_row->log_total_stock_value)
				);
                $no++;
                $total += $get_row->log_total_stock_value;
			}
		}
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('group', $group);
		$this->session->set_userdata('status', $status);
		$this->session->set_userdata('date_log', $date_log);
		$this->session->set_userdata('total', $total);

		$response = [
			'data'  => $data,
			'total' => number_format($total)
		];

		output_json($response);
	}

	// public function get_data_detail_recap_warehouse()
	// {	
	// 	$item      = $this->input->post("item");
	// 	$group     = $this->input->post("group");
	// 	$status    = $this->input->post("status");
	// 	$stock     = $this->input->post("stock");
	// 	$warehouse = $this->input->post("warehouse");
	// 	$date_log  = $this->input->post("date_log");

    //     $data  = [];
    //     $where = [];
    //     $where_timestamp = date_now();

    //     if(isset($item) && $item != '' && $item != '(Semua)')
	// 	{
	// 		$where['a.log_item_id'] = $item;
	// 	}
	// 	if(isset($group) && $group != '' && $group != '(Semua)')
	// 	{
	// 		$where['b.item_group_id'] = $group;
	// 	}
	// 	if(isset($status) && $status != '' && $status != '(Semua)')
	// 	{
	// 		$where['b.ppn_status'] = $status;
	// 	}
	// 	if(isset($date_log) && $date_log != '')
	// 	{
	// 		$where_timestamp = change_format_date($date_log);
	// 	}
	// 	if(isset($stock) && $stock != '' && $stock != '(Semua)')
	// 	{
	// 		if($stock == '1'){
	// 			$where['a.log_total_stock >'] = '0';
	// 		}else{
	// 			$where['a.log_total_stock <='] = '0';
	// 		}
	// 	}	
		
	// 	$get_data = $this->Transfer_model->transfer_advance('','', true)->result();
		
	// 	$total = 0;
	// 	// ketika data tersedia
	// 	// maka generate data json untuk Datatable
	// 	if($get_data)
	// 	{
	// 		$no = 1;
	// 		foreach($get_data as $get_row)
	// 		{	

	// 			$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
	// 			$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
	// 			$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

	// 			$unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");

	// 			//Calculate 

	// 			$in_stock = 0;
	// 			$ou_stock = 0;
	// 			$total_stock = 0;

	// 			// $warehouse = $this->Warehouses_model->get_data(array('is_default' => 1))->row()->warehouse_id;

	// 			$get_stock_in = $this->Transfer_model->transfer_advance(array('header_to' => $get_row->header_to, 'item_id' => $get_row->item_id), 'item_id, header_to')->row();
	// 			$get_stock_ou = $this->Transfer_model->transfer_advance(array('header_from' => $get_row->header_from, 'item_id' => $get_row->item_id), 'item_id, header_from')->row();

	// 			if($get_stock_in){
	// 				$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
	// 			}

	// 			if($get_stock_ou){
	// 				$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
	// 			}

	// 			$total_stock = $ou_stock;


	// 			// echo json_encode($total_stock);
				
	// 			// $total_stock = (($get_row->large_qty * $get_row->large_unit_contain) + ($get_row->medium_qty * $get_row->medium_unit_contain) + ($get_row->small_qty * $get_row->small_unit_contain));

    //             $therest      = $total_stock;
    //             $total_large  = ($get_row->large_unit_contain == 0 ? '-' : floor($total_stock / $get_row->large_unit_contain));
    //             $therest      = ($therest - ($total_large * $get_row->large_unit_contain));
    //             $total_medium = ($get_row->medium_unit_contain == 0 ? '-' : floor($therest / $get_row->medium_unit_contain));
    //             $therest      = ($therest - ($total_medium * $get_row->medium_unit_contain));
    //             $total_small  = ($get_row->small_unit_contain == 0 ? '-' : floor($therest / $get_row->small_unit_contain));

    //             $lg_unit = $total_large  ." ". $get_row->large_unit;
    //             $md_unit = $total_medium ." ". $get_row->medium_unit;
    //             $sm_unit = $total_small  ." ". $get_row->small_unit;
	// 			$data[] = array(
	// 				'no'                  => $no,
	// 				'log_id'              => 1,
	// 				'item_name'           => $get_row->item_name,
	// 				'unit_contain'        => $unit_contain,
	// 				'group_name'          => $this->Groups_model->get_data(array('group_id' => $get_row->item_group_id))->row()->group_name,
	// 				'warehouse_name'      => $this->Warehouses_model->get_data(array('warehouse_id' => $get_row->header_to))->row()->warehouse_name,
	// 				'large_unit'          => $total_large,
	// 				'medium_unit'         => $total_medium,
	// 				'small_unit'          => $total_small,
	// 				// 'average_large_unit'  => $avg_large,
	// 				// 'average_medium_unit' => $avg_medium,
	// 				// 'average_small_unit'  => $avg_small,
	// 				// 'total_value'         => number_format($get_row->log_total_stock_value)
	// 			);
    //             $no++;
    //             // $total += $get_row->log_total_stock_value;
	// 		}
	// 	}
	// 	$this->session->set_userdata('item', $item);
	// 	$this->session->set_userdata('group', $group);
	// 	$this->session->set_userdata('status', $status);
	// 	$this->session->set_userdata('date_log', $date_log);
	// 	// $this->session->set_userdata('total', $total);

	// 	$response = [
	// 		'data'  => $data,
	// 		// 'total' => number_format($total)
	// 	];

	// 	output_json($response);
	// }

	public function get_data_detail_recap_warehouse()
	{	
		$item     = $this->input->post("item");
		$group    = $this->input->post("group");
		$status    = $this->input->post("status");
		$stock    = $this->input->post("stock");
		$date_log = $this->input->post("date_log");

        $data  = [];
        $where = [];
        $where_timestamp = date_now();

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
		}
		if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['b.item_group_id'] = $group;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where_timestamp = change_format_date($date_log);
		}
		if(isset($stock) && $stock != '' && $stock != '(Semua)')
		{
			if($stock == '1'){
				$where['a.log_total_stock >'] = '0';
			}else{
				$where['a.log_total_stock <='] = '0';
			}
		}

		
		
		$get_data = $this->Logs_model->get_data_detail_recap2($where, $where_timestamp)->result();
		$total = 0;
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			$warehouses = $this->Warehouses_model->get_data()->result();
			foreach($warehouses as $w){
				$rowspan = 1;
				foreach($get_data as $k => $get_row)
				{	
					$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
					$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
					$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

					$unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");

					//Calculate 

					$in_stock = 0;
					$ou_stock = 0;
					$total_stock = 0;

					// $warehouse = $this->Warehouses_model->get_data(array('is_default' => 1))->row()->warehouse_id;

					$get_stock_in = $this->Transfer_model->transfer_advance(array('header_to' => $w->warehouse_id, 'item_id' => $get_row->item_id), 'item_id, header_to')->row();
					$get_stock_ou = $this->Transfer_model->transfer_advance(array('header_from' => $w->warehouse_id, 'item_id' => $get_row->item_id), 'item_id, header_from')->row();

					if($get_stock_in){
						$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
					}

					if($get_stock_ou){
						$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
					}

					$total_stock = $in_stock - $ou_stock;


					// echo json_encode($total_stock);
					
					// $total_stock = (($get_row->large_qty * $get_row->large_unit_contain) + ($get_row->medium_qty * $get_row->medium_unit_contain) + ($get_row->small_qty * $get_row->small_unit_contain));

					$therest      = $total_stock;
					$total_large  = ($get_row->large_unit_contain == 0 ? '-' : floor($total_stock / $get_row->large_unit_contain));
					$therest      = ($therest - ($total_large * $get_row->large_unit_contain));
					$total_medium = ($get_row->medium_unit_contain == 0 ? '-' : floor($therest / $get_row->medium_unit_contain));
					$therest      = ($therest - ($total_medium * $get_row->medium_unit_contain));
					$total_small  = ($get_row->small_unit_contain == 0 ? '-' : floor($therest / $get_row->small_unit_contain));

					$lg_unit = $total_large  ." ". $get_row->large_unit;
					$md_unit = $total_medium ." ". $get_row->medium_unit;
					$sm_unit = $total_small  ." ". $get_row->small_unit;
					$data[] = array(
						'no'                  => $no,
						'detail_rowspan'      => $rowspan,
						'log_id'              => $get_row->log_id,
						'item_name'           => $get_row->item_name,
						'unit_contain'        => $unit_contain,
						'group_name'          => $get_row->group_name,
						'large_unit'          => $total_large,
						'medium_unit'         => $total_medium,
						'small_unit'          => $total_small,
						'warehouse_name'      => $w->warehouse_name,
						// 'average_large_unit'  => $avg_large,
						// 'average_medium_unit' => $avg_medium,
						// 'average_small_unit'  => $avg_small,
						'total_value'         => number_format($get_row->log_total_stock_value)
					);
					$no++;
					$rowspan++;
					$total += $get_row->log_total_stock_value;
				}
			}
		}
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('group', $group);
		$this->session->set_userdata('status', $status);
		$this->session->set_userdata('date_log', $date_log);
		$this->session->set_userdata('total', $total);

		$response = [
			'data'  => $data,
			'total' => number_format($total)
		];

		output_json($response);
	}

	public function export_excel_card() {

		$item     = $this->session->userdata('item');
		$date_log = $this->session->userdata('date_log');
		$status = $this->session->userdata('status');

		$data  = [];
        $where = [];
		$order = ("a.log_id ASC");

		$item_name  = '-';
		$date_text = ($date_log == '' ? '-' : change_format_date($date_log, 'd/m/Y'));

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}

		$get_data = $this->Logs_model->get_data_advance($where, $order)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("KARTU STOK")
							   ->setSubject("KARTU STOK")
							   ->setDescription("KARTU STOK")
							   ->setKeywords("KARTU STOK");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Kartu Stok");
	    $excel->getActiveSheet()->mergeCells('A1:M1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$date_text);
		
		$excel->getActiveSheet()->mergeCells('A6:A7');
		$excel->getActiveSheet()->mergeCells('B6:B7');
		$excel->getActiveSheet()->mergeCells('C6:C7');
		$excel->getActiveSheet()->mergeCells('D6:D7');

		$excel->getActiveSheet()->mergeCells('E6:G6');
		$excel->getActiveSheet()->mergeCells('H6:J6');
		$excel->getActiveSheet()->mergeCells('K6:M6');

		
	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Status");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "No. Transaksi");
		$excel->setActiveSheetIndex(0)->setCellValue('D6', "Supplier/Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Pemasukan");
		$excel->setActiveSheetIndex(0)->setCellValue('H6', "Pengeluaran");
		$excel->setActiveSheetIndex(0)->setCellValue('K6', "Stok");
		
		$excel->setActiveSheetIndex(0)->setCellValue('E7', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('F7', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('G7', "Kecil");
		$excel->setActiveSheetIndex(0)->setCellValue('H7', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('I7', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('J7', "Kecil");
		$excel->setActiveSheetIndex(0)->setCellValue('K7', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('L7', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('M7', "Kecil");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6:A7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6:B7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6:C7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D6:D7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E6:G6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H6:J6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K6:M6')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('E7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('M7')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 8; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$transaction_status = '';
				$transaction_number	= '';
				$transaction_actor	= '';
				$in_large   = '-';
				$in_medium  = '-';
				$in_small   = '-';
				$out_large  = '-';
				$out_medium = '-';
				$out_small  = '-';
				if($get_row->log_type == 'BUY'){

					$transaction_status = 'Beli';
					$transaction_number = $get_row->purchase_order_header_number;
					$transaction_actor  = $get_row->supplier_name;
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'SELL'){

					$transaction_status = 'Jual';
					$transaction_number = $get_row->sales_order_header_number;
					$transaction_actor  = $get_row->customer_name;
					$out_large  = $get_row->log_large_unit_quantity;
					$out_medium = $get_row->log_medium_unit_quantity;
					$out_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'R-BUY'){

					$transaction_status = 'Retur Beli';
					$transaction_number = $get_row->purchase_return_header_number;
					$transaction_actor  = $get_row->supplier_name;
					$out_large  = $get_row->log_large_unit_quantity;
					$out_medium = $get_row->log_medium_unit_quantity;
					$out_small  = $get_row->log_small_unit_quantity;

				}elseif($get_row->log_type == 'R-SELL'){

					$transaction_status = 'Retur Jual';
					$transaction_number = $get_row->sales_return_header_number;
					$transaction_actor  = $get_row->customer_name;
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}else{

					$transaction_status = 'Pengaturan Stok';
					$transaction_number = $get_row->stock_header_number;
					$transaction_actor  = '-';
					$in_large  = $get_row->log_large_unit_quantity;
					$in_medium = $get_row->log_medium_unit_quantity;
					$in_small  = $get_row->log_small_unit_quantity;

				}

				//Calculate 
                $therest      = $get_row->log_total_stock;
                $total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
                $therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
                $total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
                $therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
                $total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));
				
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, change_format_date($get_row->tms_log, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $transaction_status);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $transaction_number);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $transaction_actor);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $in_large);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $in_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $in_small);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $out_large);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $out_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $out_small);
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $total_large);
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, $total_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, $total_small);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':M'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('A'.$numrow.':M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			if($get_row->is_hold == '1'){
				$excel->getActiveSheet()->getStyle('A'.$numrow.':M'.$numrow)->applyFromArray($style_row_warning);
			}
	      	$no++; // Tambah 1 setiap kali looping
			$numrow++; // Tambah 1 setiap kali looping
			  
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("KARTU STOK");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'KARTUSTOK_'.$item_name.'_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_excel_recap() {

		$item     = $this->session->userdata('item');
		$group    = $this->session->userdata('group');
		$status    = $this->session->userdata('status');
		$date_log = $this->session->userdata('date_log');
		$total    = $this->session->userdata('total');

		$where = [];
		$item_name  = '-';
		$group_name = '-';
		
        $where_timestamp = date_now();

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['b.item_group_id'] = $group;
			$group_name = $this->Groups_model->get_data(array('group_id' => $group))->row()->group_name;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where_timestamp = change_format_date($date_log);
		}
		
		$get_data = $this->Logs_model->get_data_detail_recap($where, $where_timestamp)->result();


		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("REKAP STOK")
							   ->setSubject("REKAP STOK")
							   ->setDescription("REKAP STOK")
							   ->setKeywords("REKAP STOK");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$style_foo = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Rekap Stok");
	    $excel->getActiveSheet()->mergeCells('A1:J1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Grup");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$group_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".change_format_date($where_timestamp, 'd/m/Y'));
		
		$excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');

		$excel->getActiveSheet()->mergeCells('D7:F7');
		$excel->getActiveSheet()->mergeCells('G7:I7');

		$excel->getActiveSheet()->mergeCells('J7:J8');

		
	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Satuan & Isi");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Grup");
		$excel->setActiveSheetIndex(0)->setCellValue('D7', "Stok");
		$excel->setActiveSheetIndex(0)->setCellValue('G7', "Rata - rata");
		
		$excel->setActiveSheetIndex(0)->setCellValue('D8', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('E8', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('F8', "Kecil");
		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Kecil");
	
	    $excel->setActiveSheetIndex(0)->setCellValue('J7', "Total Nilai Rupiah");

		

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D7:F7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('G7:I7')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('D8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);

	    $excel->getActiveSheet()->getStyle('J7:J8')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
			$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
			$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

			$unit_contain = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");

			//Calculate 
			$therest      = $get_row->log_total_stock;
			$total_large  = ($get_row->log_large_unit_contain == 0 ? '-' : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));
			$therest      = ($therest - ($total_large * $get_row->log_large_unit_contain));
			$total_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : floor($therest / $get_row->log_medium_unit_contain));
			$therest      = ($therest - ($total_medium * $get_row->log_medium_unit_contain));
			$total_small  = ($get_row->log_small_unit_contain == 0 ? '-' : floor($therest / $get_row->log_small_unit_contain));

			// $avg_large  = ($get_row->log_large_unit_contain == 0 ? '-' : number_format($get_row->log_average_large_unit));
			// $avg_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : number_format($get_row->log_average_medium_unit));
			// $avg_small  = ($get_row->log_small_unit_contain == 0 ? '-' : number_format($get_row->log_average_small_unit));

			$avg_large  = ($get_row->log_large_unit_contain == 0 ? '-' : $get_row->log_average_large_unit);
			$avg_medium = ($get_row->log_medium_unit_contain == 0 ? '-' : $get_row->log_average_medium_unit);
			$avg_small  = ($get_row->log_small_unit_contain == 0 ? '-' : $get_row->log_average_small_unit);

			$lg_unit = $total_large  ." ". $get_row->log_large_unit;
			$md_unit = $total_medium ." ". $get_row->log_medium_unit;
			$sm_unit = $total_small  ." ". $get_row->log_small_unit;
				
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $total_large);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $total_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $total_small);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $avg_large);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $avg_medium);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $avg_small);
			// $excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, number_format($get_row->log_total_stock_value));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $get_row->log_total_stock_value);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':J'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('A'.$numrow.':F'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$excel->getActiveSheet()->getStyle('G'.$numrow.':J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}

		$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, "Total Keseluruhan");
		$excel->getActiveSheet()->mergeCells('A'.$numrow.':I'.$numrow);
		$excel->getActiveSheet()->getStyle('A'.$numrow.':I'.$numrow)->applyFromArray($style_foo);

		// $excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, number_format($total));
		$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $total);
		$excel->getActiveSheet()->getStyle('J'.$numrow)->applyFromArray($style_foo);
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("REKAP STOK");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'REKAPSTOK_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
