<?php
/**
 * Sales Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Sales extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_model');
		$this->load->model('Sales_orders_model');
	}
	
	public function index() {
		$data['content_title'] = 'Sales';

		$this->twiggy_display('adm/sales/index', $data);
	}

	public function get_data() {
		$data = [];
		$get_data = $this->Sales_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$so_data = false;
				$whe_salesorder = array('sales_id' => $get_row->sales_id);
				$get_salesorder = $this->Sales_orders_model->salesorder_header($whe_salesorder)->result();

				if($get_salesorder){
					$so_data = true;
				}

				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->sales_id,
					'code'         => $get_row->sales_code,
					'name'         => $get_row->sales_name,
					'telephone'    => $get_row->sales_telephone,
					'address'      => $get_row->sales_address,
					'username'     => $get_row->sales_username,
					'password'     => $get_row->sales_password,
					'pin'          => $get_row->sales_pin,
					'so_data'	   => $so_data,
					'status'	   => $get_row->sales_status,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('sales_id' => $id);
			$get_data = $this->Sales_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/sales/edit', $data);
	}

	public function save() {
		// post
		$id        = $this->input->post('id');
		$code      = $this->input->post('code');
		$name      = $this->input->post('name');
		$telephone = $this->input->post('telephone');
		$address   = $this->input->post('address');
		$username  = $this->input->post('username');
		$password  = $this->input->post('passwords');
		$pin       = $this->input->post('pin');
		$status    = $this->input->post('status');
		$action    = $this->input->post('action');

		$data_save = array(
			'sales_code'         => $code,
			'sales_name'         => $name,
			'sales_telephone'    => $telephone,
			'sales_address'      => $address,
			'sales_username'     => $username,
			'sales_password'     => $password,
			'sales_pin'          => $pin,
			'sales_status'       => $status,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Sales_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Sales_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Sales_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$username  = $this->input->post('id');
		$where     = array('sales_username' => $username);

		$check = $this->Sales_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
