<?php
/**
 * Materials Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Materials_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_materials a');
        $sql->join('master_units b', 'b.unit_id = a.material_unit_id', 'inner');
		$sql->order_by('material_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_search($search='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_materials a');
        $sql->join('master_units b', 'b.unit_id = a.material_unit_id', 'inner');
		$sql->order_by('material_name');

		if ($search != '')
		{
			$sql->like('material_code', $search);
			$sql->or_like('material_name', $search);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_materials', $data);
	}

	public function update($id, $data) {
		$this->db->where('material_id', $id);
		return $this->db->update('master_materials', $data);
	}

	public function delete($id) {
		$this->db->where('material_id', $id);
		return $this->db->delete('master_materials');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_materials');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
